/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingIconException;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractIconResourceFileNameMap
implements IconResourceFileNameMap {
    private final Map resourceFileNames = this.buildResourceFileNames();

    protected AbstractIconResourceFileNameMap() {
    }

    protected Map buildResourceFileNames() {
        String[][] stringArray = this.getEntries();
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string = stringArray2[0];
            String string2 = stringArray2[1];
            String string3 = hashMap.put(string, string2);
            if (string3 == null) continue;
            throw new IllegalStateException("An icon resource file name is already associated with the key \"" + string + "\" (previous: \"" + string3 + "\"; duplicate: \"" + string2 + "\"). Duplicates are not allowed.");
        }
        return hashMap;
    }

    protected abstract String[][] getEntries();

    public boolean hasResourceFileName(String string) {
        return this.resourceFileNames.containsKey(string);
    }

    public String getResourceFileName(String string) {
        String string2 = (String)this.resourceFileNames.get(string);
        if (string2 == null) {
            throw new MissingIconException("There is no icon resource file name associated with the key \"" + string + "\".", string);
        }
        return string2;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(this.resourceFileNames.size()) + " icons"));
    }
}

