/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingStringException;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ResourceBundleStringRepository
implements StringRepository {
    private ResourceBundle resourceBundle;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];

    public ResourceBundleStringRepository(String string) {
        this.initialize(string);
    }

    public ResourceBundleStringRepository(Class clazz) {
        this(clazz.getName());
    }

    protected void initialize(String string) {
        this.resourceBundle = ResourceBundle.getBundle(string);
        this.validate(this.resourceBundle);
    }

    protected void validate(ResourceBundle resourceBundle) {
        if (resourceBundle instanceof ListResourceBundle) {
            this.validate((ListResourceBundle)resourceBundle);
        }
    }

    protected void validate(ListResourceBundle listResourceBundle) {
        Object[][] objectArray = (Object[][])ClassTools.invokeMethod((Object)listResourceBundle, (String)"getContents");
        HashBag hashBag = new HashBag(objectArray.length);
        int n = objectArray.length;
        while (n-- > 0) {
            String string = (String)objectArray[n][0];
            if (hashBag.contains(string)) {
                throw new IllegalStateException("duplicate resource key: " + string);
            }
            hashBag.add(string);
        }
    }

    public boolean hasString(String string) {
        return string == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)string);
    }

    public String getString(String string) {
        return this.getString(string, EMPTY_ARGUMENTS);
    }

    public String getString(String string, Object object) {
        return this.getString(string, new Object[]{object});
    }

    public String getString(String string, Object object, Object object2) {
        return this.getString(string, new Object[]{object, object2});
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        return this.getString(string, new Object[]{object, object2, object3});
    }

    public String getString(String string, Object[] objectArray) {
        return this.format(this.get(string), objectArray);
    }

    protected String get(String string) {
        if (string == null) {
            return "";
        }
        try {
            return this.resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (missingResourceException.getKey().equals(string)) {
                throw new MissingStringException("Missing string: " + string, string);
            }
            throw missingResourceException;
        }
    }

    protected String format(String string, Object[] objectArray) {
        return string;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

