/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ClassChooserDialog
extends AbstractDialog {
    private ClassDescriptionRepository repository;
    private ClassDescriptionAdapter adapter;
    private ShortClassNameEntry[] shortClassNameEntries;
    private FilteringListPanel filteringPanel;
    private JList packageListBox;
    private MouseListener doubleClickMouseListener;
    Icon classIcon;
    Icon packageIcon;
    private Object initialSelection;
    private boolean allowNullSelection;
    private static final Object[] EMPTY_PACKAGE_LIST = new Object[0];

    public static ClassChooserDialog createDialog(ClassDescriptionRepository classDescriptionRepository, WorkbenchContext workbenchContext) {
        return ClassChooserDialog.createDialog(classDescriptionRepository, DefaultClassDescriptionAdapter.instance(), workbenchContext);
    }

    public static ClassChooserDialog createDialog(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext workbenchContext) {
        Window window = workbenchContext.getCurrentWindow();
        if (window instanceof Dialog) {
            return new ClassChooserDialog(classDescriptionRepository, classDescriptionAdapter, workbenchContext, (Dialog)window);
        }
        return new ClassChooserDialog(classDescriptionRepository, classDescriptionAdapter, workbenchContext);
    }

    private static String title(ApplicationContext applicationContext) {
        return applicationContext.getResourceRepository().getString("CLASS_CHOOSER_DIALOG.TITLE");
    }

    private ClassChooserDialog(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext workbenchContext) {
        super(workbenchContext, ClassChooserDialog.title(workbenchContext.getApplicationContext()));
        this.initialize(classDescriptionRepository, classDescriptionAdapter);
    }

    private ClassChooserDialog(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext workbenchContext, Dialog dialog) {
        super(workbenchContext, ClassChooserDialog.title(workbenchContext.getApplicationContext()), dialog);
        this.initialize(classDescriptionRepository, classDescriptionAdapter);
    }

    private void initialize(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter) {
        this.repository = classDescriptionRepository;
        this.adapter = classDescriptionAdapter;
        this.shortClassNameEntries = this.buildShortClassNameEntries();
        this.doubleClickMouseListener = this.buildDoubleClickMouseListener();
        this.classIcon = this.resourceRepository().getIcon("class.public");
        this.packageIcon = this.resourceRepository().getIcon("package");
        this.allowNullSelection = false;
    }

    private ShortClassNameEntry[] buildShortClassNameEntries() {
        Object object;
        Collator collator = Collator.getInstance();
        HashMap hashMap = new HashMap(20000);
        Object object2 = this.repository.classDescriptions();
        while (object2.hasNext()) {
            object = object2.next();
            this.shortClassNameEntry(object, hashMap, collator).addPackageEntry(new PackageEntry(object, this.adapter, collator));
        }
        object2 = hashMap.values();
        object = object2.toArray(new ShortClassNameEntry[object2.size()]);
        Arrays.sort(object);
        return object;
    }

    private ShortClassNameEntry shortClassNameEntry(Object object, Map map, Collator collator) {
        String string = this.adapter.shortClassName(object).replace('$', '.');
        ShortClassNameEntry shortClassNameEntry = (ShortClassNameEntry)map.get(string);
        if (shortClassNameEntry == null) {
            shortClassNameEntry = new ShortClassNameEntry(string, collator);
            map.put(string, shortClassNameEntry);
        }
        return shortClassNameEntry;
    }

    private MouseListener buildDoubleClickMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ClassChooserDialog.this.clickOK();
                }
            }
        };
    }

    private Action buildRefreshAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            protected void initialize() {
                this.initializeTextAndMnemonic("CLASS_CHOOSER_DIALOG.REFRESH_BUTTON");
            }

            protected void execute() {
                ClassChooserDialog.this.refresh();
            }
        };
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.filteringPanel = new FilteringListPanel(this.shortClassNameEntries, null, new ShortClassNameEntryStringConverter());
        this.configureLabel(this.filteringPanel.getTextFieldLabel(), "CLASS_CHOOSER_DIALOG.TEXT_FIELD_LABEL");
        this.configureLabel(this.filteringPanel.getListBoxLabel(), "CLASS_CHOOSER_DIALOG.CLASS_LIST_BOX_LABEL");
        this.filteringPanel.setListBoxCellRenderer(this.buildClassListCellRenderer());
        this.filteringPanel.getListBox().getSelectionModel().addListSelectionListener(this.buildClassListSelectionListener());
        this.filteringPanel.getListBox().addMouseListener(this.doubleClickMouseListener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.filteringPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        this.configureLabel(jLabel, "CLASS_CHOOSER_DIALOG.PACKAGE_LIST_BOX_LABEL");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel2.add((Component)jLabel, "First");
        this.packageListBox = SwingComponentFactory.buildList();
        this.packageListBox.setDoubleBuffered(true);
        this.packageListBox.setCellRenderer(this.buildPackageListCellRenderer());
        this.packageListBox.getSelectionModel().setSelectionMode(0);
        this.packageListBox.getSelectionModel().addListSelectionListener(this.buildPackageListSelectionListener());
        this.packageListBox.addMouseListener(this.doubleClickMouseListener);
        jLabel.setLabelFor(this.packageListBox);
        jPanel2.add((Component)new JScrollPane(this.packageListBox), "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private void configureLabel(JLabel jLabel, String string) {
        jLabel.setText(this.resourceRepository().getString(string));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic(string));
    }

    private ListCellRenderer buildClassListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected Icon buildIcon(Object object) {
                return ClassChooserDialog.this.classIcon;
            }

            protected String buildText(Object object) {
                return ((ShortClassNameEntry)object).getName();
            }
        };
    }

    private ListSelectionListener buildClassListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ClassChooserDialog.this.classSelectionChanged(listSelectionEvent);
                }
            }
        };
    }

    private ListCellRenderer buildPackageListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected Icon buildIcon(Object object) {
                return ClassChooserDialog.this.packageIcon;
            }

            protected String buildText(Object object) {
                return ((PackageEntry)object).getDisplayString();
            }
        };
    }

    private ListSelectionListener buildPackageListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ClassChooserDialog.this.packageSelectionChanged(listSelectionEvent);
                }
            }
        };
    }

    protected Action buildOKAction() {
        Action action = super.buildOKAction();
        action.setEnabled(false);
        return action;
    }

    protected Iterator buildCustomActions() {
        return new SingleElementIterator((Object)this.buildRefreshAction());
    }

    protected String helpTopicId() {
        return "dialog.classChooser";
    }

    protected Component initialFocusComponent() {
        return this.filteringPanel.getTextField();
    }

    protected void prepareToShow() {
        this.pack();
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.max(dimension.width, 350);
        dimension.height = Math.max(dimension.height, 566);
        this.setSize(dimension);
        this.setLocationRelativeTo(this.getParent());
        if (this.initialSelection != null) {
            this.setInitialSelectionInternal(this.initialSelection);
        }
    }

    protected void clickOK() {
        super.clickOK();
    }

    private void setInitialSelectionInternal(Object object) {
        ShortClassNameEntry[] shortClassNameEntryArray = this.shortClassNameEntries;
        int n = shortClassNameEntryArray.length;
        while (n-- > 0) {
            ShortClassNameEntry shortClassNameEntry = shortClassNameEntryArray[n];
            PackageEntry packageEntry = shortClassNameEntry.packageEntryFor(object);
            if (packageEntry == null) continue;
            this.filteringPanel.setSelection(shortClassNameEntry);
            this.packageListBox.setSelectedValue(packageEntry, true);
            break;
        }
    }

    void classSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object object = this.filteringPanel.getSelection();
        if (object == null) {
            this.packageListBox.setListData(EMPTY_PACKAGE_LIST);
        } else {
            this.packageListBox.setListData(((ShortClassNameEntry)object).getPackageEntries());
            this.packageListBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.packageListBox.getSelectionModel().setLeadSelectionIndex(0);
        }
    }

    void packageSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.packageListBox.ensureIndexIsVisible(listSelectionEvent.getFirstIndex());
        this.getOKAction().setEnabled(this.allowNullSelection || this.packageListBox.getSelectedValue() != null);
    }

    void refresh() {
        this.repository.refreshClassDescriptions();
        this.shortClassNameEntries = this.buildShortClassNameEntries();
        this.filteringPanel.setCompleteList(this.shortClassNameEntries);
    }

    public void setAllowNullSelection(boolean bl) {
        this.allowNullSelection = bl;
    }

    public void setInitialSelection(Object object) {
        this.initialSelection = object;
    }

    public Object selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        PackageEntry packageEntry = (PackageEntry)this.packageListBox.getSelectedValue();
        return packageEntry == null ? null : packageEntry.getClassDescription();
    }

    public static void gc() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                System.gc();
            }
        };
        thread.start();
    }

    private static class PackageEntry
    implements Comparable {
        private Object classDescription;
        private String name;
        private String additionalInfo;
        private boolean displaysAdditionalInfo;
        private String displayString;
        private Collator collator;

        PackageEntry(Object object, ClassDescriptionAdapter classDescriptionAdapter, Collator collator) {
            this.classDescription = object;
            this.name = classDescriptionAdapter.packageName(object);
            this.additionalInfo = classDescriptionAdapter.additionalInfo(this.classDescription);
            this.displaysAdditionalInfo = false;
            this.displayString = this.buildDisplayString();
            this.collator = collator;
        }

        private String buildDisplayString() {
            if (!this.displaysAdditionalInfo || this.additionalInfo == null || this.additionalInfo.length() == 0) {
                return this.name;
            }
            return this.name + " - " + this.additionalInfo;
        }

        Object getClassDescription() {
            return this.classDescription;
        }

        String getName() {
            return this.name;
        }

        String getAdditionalInfo() {
            return this.additionalInfo;
        }

        boolean displaysAdditionalInfo() {
            return this.displaysAdditionalInfo;
        }

        void setDisplaysAdditionalInfo(boolean bl) {
            if (this.displaysAdditionalInfo == bl) {
                return;
            }
            this.displaysAdditionalInfo = bl;
            this.displayString = this.buildDisplayString();
        }

        String getDisplayString() {
            return this.displayString;
        }

        boolean isEntryFor(Object object) {
            return this.classDescription == object;
        }

        public int compareTo(Object object) {
            int n = this.collator.compare(this.name, ((PackageEntry)object).name);
            if (n != 0) {
                return n;
            }
            return this.collator.compare(this.displayString, ((PackageEntry)object).displayString);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.displayString);
        }
    }

    private class ShortClassNameEntryStringConverter
    implements StringConverter {
        private ShortClassNameEntryStringConverter() {
        }

        public String convertToString(Object object) {
            return object == null ? null : ((ShortClassNameEntry)object).getName();
        }
    }

    private static class ShortClassNameEntry
    implements Comparable {
        private String name;
        private CollationKey collationKey;
        private PackageEntry[] packageEntries;

        ShortClassNameEntry(String string, Collator collator) {
            this.name = string;
            this.collationKey = collator.getCollationKey(string);
            this.packageEntries = new PackageEntry[1];
        }

        String getName() {
            return this.name;
        }

        PackageEntry[] getPackageEntries() {
            return this.packageEntries;
        }

        void addPackageEntry(PackageEntry packageEntry) {
            if (this.packageEntries[0] == null) {
                this.packageEntries[0] = packageEntry;
            } else {
                this.addSubsequentPackageEntry(packageEntry);
            }
        }

        private void addSubsequentPackageEntry(PackageEntry packageEntry) {
            int n;
            String string = packageEntry.getName();
            PackageEntry[] packageEntryArray = this.packageEntries;
            int n2 = n = packageEntryArray.length;
            while (n2-- > 0) {
                if (!packageEntryArray[n2].getName().equals(string)) continue;
                packageEntryArray[n2].setDisplaysAdditionalInfo(true);
                packageEntry.setDisplaysAdditionalInfo(true);
            }
            Object[] objectArray = new PackageEntry[n + 1];
            System.arraycopy(packageEntryArray, 0, objectArray, 0, n);
            objectArray[n] = packageEntry;
            Arrays.sort(objectArray);
            this.packageEntries = objectArray;
        }

        PackageEntry packageEntryFor(Object object) {
            int n;
            PackageEntry[] packageEntryArray = this.packageEntries;
            int n2 = n = packageEntryArray.length;
            while (n2-- > 0) {
                if (!packageEntryArray[n2].isEntryFor(object)) continue;
                return packageEntryArray[n2];
            }
            return null;
        }

        public int compareTo(Object object) {
            return this.collationKey.compareTo(((ShortClassNameEntry)object).collationKey);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.name);
        }
    }
}

