/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.text.CollationKey;
import java.util.Collection;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackageNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackagePoolNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;

public final class ClassDescriptionNode
extends AbstractTreeNodeValueModel
implements Displayable,
ClassDescriptionNodeContainer {
    private ClassDescriptionPackageNode packageNode;
    private Object userClassDescription;
    private String packageName;
    private String shortClassName;
    private String additionalInfo;
    private CollationKey collationKey;

    ClassDescriptionNode(Object object, ClassDescriptionAdapter classDescriptionAdapter) {
        this.userClassDescription = object;
        this.packageName = classDescriptionAdapter.packageName(object);
        this.shortClassName = classDescriptionAdapter.shortClassName(object).replace('$', '.');
        this.additionalInfo = classDescriptionAdapter.additionalInfo(object);
    }

    ClassDescriptionPackageNode getPackageNode() {
        return this.packageNode;
    }

    void setPackageNode(ClassDescriptionPackageNode classDescriptionPackageNode) {
        if (this.packageNode == null) {
            this.collationKey = classDescriptionPackageNode.collator().getCollationKey(this.shortClassName);
        }
        this.packageNode = classDescriptionPackageNode;
    }

    public Object getUserClassDescription() {
        return this.userClassDescription;
    }

    String getPackageName() {
        return this.packageName;
    }

    String getShortClassName() {
        return this.shortClassName;
    }

    String getAdditionalInfo() {
        return this.additionalInfo;
    }

    boolean belongsInPackageNode(ClassDescriptionPackageNode classDescriptionPackageNode) {
        if (!this.packageName.equals(classDescriptionPackageNode.getName())) {
            return false;
        }
        return this.valuesAreEqual(this.additionalInfo, classDescriptionPackageNode.getAdditionalInfo());
    }

    ClassDescriptionPackageNode buildPackageNode(ClassDescriptionPackagePoolNode classDescriptionPackagePoolNode) {
        ClassDescriptionPackageNode classDescriptionPackageNode = new ClassDescriptionPackageNode(classDescriptionPackagePoolNode, this.packageName, this.additionalInfo);
        if (this.packageNode != null) {
            classDescriptionPackageNode.setDisplaysAdditionalInfo(this.packageNode.displaysAdditionalInfo());
        }
        return classDescriptionPackageNode;
    }

    public Object getValue() {
        return this.userClassDescription;
    }

    public TreeNodeValueModel getParent() {
        return this.packageNode;
    }

    public ListValueModel getChildrenModel() {
        return NullListValueModel.instance();
    }

    protected void engageValue() {
    }

    protected void disengageValue() {
    }

    public void addClassDescriptionNodesTo(Collection collection) {
        collection.add(this);
    }

    public int compareTo(Object object) {
        return this.collationKey.compareTo(((ClassDescriptionNode)object).collationKey);
    }

    public String displayString() {
        return this.shortClassName;
    }

    public Icon icon() {
        return this.packageNode.classIcon();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.shortClassName);
    }
}

