/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackagePoolNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class ClassDescriptionPackageNode
extends AbstractTreeNodeValueModel
implements Displayable,
ClassDescriptionNodeContainer {
    private ClassDescriptionPackagePoolNode poolNode;
    private String name;
    private CollationKey nameCollationKey;
    private String additionalInfo;
    private boolean displaysAdditionalInfo;
    private String displayString;
    private ListValueModel classNodesHolder;
    private ListValueModel sortedClassNodesHolder;

    ClassDescriptionPackageNode(ClassDescriptionPackagePoolNode classDescriptionPackagePoolNode, String string, String string2) {
        this.poolNode = classDescriptionPackagePoolNode;
        this.name = string;
        this.nameCollationKey = this.poolNode.getCollator().getCollationKey(string);
        this.additionalInfo = string2;
        this.displaysAdditionalInfo = false;
        this.displayString = this.buildDisplayString();
        this.classNodesHolder = new SimpleListValueModel(new ArrayList(100));
        this.sortedClassNodesHolder = new SortedListValueModelAdapter(this.classNodesHolder);
    }

    ClassDescriptionPackagePoolNode getPoolNode() {
        return this.poolNode;
    }

    void setPoolNode(ClassDescriptionPackagePoolNode classDescriptionPackagePoolNode) {
        this.poolNode = classDescriptionPackagePoolNode;
    }

    String getName() {
        return this.name;
    }

    String getAdditionalInfo() {
        return this.additionalInfo;
    }

    boolean displaysAdditionalInfo() {
        return this.displaysAdditionalInfo;
    }

    void setDisplaysAdditionalInfo(boolean bl) {
        if (this.displaysAdditionalInfo == bl) {
            return;
        }
        this.displaysAdditionalInfo = bl;
        this.displayString = this.buildDisplayString();
    }

    ListIterator classNodes() {
        return (ListIterator)this.classNodesHolder.getValue();
    }

    int classNodesSize() {
        return this.classNodesHolder.size();
    }

    void addClassNode(ClassDescriptionNode classDescriptionNode) {
        classDescriptionNode.setPackageNode(this);
        this.classNodesHolder.addItem(this.classNodesHolder.size(), classDescriptionNode);
    }

    void removeClassNode(ClassDescriptionNode classDescriptionNode) {
        this.classNodesHolder.removeItem(this.indexOfClassNode(classDescriptionNode));
    }

    private int indexOfClassNode(ClassDescriptionNode classDescriptionNode) {
        int n = this.classNodesHolder.size();
        for (int i = 0; i < n; ++i) {
            if (this.classNodesHolder.getItem(i) != classDescriptionNode) continue;
            return i;
        }
        return -1;
    }

    boolean isEmpty() {
        return this.classNodesSize() == 0;
    }

    Icon classIcon() {
        return this.poolNode.getClassIcon();
    }

    Collator collator() {
        return this.poolNode.getCollator();
    }

    public Object getValue() {
        return this.displayString;
    }

    public TreeNodeValueModel getParent() {
        return this.poolNode;
    }

    public ListValueModel getChildrenModel() {
        return this.sortedClassNodesHolder;
    }

    protected void engageValue() {
    }

    protected void disengageValue() {
    }

    public void addClassDescriptionNodesTo(Collection collection) {
        CollectionTools.addAll((Collection)collection, (Iterator)this.classNodes());
    }

    public int compareTo(Object object) {
        int n = this.nameCollationKey.compareTo(((ClassDescriptionPackageNode)object).nameCollationKey);
        if (n != 0) {
            return n;
        }
        return this.poolNode.getCollator().compare(this.displayString, ((ClassDescriptionPackageNode)object).displayString);
    }

    public String displayString() {
        return this.displayString;
    }

    private String buildDisplayString() {
        if (!this.displaysAdditionalInfo || this.additionalInfo == null || this.additionalInfo.length() == 0) {
            return this.name;
        }
        return this.name + " - " + this.additionalInfo;
    }

    public Icon icon() {
        return this.poolNode.getPackageIcon();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.displayString);
    }
}

