/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNode;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionNodeContainer;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionPackageNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class ClassDescriptionPackagePoolNode
extends AbstractTreeNodeValueModel
implements Displayable,
ClassDescriptionNodeContainer {
    private Object value = new Object();
    private String name;
    private ListValueModel packageNodesHolder;
    private ListValueModel sortedPackageNodesHolder;
    private Icon packageIcon;
    private Icon classIcon;
    private Collator collator;

    public ClassDescriptionPackagePoolNode(String string, Iterator iterator, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext workbenchContext) {
        this(string, iterator, classDescriptionAdapter, Collections.EMPTY_SET, workbenchContext);
    }

    public ClassDescriptionPackagePoolNode(String string, Iterator iterator, ClassDescriptionAdapter classDescriptionAdapter, Collection collection, WorkbenchContext workbenchContext) {
        this.name = string;
        this.packageIcon = workbenchContext.getApplicationContext().getResourceRepository().getIcon("package");
        this.classIcon = workbenchContext.getApplicationContext().getResourceRepository().getIcon("class.public");
        this.collator = Collator.getInstance();
        this.initialize(iterator, classDescriptionAdapter, collection);
    }

    private void initialize(Iterator iterator, ClassDescriptionAdapter classDescriptionAdapter, Collection collection) {
        this.packageNodesHolder = new SimpleListValueModel(new ArrayList(1000));
        this.addUserClassDescriptions(iterator, classDescriptionAdapter, collection);
        this.removeEmptyPackageNodes();
        this.sortedPackageNodesHolder = new SortedListValueModelAdapter(this.packageNodesHolder);
    }

    private void addUserClassDescriptions(Iterator iterator, ClassDescriptionAdapter classDescriptionAdapter, Collection collection) {
        HashMap hashMap = new HashMap(1000);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            this.addClassNode(new ClassDescriptionNode(e, classDescriptionAdapter), hashMap);
        }
    }

    private void removeEmptyPackageNodes() {
        List list = CollectionTools.list((Iterator)this.emptyPackageNodes());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removePackageNode((ClassDescriptionPackageNode)iterator.next());
        }
    }

    private Iterator emptyPackageNodes() {
        return new FilteringIterator(this.packageNodes()){

            public boolean accept(Object object) {
                return ((ClassDescriptionPackageNode)object).isEmpty();
            }
        };
    }

    ListIterator packageNodes() {
        return (ListIterator)this.packageNodesHolder.getValue();
    }

    int packageNodesSize() {
        return this.packageNodesHolder.size();
    }

    void addClassNode(ClassDescriptionNode classDescriptionNode) {
        this.addClassNode(classDescriptionNode, null);
    }

    void addClassNode(ClassDescriptionNode classDescriptionNode, Map map) {
        this.getPackageNodeFor(classDescriptionNode, map).addClassNode(classDescriptionNode);
    }

    void removeClassNode(ClassDescriptionNode classDescriptionNode) {
        ClassDescriptionPackageNode classDescriptionPackageNode = this.getPackageNodeFor(classDescriptionNode, null);
        classDescriptionPackageNode.removeClassNode(classDescriptionNode);
        if (classDescriptionPackageNode.isEmpty()) {
            this.removePackageNode(classDescriptionPackageNode);
        }
    }

    private void removePackageNode(ClassDescriptionPackageNode classDescriptionPackageNode) {
        this.packageNodesHolder.removeItem(this.indexOfPackageNode(classDescriptionPackageNode));
        classDescriptionPackageNode.setPoolNode(null);
    }

    private int indexOfPackageNode(ClassDescriptionPackageNode classDescriptionPackageNode) {
        int n = this.packageNodesHolder.size();
        for (int i = 0; i < n; ++i) {
            if (this.packageNodesHolder.getItem(i) != classDescriptionPackageNode) continue;
            return i;
        }
        return -1;
    }

    private ClassDescriptionPackageNode getPackageNodeFor(ClassDescriptionNode classDescriptionNode, Map map) {
        ClassDescriptionPackageNode classDescriptionPackageNode = null;
        Object object = this.packageNodes();
        while (object.hasNext()) {
            ClassDescriptionPackageNode classDescriptionPackageNode2 = (ClassDescriptionPackageNode)object.next();
            if (!classDescriptionNode.belongsInPackageNode(classDescriptionPackageNode2)) continue;
            classDescriptionPackageNode = classDescriptionPackageNode2;
            break;
        }
        if (classDescriptionPackageNode == null) {
            classDescriptionPackageNode = classDescriptionNode.buildPackageNode(this);
            if (map != null && (object = map.put(classDescriptionPackageNode.getName(), classDescriptionPackageNode)) != null) {
                ((ClassDescriptionPackageNode)object).setDisplaysAdditionalInfo(true);
                classDescriptionPackageNode.setDisplaysAdditionalInfo(true);
            }
            this.packageNodesHolder.addItem(this.packageNodesHolder.size(), classDescriptionPackageNode);
        }
        return classDescriptionPackageNode;
    }

    Icon getPackageIcon() {
        return this.packageIcon;
    }

    Icon getClassIcon() {
        return this.classIcon;
    }

    Collator getCollator() {
        return this.collator;
    }

    public Object getValue() {
        return this.value;
    }

    public TreeNodeValueModel getParent() {
        return null;
    }

    public ListValueModel getChildrenModel() {
        return this.sortedPackageNodesHolder;
    }

    protected void engageValue() {
    }

    protected void disengageValue() {
    }

    public void addClassDescriptionNodesTo(Collection collection) {
        ListIterator listIterator = this.packageNodes();
        while (listIterator.hasNext()) {
            ((ClassDescriptionPackageNode)listIterator.next()).addClassDescriptionNodesTo(collection);
        }
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }

    public String displayString() {
        return this.name;
    }

    public Icon icon() {
        return null;
    }

    Iterator classNodes() {
        return new CompositeIterator((Iterator)new TransformationIterator(this.packageNodes()){

            protected Object transform(Object object) {
                return ((ClassDescriptionPackageNode)object).classNodes();
            }
        });
    }

    Iterator userClassDescriptions() {
        return new TransformationIterator(this.classNodes()){

            protected Object transform(Object object) {
                return ((ClassDescriptionNode)object).getUserClassDescription();
            }
        };
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }
}

