/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.NonCachingComboBoxModel;

public class DefaultListChooser
extends ListChooser {
    private WorkbenchContextHolder contextHolder;
    private DefaultListChooserDialog.Builder builder;

    protected DefaultListChooser(ComboBoxModel comboBoxModel) {
        super(new NonCachingComboBoxModel(comboBoxModel));
    }

    public DefaultListChooser(ComboBoxModel comboBoxModel, WorkbenchContextHolder workbenchContextHolder) {
        this(new NonCachingComboBoxModel(comboBoxModel), workbenchContextHolder, DefaultListChooserDialog.Builder.DEFAULT_INSTANCE);
    }

    public DefaultListChooser(CachingComboBoxModel cachingComboBoxModel, WorkbenchContextHolder workbenchContextHolder, DefaultListChooserDialog.Builder builder) {
        this((ComboBoxModel)cachingComboBoxModel);
        this.initialize(workbenchContextHolder);
        this.builder = builder;
    }

    public DefaultListChooser(ComboBoxModel comboBoxModel, WorkbenchContextHolder workbenchContextHolder, DefaultListChooserDialog.Builder builder) {
        this(new NonCachingComboBoxModel(comboBoxModel), workbenchContextHolder, builder);
    }

    public DefaultListChooser(ComboBoxModel comboBoxModel, WorkbenchContextHolder workbenchContextHolder, NodeSelector nodeSelector) {
        this(new NonCachingComboBoxModel(comboBoxModel), workbenchContextHolder, nodeSelector, DefaultListChooserDialog.Builder.DEFAULT_INSTANCE);
    }

    public DefaultListChooser(CachingComboBoxModel cachingComboBoxModel, WorkbenchContextHolder workbenchContextHolder, NodeSelector nodeSelector, DefaultListChooserDialog.Builder builder) {
        super(cachingComboBoxModel, nodeSelector);
        this.initialize(workbenchContextHolder);
        this.builder = builder;
    }

    public DefaultListChooser(ComboBoxModel comboBoxModel, WorkbenchContextHolder workbenchContextHolder, NodeSelector nodeSelector, DefaultListChooserDialog.Builder builder) {
        this(new NonCachingComboBoxModel(comboBoxModel), workbenchContextHolder, nodeSelector, builder);
    }

    protected void initialize(WorkbenchContextHolder workbenchContextHolder) {
        this.contextHolder = workbenchContextHolder;
        JMenuItem jMenuItem = new JMenuItem(this.resourceRepository().getString("SELECT_IN_NAVIGATOR_POPUP_MENU_ITEM"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem.addActionListener(this.buildGoToListener());
        this.getHelpManager().addItemsToPopupMenuForComponent(new JMenuItem[]{jMenuItem}, this);
    }

    protected void browse() {
        DefaultListChooserDialog defaultListChooserDialog = this.buildDialog();
        defaultListChooserDialog.show();
        if (defaultListChooserDialog.wasConfirmed()) {
            this.getModel().setSelectedItem(defaultListChooserDialog.selection());
        }
    }

    protected DefaultListChooserDialog buildDialog() {
        if (this.builder.getListCellRenderer() == null) {
            this.builder.setListCellRenderer(this.getRenderer());
        }
        return this.builder.buildDialog(this.getWorkbenchContext(), this.convertToArray(this.getModel()), this.getModel().getSelectedItem());
    }

    protected Object[] convertToArray(ListModel listModel) {
        int n = listModel.getSize();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = listModel.getElementAt(i);
        }
        return objectArray;
    }

    private ActionListener buildGoToListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListChooser.this.goToSelectedItem();
            }
        };
    }

    protected HelpManager getHelpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    protected ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    protected WorkbenchContext getWorkbenchContext() {
        return this.contextHolder.getWorkbenchContext();
    }

    protected ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }
}

