/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class DefaultListChooserDialog
extends AbstractDialog {
    private FilteringListPanel filteringListPanel;
    Builder builder;

    public DefaultListChooserDialog(WorkbenchContext workbenchContext, Builder builder) {
        super(workbenchContext);
        this.builder = builder;
        this.initialize2();
    }

    public DefaultListChooserDialog(WorkbenchContext workbenchContext, Dialog dialog, Builder builder) {
        super(workbenchContext, dialog);
        this.builder = builder;
        this.initialize2();
    }

    protected void initialize2() {
        this.setTitle(this.resourceRepository().getString(this.builder.getTitleKey()));
        this.filteringListPanel = this.buildFilteringListPanel();
    }

    protected FilteringListPanel buildFilteringListPanel() {
        FilteringListPanel filteringListPanel = new FilteringListPanel(this.builder.getCompleteList(), this.builder.getInitialSelection(), this.builder.getStringConverter()){

            protected ListCellRenderer buildDefaultCellRenderer() {
                if (DefaultListChooserDialog.this.builder.getListCellRenderer() != null) {
                    return DefaultListChooserDialog.this.builder.getListCellRenderer();
                }
                return super.buildDefaultCellRenderer();
            }
        };
        this.helpManager().addTopicID(filteringListPanel.getTextField(), this.builder.getHelpTopicId());
        this.helpManager().addTopicID(filteringListPanel.getListBox(), this.builder.getHelpTopicId());
        this.configureLabel(filteringListPanel.getTextFieldLabel(), this.builder.getTextFieldLabelKey());
        this.configureLabel(filteringListPanel.getListBoxLabel(), this.builder.getListBoxLabelKey());
        filteringListPanel.getListBox().addListSelectionListener(this.buildListBoxSelectionListener());
        filteringListPanel.getListBox().addMouseListener(this.buildListBoxMouseListener());
        return filteringListPanel;
    }

    protected void configureLabel(JLabel jLabel, String string) {
        jLabel.setText(this.resourceRepository().getString(string));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic(string));
    }

    protected MouseListener buildListBoxMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DefaultListChooserDialog.this.clickOK();
                }
            }
        };
    }

    protected ListSelectionListener buildListBoxSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DefaultListChooserDialog.this.updateOK();
                }
            }
        };
    }

    protected void clickOK() {
        super.clickOK();
    }

    protected void updateOK() {
        this.getOKAction().setEnabled(!this.filteringListPanel.getListBox().isSelectionEmpty());
    }

    protected Component buildMainPanel() {
        return this.filteringListPanel;
    }

    protected String helpTopicId() {
        return this.builder.getHelpTopicId();
    }

    protected Component initialFocusComponent() {
        return this.filteringListPanel.getTextField();
    }

    protected void prepareToShow() {
        this.setSize(300, 485);
        this.setLocationRelativeTo(this.getParent());
        this.updateOK();
    }

    public FilteringListPanel getFilteringListPanel() {
        return this.filteringListPanel;
    }

    public Object selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return this.filteringListPanel.getSelection();
    }

    public static class Builder
    implements Cloneable {
        private Object[] completeList;
        private Object initialSelection;
        private StringConverter stringConverter;
        private ListCellRenderer listCellRenderer;
        private String titleKey;
        private String textFieldLabelKey;
        private String listBoxLabelKey;
        private String helpTopicId;
        static Builder DEFAULT_INSTANCE = new Builder();

        public Builder() {
            this.initialize();
        }

        protected void initialize() {
            this.completeList = null;
            this.initialSelection = null;
            this.stringConverter = StringConverter.DEFAULT_INSTANCE;
            this.titleKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.TITLE";
            this.textFieldLabelKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.TEXT_FIELD_LABEL";
            this.listBoxLabelKey = "DEFAULT_LONG_LIST_BROWSER_DIALOG.LIST_BOX_LABEL";
            this.helpTopicId = "default";
        }

        public DefaultListChooserDialog buildDialog(WorkbenchContext workbenchContext, Object[] objectArray, Object object) {
            return this.buildDialog(workbenchContext, (Builder)this.clone(), objectArray, object);
        }

        protected Object clone() {
            Builder builder;
            try {
                builder = (Builder)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            return builder;
        }

        protected DefaultListChooserDialog buildDialog(WorkbenchContext workbenchContext, Builder builder, Object[] objectArray, Object object) {
            if (builder.getCompleteList() == null) {
                builder.setCompleteList(objectArray);
            }
            if (builder.getInitialSelection() == null) {
                builder.setInitialSelection(object);
            }
            if (workbenchContext.getCurrentWindow() instanceof Dialog) {
                return new DefaultListChooserDialog(workbenchContext, (Dialog)workbenchContext.getCurrentWindow(), builder);
            }
            return new DefaultListChooserDialog(workbenchContext, builder);
        }

        public void setTitleKey(String string) {
            this.titleKey = string;
        }

        public String getTitleKey() {
            return this.titleKey;
        }

        public void setTextFieldLabelKey(String string) {
            this.textFieldLabelKey = string;
        }

        public String getTextFieldLabelKey() {
            return this.textFieldLabelKey;
        }

        public void setListBoxLabelKey(String string) {
            this.listBoxLabelKey = string;
        }

        public String getListBoxLabelKey() {
            return this.listBoxLabelKey;
        }

        public String getHelpTopicId() {
            return this.helpTopicId;
        }

        public void setHelpTopicId(String string) {
            this.helpTopicId = string;
        }

        public Object[] getCompleteList() {
            return this.completeList;
        }

        public void setCompleteList(Object[] objectArray) {
            this.completeList = objectArray;
        }

        public Object getInitialSelection() {
            return this.initialSelection;
        }

        public void setInitialSelection(Object object) {
            this.initialSelection = object;
        }

        public StringConverter getStringConverter() {
            return this.stringConverter;
        }

        public void setStringConverter(StringConverter stringConverter) {
            this.stringConverter = stringConverter;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.listCellRenderer;
        }

        public void setListCellRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }
    }
}

