/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WindowWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExpandablePane;
import org.eclipse.persistence.tools.workbench.uitools.swing.TriStateCheckBox;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

public abstract class AbstractDialog
extends JDialog
implements SwingConstants {
    private WorkbenchContext context;
    protected AbstractPanel container;
    private JPanel customButtonPanel;
    private JPanel rightButtonPanel;
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private Map buttons;
    private boolean built = false;
    private boolean wasConfirmed;

    protected AbstractDialog(WorkbenchContext workbenchContext) {
        this(workbenchContext, (String)null);
    }

    protected AbstractDialog(WorkbenchContext workbenchContext, String string) {
        super((Frame)workbenchContext.getCurrentWindow(), string, true);
        this.initialize(workbenchContext);
    }

    protected AbstractDialog(WorkbenchContext workbenchContext, Dialog dialog) {
        this(workbenchContext, null, dialog);
    }

    protected AbstractDialog(WorkbenchContext workbenchContext, String string, Dialog dialog) {
        super(dialog, string, true);
        this.initialize(workbenchContext);
    }

    protected void initialize(WorkbenchContext workbenchContext) {
        this.context = new WindowWorkbenchContext(workbenchContext, this);
        this.initialize();
    }

    protected void initialize() {
        this.buttons = new HashMap();
        this.wasConfirmed = false;
        this.container = new AbstractPanel(new GridBagLayout(), this.getApplicationContext()){};
        this.setDefaultCloseOperation(2);
        this.initializeActions();
        this.initializeDefaultKeyboardActions();
        this.addWindowListener(this.buildWindowListener());
    }

    protected void initializeActions() {
        this.okAction = this.buildOKAction();
        this.cancelAction = this.buildCancelAction();
        this.helpAction = this.buildHelpAction();
    }

    protected void initializeContentPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.container.setOpaque(false);
        container.add((Component)this.container, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        Component component = this.buildMainPanel();
        this.helpManager().addTopicID(component, this.helpTopicId());
        this.container.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.container.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel = this.buildButtonPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)jPanel, gridBagConstraints);
    }

    protected abstract Component buildMainPanel();

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ComponentAligner componentAligner = new ComponentAligner();
        JPanel jPanel2 = new JPanel(new GridLayout(1, 0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        JButton jButton = new JButton(this.helpAction);
        this.buttons.put(this.helpAction, jButton);
        jPanel2.add(jButton);
        componentAligner.add(jButton);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)box, gridBagConstraints);
        this.customButtonPanel = this.buildCustomButtonPanel(componentAligner);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.customButtonPanel, gridBagConstraints);
        this.rightButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        JButton jButton2 = new JButton(this.okAction);
        this.buttons.put(this.okAction, jButton2);
        this.rightButtonPanel.add(jButton2);
        componentAligner.add(jButton2);
        JButton jButton3 = new JButton(this.cancelAction);
        this.buttons.put(this.cancelAction, jButton3);
        if (this.cancelButtonIsVisible()) {
            this.rightButtonPanel.add(jButton3);
            componentAligner.add(jButton3);
        }
        jPanel.add((Component)this.rightButtonPanel, gridBagConstraints);
        this.setDefaultAction(this.okAction);
        return jPanel;
    }

    protected JPanel buildCustomButtonPanel(ComponentAligner componentAligner) {
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        Iterator iterator = this.buildCustomActions();
        while (iterator.hasNext()) {
            this.addCustomAction((Action)iterator.next(), jPanel, componentAligner);
        }
        return jPanel;
    }

    protected Iterator buildCustomActions() {
        return NullIterator.instance();
    }

    private void addCustomAction(Action action, JPanel jPanel, ComponentAligner componentAligner) {
        JButton jButton = new JButton(action);
        jPanel.add(jButton);
        componentAligner.add(jButton);
        this.buttons.put(action, jButton);
    }

    protected void initializeDefaultKeyboardActions() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", this.cancelAction);
    }

    protected Action getOKAction() {
        return this.okAction;
    }

    protected Action buildOKAction() {
        return new AbstractAction(this.buildOKText()){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.okPressed();
            }
        };
    }

    protected String buildOKText() {
        return this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT");
    }

    protected void okPressed() {
        if (this.preConfirm()) {
            this.okConfirmed();
        }
    }

    protected boolean preConfirm() {
        return true;
    }

    protected void okConfirmed() {
        this.wasConfirmed = true;
        this.dispose();
    }

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected Action buildCancelAction() {
        return new AbstractAction(this.buildCancelText()){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.cancelPressed();
            }
        };
    }

    protected String buildCancelText() {
        return this.resourceRepository().getString("DIALOG.CANCEL_BUTTON_TEXT");
    }

    protected void cancelPressed() {
        this.wasConfirmed = false;
        this.dispose();
    }

    protected boolean cancelButtonIsVisible() {
        return true;
    }

    protected Action getHelpAction() {
        return this.helpAction;
    }

    protected abstract String helpTopicId();

    protected Action buildHelpAction() {
        return new AbstractAction(this.buildHelpText()){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractDialog.this.helpPressed();
            }
        };
    }

    protected String buildHelpText() {
        return this.resourceRepository().getString("DIALOG.HELP_BUTTON_TEXT");
    }

    protected void helpPressed() {
        this.helpManager().showTopic(this.getContentPane());
    }

    protected JButton getButtonFor(Action action) {
        return (JButton)this.buttons.get(action);
    }

    protected void setDefaultAction(Action action) {
        this.getRootPane().setDefaultButton(this.getButtonFor(action));
    }

    protected Component initialFocusComponent() {
        return null;
    }

    public void show() {
        if (!this.built) {
            this.initializeContentPane();
            this.built = true;
        }
        this.wasConfirmed = false;
        this.helpManager().addTopicID(this.getContentPane(), this.helpTopicId());
        this.prepareToShow();
        super.show();
    }

    protected void prepareToShow() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                AbstractDialog.this.windowOpened();
            }
        };
    }

    protected void windowOpened() {
        Component component = this.initialFocusComponent();
        if (component != null) {
            component.requestFocusInWindow();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    public boolean wasCanceled() {
        return !this.wasConfirmed();
    }

    protected void click(Action action) {
        this.getButtonFor(action).doClick();
    }

    protected void clickOK() {
        this.click(this.okAction);
    }

    protected void clickCancel() {
        this.click(this.cancelAction);
    }

    public ApplicationContext getApplicationContext() {
        return this.context.getApplicationContext();
    }

    public WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    public ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public static Runnable buildDialogLauncher(final Dialog dialog) {
        return new Runnable(){

            public void run() {
                dialog.show();
            }
        };
    }

    public static void launchLater(Dialog dialog) {
        EventQueue.invokeLater(AbstractDialog.buildDialogLauncher(dialog));
    }

    public static void launchAndWait(Dialog dialog) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(AbstractDialog.buildDialogLauncher(dialog));
    }

    protected final ExpandablePane buildExpandablePanel(String string, JComponent jComponent) {
        return SwingComponentFactory.buildExpandablePanel(string, jComponent, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String string, JComponent jComponent, boolean bl) {
        return SwingComponentFactory.buildExpandablePanel(string, jComponent, bl, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String string, String string2, JComponent jComponent) {
        return SwingComponentFactory.buildExpandablePanel(string, string2, jComponent, this.resourceRepository());
    }

    protected final ExpandablePane buildExpandablePanel(String string, String string2, JComponent jComponent, boolean bl) {
        return SwingComponentFactory.buildExpandablePanel(string, string2, jComponent, bl, this.resourceRepository());
    }

    protected final JLabel buildLabel(String string) {
        return SwingComponentFactory.buildLabel(string, this.resourceRepository());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel) {
        return SwingComponentFactory.buildLabeledComboBox(string, comboBoxModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledComboBox(string, comboBoxModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledComboBox(string, comboBoxModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter) {
        return SwingComponentFactory.buildLabeledComboBox(string, comboBoxModel, cellRendererAdapter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledComboBox(string, comboBoxModel, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        return SwingComponentFactory.buildLabeledComponent(jComponent, jComponent2, jComponent3, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(String string, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledComponent(String string, JComponent jComponent, JComponent jComponent2) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, jComponent2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel) {
        return SwingComponentFactory.buildLabeledListChooser(string, comboBoxModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledListChooser(string, comboBoxModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildLabeledListChooser(string, comboBoxModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledListChooser(string, comboBoxModel, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledNonEditableTextField(String string, Document document) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(string, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledNonEditableTextField(String string, Document document, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(string, document, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerDate(String string, SpinnerDateModel spinnerDateModel) {
        return SwingComponentFactory.buildLabeledSpinnerDate(string, spinnerDateModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(string, spinnerNumberModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel, int n) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(string, spinnerNumberModel, n, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String string, Document document) {
        return SwingComponentFactory.buildLabeledTextField(string, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String string, Document document, int n) {
        return SwingComponentFactory.buildLabeledTextField(string, document, n, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String string, Document document, int n, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledTextField(string, document, n, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String string, Document document, JComponent jComponent) {
        return SwingComponentFactory.buildLabeledTextField(string, document, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildLabeledTextField(String string, Document document, JTextField jTextField) {
        return SwingComponentFactory.buildLabeledTextField(string, document, jTextField, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final ListChooser buildListChooser(ComboBoxModel comboBoxModel) {
        return SwingComponentFactory.buildListChooser(comboBoxModel);
    }

    protected final ListChooser buildListChooser(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildListChooser(comboBoxModel, listCellRenderer);
    }

    protected final Border buildPaneTitledBorder(String string) {
        return SwingComponentFactory.buildPaneTitledBorder(string, this.resourceRepository());
    }

    protected final JRadioButton buildRadioButton(String string, ButtonModel buttonModel) {
        return SwingComponentFactory.buildRadioButton(string, buttonModel, this.resourceRepository());
    }

    protected final JSpinner buildSpinnerDate(SpinnerDateModel spinnerDateModel) {
        return SwingComponentFactory.buildSpinnerDate(spinnerDateModel);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel spinnerNumberModel) {
        return SwingComponentFactory.buildSpinnerNumber(spinnerNumberModel);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel spinnerNumberModel, int n) {
        return SwingComponentFactory.buildSpinnerNumber(spinnerNumberModel, n);
    }

    protected final JTable buildTable(TableModel tableModel) {
        return SwingComponentFactory.buildTable(tableModel);
    }

    protected final JTable buildTable(TableModel tableModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable(tableModel, listSelectionModel);
    }

    protected final JTable buildTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable(tableModel, tableColumnModel, listSelectionModel);
    }

    protected final JTextField buildTextField(Document document) {
        return SwingComponentFactory.buildTextField(document);
    }

    protected final Border buildTitledBorder(String string) {
        return SwingComponentFactory.buildTitledBorder(string, this.resourceRepository());
    }

    protected final JToggleButton buildToggleButton(String string) {
        return SwingComponentFactory.buildToggleButton(string, this.resourceRepository());
    }

    protected final JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel) {
        return SwingComponentFactory.buildTopLabeledComboBox(string, comboBoxModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledComboBox(string, comboBoxModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledComboBox(string, comboBoxModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledComboBox(string, comboBoxModel, listCellRenderer, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        return SwingComponentFactory.buildTopLabeledComponent(jComponent, jComponent2, jComponent3, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(String string, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledComponent(string, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledComponent(String string, JComponent jComponent, JComponent jComponent2) {
        return SwingComponentFactory.buildTopLabeledComponent(string, jComponent, jComponent2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableComboBox(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, object, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledEditableListChooser(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, object, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel) {
        return SwingComponentFactory.buildTopLabeledListChooser(string, comboBoxModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledListChooser(string, comboBoxModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return SwingComponentFactory.buildTopLabeledListChooser(string, comboBoxModel, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledListChooser(string, comboBoxModel, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledNonEditableTextField(String string, Document document, JComponent jComponent, ResourceRepository resourceRepository) {
        return SwingComponentFactory.buildTopLabeledNonEditableTextField(string, document, jComponent, resourceRepository, this.getAlignRightGroup(), this.getAlignLeftGroup());
    }

    protected final JComponent buildTopLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel, int n) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(string, spinnerNumberModel, n, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledTextField(String string, Document document) {
        return SwingComponentFactory.buildTopLabeledTextField(string, document, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JComponent buildTopLabeledTextField(String string, Document document, JComponent jComponent) {
        return SwingComponentFactory.buildTopLabeledTextField(string, document, jComponent, this.resourceRepository(), this.getAlignLeftGroup(), this.getAlignRightGroup());
    }

    protected final JTree buildTree(TreeModel treeModel) {
        return SwingComponentFactory.buildTree(treeModel);
    }

    protected final TriStateCheckBox buildTriStateCheckBox(String string, TriStateCheckBox.TriStateButtonModel triStateButtonModel) {
        return SwingComponentFactory.buildTriStateCheckBox(string, triStateButtonModel, this.resourceRepository());
    }

    private ComponentAligner getAlignLeftGroup() {
        return this.container.getAlignLeftGroup();
    }

    private ComponentAligner getAlignRightGroup() {
        return this.container.getAlignRightGroup();
    }
}

