/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractValidatingDialog
extends AbstractDialog {
    private JLabel errorMessageLabel;
    private JLabel warningMessageLabel;
    JLabel accessibleLabel;

    protected AbstractValidatingDialog(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected AbstractValidatingDialog(WorkbenchContext workbenchContext, String string) {
        super(workbenchContext, string);
    }

    protected AbstractValidatingDialog(WorkbenchContext workbenchContext, String string, Dialog dialog) {
        super(workbenchContext, string, dialog);
    }

    protected void initializeContentPane() {
        this.container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.container.setOpaque(false);
        container.add((Component)this.container, "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.container.add(this.buildMainPanel(), gridBagConstraints);
        this.errorMessageLabel = this.buildErrorMessageLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.container.add((Component)this.errorMessageLabel, gridBagConstraints);
        this.warningMessageLabel = this.buildWarningMessageLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.container.add((Component)this.warningMessageLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.container.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel = this.buildButtonPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)jPanel, gridBagConstraints);
        StatusBarPane statusBarPane = new StatusBarPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)statusBarPane, gridBagConstraints);
    }

    protected void windowOpened() {
        super.windowOpened();
        if (StringTools.stringIsEmpty((String)this.errorMessageLabel.getText())) {
            this.errorMessageLabel.setVisible(false);
        }
        if (this.errorMessageLabel.isVisible() || StringTools.stringIsEmpty((String)this.warningMessageLabel.getText())) {
            this.warningMessageLabel.setVisible(false);
        }
    }

    protected JLabel buildErrorMessageLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setIcon(this.resourceRepository().getIcon("error"));
        jLabel.setPreferredSize(new Dimension(300, 16));
        return jLabel;
    }

    protected void clearErrorMessage() {
        this.setErrorMessage(null);
    }

    protected JLabel getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected void setErrorMessage(String string) {
        boolean bl;
        this.errorMessageLabel.setText(string);
        boolean bl2 = bl = !StringTools.stringIsEmpty((String)string);
        if (this.errorMessageLabel.isVisible() != bl && this.isVisible()) {
            this.errorMessageLabel.setVisible(bl);
        }
        if (this.errorMessageLabel.isVisible() && this.warningMessageLabel.isVisible()) {
            this.warningMessageLabel.setVisible(false);
        }
        this.updateAccessibleMessage(string);
    }

    protected void setErrorMessageKey(String string) {
        this.setErrorMessage(this.resourceRepository().getString(string));
    }

    protected void setErrorMessageKey(String string, Object object) {
        this.setErrorMessage(this.resourceRepository().getString(string, object));
    }

    protected JLabel buildWarningMessageLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setIcon(this.resourceRepository().getIcon("warning"));
        jLabel.setPreferredSize(new Dimension(300, 16));
        return jLabel;
    }

    protected void clearWarningMessage() {
        this.setWarningMessage(null);
    }

    protected JLabel getWarningMessageLabel() {
        return this.warningMessageLabel;
    }

    protected void setWarningMessage(String string) {
        boolean bl;
        this.warningMessageLabel.setText(string);
        boolean bl2 = bl = !StringTools.stringIsEmpty((String)string) && !this.errorMessageLabel.isVisible();
        if (this.warningMessageLabel.isVisible() != bl && this.isVisible()) {
            this.warningMessageLabel.setVisible(bl);
        }
        this.updateAccessibleMessage(string);
    }

    protected void setWarningMessageKey(String string) {
        this.setWarningMessage(this.resourceRepository().getString(string));
    }

    protected void setWarningMessageKey(String string, Object object) {
        this.setWarningMessage(this.resourceRepository().getString(string, object));
    }

    protected void updateAccessibleMessage(String string) {
        if (this.accessibleLabel != null) {
            this.accessibleLabel.setText(string);
        }
    }

    private class StatusBarPane
    extends JPanel {
        public StatusBarPane() {
            super(new BorderLayout());
        }

        private void buildStatusBar() {
            AbstractValidatingDialog.this.accessibleLabel = new AccessibleLabel();
            AbstractValidatingDialog.this.accessibleLabel.setVisible(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setVisible(false);
            statusBar.add(AbstractValidatingDialog.this.accessibleLabel);
            this.add((Component)statusBar, "Center");
            this.validate();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarPane();
                this.buildStatusBar();
            }
            return this.accessibleContext;
        }

        private class StatusBar
        extends JPanel {
            private StatusBar() {
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleStatusBar();
                }
                return this.accessibleContext;
            }

            protected class AccessibleStatusBar
            extends JPanel.AccessibleJPanel {
                protected AccessibleStatusBar() {
                    super(StatusBar.this);
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.STATUS_BAR;
                }
            }
        }

        private class AccessibleLabel
        extends JLabel {
            private AccessibleLabel() {
            }

            public void setText(String string) {
                String string2 = this.getText();
                super.setText(string);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
                }
            }
        }

        protected class AccessibleStatusBarPane
        extends JPanel.AccessibleJPanel {
            protected AccessibleStatusBarPane() {
                super(StatusBarPane.this);
            }
        }
    }
}

