/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.AWTChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class NewNameDialog
extends AbstractValidatingDialog {
    private Builder builder;
    private JLabel textFieldLabel;
    protected JTextField textField;
    private PropertyValueModel subjectHolder;

    protected NewNameDialog(WorkbenchContext workbenchContext, Builder builder) {
        super(workbenchContext, builder.getTitle());
        this.builder = builder;
    }

    protected void initialize() {
        super.initialize();
        this.subjectHolder = new SimplePropertyValueModel();
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textFieldLabel = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.textFieldLabel, gridBagConstraints);
        this.textField = new JTextField(25);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.textField, gridBagConstraints);
        this.textFieldLabel.setText(this.builder.getTextFieldDescription());
        Document document = this.buildDocument(this.builder.getOriginalName());
        document.addDocumentListener(this.buildDocumentListener());
        this.textField.setDocument(document);
        this.textField.selectAll();
        if (this.textField.getText().length() == 0) {
            this.getOKAction().setEnabled(false);
        }
        this.helpManager().addTopicID(jPanel, this.helpTopicId());
        return jPanel;
    }

    protected Builder getBuilder() {
        return this.builder;
    }

    protected Document buildDocument(String string) {
        Document document = this.buildDocument();
        try {
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException);
        }
        return document;
    }

    protected Document buildDocument() {
        return this.builder.getDocumentFactory().buildDocument();
    }

    protected Document buildDocumentWithStateObject() {
        return new DocumentAdapter(this.buildNameHolder(), this.builder.getDocumentFactory().buildDocument());
    }

    protected final PropertyValueModel buildNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "name"){

            protected Object getValueFromSubject() {
                return ((StateObject)((Object)this.subject)).getName();
            }

            protected void setValueOnSubject(Object object) {
                ((StateObject)((Object)this.subject)).setName((String)object);
            }
        };
    }

    protected DocumentListener buildDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                NewNameDialog.this.documentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NewNameDialog.this.documentChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    protected String helpTopicId() {
        return this.builder.getHelpTopicId();
    }

    protected Component initialFocusComponent() {
        return this.textField;
    }

    protected Builder builder() {
        return this.builder;
    }

    protected void documentChanged() {
        if (this.isVisible()) {
            this.editName();
        }
    }

    protected void editName() {
        String string = this.textField.getText();
        if (this.builder.emptyNameIsIllegal() && string.length() == 0) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.EMPTY_VALUE");
            return;
        }
        boolean bl = this.namesMatch(string, this.builder.getOriginalName());
        if (this.builder.originalNameIsIllegal() && bl) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ORIGINAL_VALUE");
            return;
        }
        if (this.nameIsAlreadyTaken(string, bl)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.DUPLICATE_VALUE");
            return;
        }
        if (this.nameIsIllegal(string)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    protected void setErrorMessageKey(String string) {
        super.setErrorMessageKey(string);
        this.getOKAction().setEnabled(false);
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.getOKAction().setEnabled(true);
    }

    protected boolean namesMatch(String string, String string2) {
        return this.builder.comparisonIsCaseSensitive() ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    protected boolean nameIsAlreadyTaken(String string, boolean bl) {
        Iterator iterator = this.builder.existingNames();
        while (iterator.hasNext()) {
            if (!this.namesMatch(string, (String)iterator.next()) || bl) continue;
            return true;
        }
        return false;
    }

    protected boolean nameIsIllegal(String string) {
        Iterator iterator = this.builder.illegalNames();
        while (iterator.hasNext()) {
            if (!this.namesMatch(string, (String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public String getNewName() {
        if (this.wasConfirmed()) {
            return this.textField.getText();
        }
        throw new IllegalStateException("dialog was not confirmed");
    }

    protected String getNameInternal() {
        return this.textField.getText();
    }

    protected final ValueModel getSubjectHolder() {
        return this.subjectHolder;
    }

    protected StateObject buildStateObject() {
        return null;
    }

    public void show() {
        this.installSubject();
        super.show();
    }

    private void installSubject() {
        StateObject stateObject = this.buildStateObject();
        if (stateObject != null) {
            stateObject.setValidator(this.buildValidator());
            stateObject.setChangeNotifier(AWTChangeNotifier.instance());
        }
        this.subjectHolder.setValue((Object)stateObject);
    }

    public StateObject subject() {
        return (StateObject)((Object)this.subjectHolder.getValue());
    }

    Node.Validator buildValidator() {
        return Node.NULL_VALIDATOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StateObject
    extends AbstractNodeModel {
        private Builder builder;
        private ChangeNotifier changeNotifier;
        private String name;
        private Node.Validator validator;
        public static final String NAME_PROPERTY = "name";

        protected StateObject(Builder builder) {
            this.builder = builder;
            this.name = builder.getOriginalName();
            if (this.name == null) {
                this.name = "";
            }
        }

        protected void addProblemsTo(List list) {
            super.addProblemsTo(list);
            this.editName(list);
        }

        public String displayString() {
            return this.name;
        }

        protected void editName(List<Problem> list) {
            String string = this.name;
            if (StringTools.stringIsEmpty((String)string)) {
                list.add(this.buildProblem("NEW_NAME_DIALOG.EMPTY_VALUE"));
                return;
            }
            boolean bl = this.namesMatch(string, this.builder.getOriginalName());
            if (this.builder.originalNameIsIllegal() && bl) {
                list.add(this.buildProblem("NEW_NAME_DIALOG.ORIGINAL_VALUE"));
                return;
            }
            if (this.nameIsAlreadyTaken(string, bl)) {
                list.add(this.buildProblem("NEW_NAME_DIALOG.DUPLICATE_VALUE"));
                return;
            }
            if (this.nameIsIllegal(string)) {
                list.add(this.buildProblem("NEW_NAME_DIALOG.ILLEGAL_VALUE"));
                return;
            }
        }

        public ChangeNotifier getChangeNotifier() {
            return this.changeNotifier;
        }

        public String getName() {
            return this.name;
        }

        public Node.Validator getValidator() {
            return this.validator;
        }

        protected boolean nameIsAlreadyTaken(String string, boolean bl) {
            Iterator iterator = this.builder.existingNames();
            while (iterator.hasNext()) {
                if (!this.namesMatch(string, (String)iterator.next()) || bl) continue;
                return true;
            }
            return false;
        }

        protected boolean nameIsIllegal(String string) {
            Iterator iterator = this.builder.illegalNames();
            while (iterator.hasNext()) {
                if (!this.namesMatch(string, (String)iterator.next())) continue;
                return true;
            }
            return false;
        }

        protected boolean namesMatch(String string, String string2) {
            return this.builder.comparisonIsCaseSensitive() ? string.equals(string2) : string.equalsIgnoreCase(string2);
        }

        public void setChangeNotifier(ChangeNotifier changeNotifier) {
            this.changeNotifier = changeNotifier;
        }

        public void setName(String string) {
            String string2 = this.name;
            this.name = string;
            this.firePropertyChanged(NAME_PROPERTY, string2, string);
        }

        public void setValidator(Node.Validator validator) {
            this.validator = validator;
        }
    }

    public static interface DocumentFactory {
        public Document buildDocument();
    }

    public static class Builder
    implements Cloneable {
        private String title;
        private String textFieldDescription;
        private String originalName;
        private boolean emptyNameIsLegal;
        private boolean originalNameIsLegal;
        private ArrayList existingNames;
        private ArrayList illegalNames;
        private boolean comparisonIsCaseSensitive;
        private DocumentFactory documentFactory;
        private String helpTopicId;

        public Builder() {
            this.initialize();
        }

        protected void initialize() {
            this.title = null;
            this.textFieldDescription = null;
            this.originalName = null;
            this.emptyNameIsLegal = false;
            this.originalNameIsLegal = true;
            this.existingNames = new ArrayList();
            this.illegalNames = new ArrayList();
            this.comparisonIsCaseSensitive = false;
            this.documentFactory = this.buildDefaultDocumentFactory();
            this.helpTopicId = "dialog.newName";
        }

        public NewNameDialog buildDialog(WorkbenchContext workbenchContext) {
            return this.buildDialog(workbenchContext, (Builder)this.clone());
        }

        protected Object clone() {
            Builder builder;
            try {
                builder = (Builder)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
            builder.existingNames = (ArrayList)this.existingNames.clone();
            builder.illegalNames = (ArrayList)this.illegalNames.clone();
            return builder;
        }

        protected NewNameDialog buildDialog(WorkbenchContext workbenchContext, Builder builder) {
            return new NewNameDialog(workbenchContext, builder);
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTextFieldDescription(String string) {
            this.textFieldDescription = string;
        }

        public String getTextFieldDescription() {
            return this.textFieldDescription;
        }

        public void setOriginalName(String string) {
            this.originalName = string;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setEmptyNameIsLegal(boolean bl) {
            this.emptyNameIsLegal = bl;
        }

        public boolean emptyNameIsLegal() {
            return this.emptyNameIsLegal;
        }

        public boolean emptyNameIsIllegal() {
            return !this.emptyNameIsLegal;
        }

        public void setOriginalNameIsLegal(boolean bl) {
            this.originalNameIsLegal = bl;
        }

        public boolean originalNameIsLegal() {
            return this.originalNameIsLegal;
        }

        public boolean originalNameIsIllegal() {
            return !this.originalNameIsLegal;
        }

        public void setExistingNames(Collection collection) {
            this.setExistingNames(collection.iterator());
        }

        public void setExistingNames(Iterator iterator) {
            this.existingNames.clear();
            this.addExistingNames(iterator);
        }

        public void addExistingNames(Collection collection) {
            this.addExistingNames(collection.iterator());
        }

        public void addExistingNames(Iterator iterator) {
            while (iterator.hasNext()) {
                this.existingNames.add(iterator.next());
            }
        }

        public Iterator existingNames() {
            return this.existingNames.iterator();
        }

        public void setIllegalNames(Collection collection) {
            this.setIllegalNames(collection.iterator());
        }

        public void setIllegalNames(Iterator iterator) {
            this.illegalNames.clear();
            this.addIllegalNames(iterator);
        }

        public void addIllegalNames(Collection collection) {
            this.addIllegalNames(collection.iterator());
        }

        public void addIllegalNames(Iterator iterator) {
            while (iterator.hasNext()) {
                this.illegalNames.add(iterator.next());
            }
        }

        public Iterator illegalNames() {
            return this.illegalNames.iterator();
        }

        public void setComparisonIsCaseSensitive(boolean bl) {
            this.comparisonIsCaseSensitive = bl;
        }

        public boolean comparisonIsCaseSensitive() {
            return this.comparisonIsCaseSensitive;
        }

        public void setDocumentFactory(DocumentFactory documentFactory) {
            this.documentFactory = documentFactory;
        }

        public DocumentFactory getDocumentFactory() {
            return this.documentFactory;
        }

        protected DocumentFactory buildDefaultDocumentFactory() {
            return new DocumentFactory(){

                public Document buildDocument() {
                    return new PlainDocument();
                }
            };
        }

        public String getHelpTopicId() {
            return this.helpTopicId;
        }

        public void setHelpTopicId(String string) {
            this.helpTopicId = string;
        }
    }
}

