/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class TextAreaDialog
extends AbstractDialog {
    private String text;
    private String helpTopicID;
    private JTextArea textArea;

    private static String buildStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(5000);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return ((Object)stringWriter).toString();
    }

    public TextAreaDialog(String string, String string2, String string3, WorkbenchContext workbenchContext) {
        super(workbenchContext, string2);
        this.text = string;
        this.helpTopicID = string3;
    }

    public TextAreaDialog(String string, String string2, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.text = string;
        this.helpTopicID = string2;
    }

    public TextAreaDialog(String string, String string2, WorkbenchContext workbenchContext, Dialog dialog) {
        super(workbenchContext, dialog);
        this.text = string;
        this.helpTopicID = string2;
    }

    public TextAreaDialog(Throwable throwable, String string, WorkbenchContext workbenchContext) {
        this(TextAreaDialog.buildStackTrace(throwable), string, workbenchContext);
    }

    public TextAreaDialog(Throwable throwable, String string, WorkbenchContext workbenchContext, Dialog dialog) {
        this(TextAreaDialog.buildStackTrace(throwable), string, workbenchContext, dialog);
    }

    protected String helpTopicId() {
        return this.helpTopicID;
    }

    protected Component buildMainPanel() {
        this.setSize(500, 400);
        this.textArea = this.buildTextArea();
        return new JScrollPane(this.textArea);
    }

    protected JTextArea buildTextArea() {
        JTextArea jTextArea = new JTextArea(this.text);
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setEditable(false);
        return jTextArea;
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    protected Iterator buildCustomActions() {
        Action action = this.buildCopyAction();
        return new SingleElementIterator((Object)action);
    }

    private Action buildCopyAction() {
        return new AbstractAction(this.buildCopyText()){

            public void actionPerformed(ActionEvent actionEvent) {
                TextAreaDialog.this.copyPressed();
            }
        };
    }

    protected String buildCopyText() {
        return this.resourceRepository().getString("TEXT_AREA_DIALOG.COPY_BUTTON_TEXT");
    }

    protected void copyPressed() {
        int n = this.textArea.getCaretPosition();
        this.textArea.selectAll();
        this.textArea.copy();
        this.textArea.setCaretPosition(n);
    }

    protected void prepareToShow() {
        this.setLocationRelativeTo(this.getParent());
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

