/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;

public abstract class AbstractPanel
extends AccessibleTitledPanel {
    private ComponentAligner alignLeftGroup;
    private ComponentAligner alignRightGroup;
    private WorkbenchContextHolder workbenchContextHolder;

    protected AbstractPanel(ApplicationContext applicationContext) {
        this((LayoutManager)new GridBagLayout(), applicationContext);
    }

    protected AbstractPanel(LayoutManager layoutManager, ApplicationContext applicationContext) {
        this(layoutManager, new DefaultWorkbenchContextHolder(applicationContext));
    }

    protected AbstractPanel(WorkbenchContextHolder workbenchContextHolder) {
        this((LayoutManager)new GridBagLayout(), workbenchContextHolder);
    }

    protected AbstractPanel(LayoutManager layoutManager, WorkbenchContextHolder workbenchContextHolder) {
        super(layoutManager);
        this.workbenchContextHolder = workbenchContextHolder;
    }

    protected final void addAlignLeft(ComponentAligner componentAligner) {
        this.getAlignLeftGroup().add(componentAligner);
    }

    protected final void addAlignLeft(JComponent jComponent) {
        this.getAlignLeftGroup().add(jComponent);
    }

    protected final void addAlignRight(ComponentAligner componentAligner) {
        this.getAlignRightGroup().add(componentAligner);
    }

    protected final void addAlignRight(JComponent jComponent) {
        this.getAlignRightGroup().add(jComponent);
    }

    protected final void addHelpTopicId(Component component, String string) {
        this.helpManager().addTopicID(component, string);
    }

    protected final void addPaneForAlignLeft(AbstractPanel abstractPanel) {
        this.getAlignLeftGroup().add(abstractPanel.getAlignLeftGroup());
    }

    protected final void addPaneForAlignment(AbstractPanel abstractPanel) {
        this.addPaneForAlignLeft(abstractPanel);
        this.addPaneForAlignRight(abstractPanel);
    }

    protected final void addPaneForAlignRight(AbstractPanel abstractPanel) {
        this.getAlignRightGroup().add(abstractPanel.getAlignRightGroup());
    }

    protected final JButton buildButton(String string) {
        return SwingComponentFactory.buildButton(string, this.resourceRepository());
    }

    protected final JButton buildBrowseButton(String string, Accessible accessible) {
        return SwingComponentFactory.buildBrowseButton(string, this.resourceRepository(), accessible);
    }

    protected final JCheckBox buildCheckBox(String string, ButtonModel buttonModel) {
        return SwingComponentFactory.buildCheckBox(string, buttonModel, this.resourceRepository());
    }

    protected final JLabel buildLabel(String string) {
        return SwingComponentFactory.buildLabel(string, this.resourceRepository());
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel) {
        return this.buildLabeledComboBoxImp(string, comboBoxModel, null, false);
    }

    protected final JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return this.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, false);
    }

    private JComponent buildLabeledComboBoxImp(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, boolean bl) {
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setEditable(bl);
        if (listCellRenderer != null) {
            jComboBox.setRenderer(listCellRenderer);
        }
        return this.buildLabeledComponent(string, jComboBox);
    }

    protected final JComponent buildLabeledComponent(String string, JComponent jComponent) {
        return this.buildLabeledComponent(string, jComponent, new Spacer());
    }

    protected JComponent buildLabeledComponent(String string, JComponent jComponent, JComponent jComponent2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel jLabel = this.buildLabel(string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        jComponent.setName(string);
        jLabel.setLabelFor(jComponent);
        if (jComponent2 != null) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            pane.add((Component)jComponent2, gridBagConstraints);
            jComponent2.setName(string);
            this.addAlignRight(jComponent2);
            if (jComponent2 instanceof AbstractButton) {
                SwingComponentFactory.updateButtonAccessibleName(jLabel, (AbstractButton)jComponent2);
            }
        }
        return pane;
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel) {
        return this.buildLabeledComboBoxImp(string, comboBoxModel, null, true);
    }

    protected final JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        return this.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, true);
    }

    protected final JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel) {
        return this.buildLabeledSpinnerNumber(string, spinnerNumberModel, 4);
    }

    protected final JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel, int n) {
        Pane pane = new Pane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel(string);
        pane.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        JSpinner jSpinner = SwingComponentFactory.buildSpinnerNumber(spinnerNumberModel, n);
        jSpinner.setName(string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)jSpinner, gridBagConstraints);
        jLabel.setLabelFor(jSpinner);
        Spacer spacer = new Spacer();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        pane.add((Component)spacer, gridBagConstraints);
        this.addAlignRight(spacer);
        return pane;
    }

    protected final JComponent buildLabeledTextField(String string, Document document) {
        return this.buildLabeledTextField(string, document, new Spacer());
    }

    protected final JComponent buildLabeledTextField(String string, Document document, JComponent jComponent) {
        JTextField jTextField = new JTextField(document, null, 1);
        return this.buildLabeledComponent(string, jTextField, jComponent);
    }

    protected final JRadioButton buildRadioButton(String string, ButtonModel buttonModel) {
        return SwingComponentFactory.buildRadioButton(string, buttonModel, this.resourceRepository());
    }

    protected final Border buildTitledBorder(String string) {
        return SwingComponentFactory.buildTitledBorder(this.resourceRepository(), string);
    }

    protected final Border buildStandardEmptyBorder() {
        return SwingComponentFactory.buildStandardEmptyBorder();
    }

    public ComponentAligner getAlignLeftGroup() {
        if (this.alignLeftGroup == null) {
            this.alignLeftGroup = new ComponentAligner();
        }
        return this.alignLeftGroup;
    }

    public ComponentAligner getAlignRightGroup() {
        if (this.alignRightGroup == null) {
            this.alignRightGroup = new ComponentAligner();
        }
        return this.alignRightGroup;
    }

    protected final JSpinner buildSpinnerDate(SpinnerDateModel spinnerDateModel) {
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(spinnerDateModel);
        return jSpinner;
    }

    public final ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    public final Application application() {
        return this.getApplicationContext().getApplication();
    }

    public final Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    public final ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    public final HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    public final WorkbenchContextHolder getWorkbenchContextHolder() {
        return this.workbenchContextHolder;
    }

    public final WorkbenchContext getWorkbenchContext() {
        return this.workbenchContextHolder.getWorkbenchContext();
    }

    public final NavigatorSelectionModel navigatorSelectionModel() {
        return this.getWorkbenchContext().getNavigatorSelectionModel();
    }

    public final Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    public final NodeManager nodeManager() {
        return this.getApplicationContext().getNodeManager();
    }

    public final PreferencesContext getPreferencesContext() {
        return (PreferencesContext)this.getApplicationContext();
    }
}

