/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.view;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ComponentBuilder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class TabbedPropertiesPage
extends AbstractPropertiesPage {
    JTabbedPane tabbedPane;
    private List componentTabWeightHolders;
    private List dynamicTabHandlers;
    private Component previouslySelectedComponent;
    protected static final int DEFAULT_WEIGHT = 0;

    protected TabbedPropertiesPage(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected TabbedPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.add(this.buildTitlePanel(), "First");
        this.tabbedPane = this.buildTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.initializeTabs();
    }

    protected JTabbedPane buildTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane(1, 1);
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        return jTabbedPane;
    }

    protected abstract void initializeTabs();

    protected int tabCount() {
        return this.tabbedPane.getTabCount();
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.componentTabWeightHolders = new ArrayList();
        this.dynamicTabHandlers = new ArrayList();
    }

    protected void addTab(Component component, int n, String string) {
        this.addTab(this.buildDefaultComponentBuilder(component), n, string);
    }

    protected void addTab(Component component, String string) {
        this.addTab(component, 0, string);
    }

    protected void addTabAndSelect(Component component, int n, String string) {
        this.addTab(component, n, string);
        this.tabbedPane.setSelectedComponent(component);
    }

    protected void addTabAndSelect(Component component, String string) {
        this.addTabAndSelect(component, 0, string);
    }

    protected void addTab(ValueModel valueModel, int n, ComponentBuilder componentBuilder, String string) {
        DynamicTabHandler dynamicTabHandler = new DynamicTabHandler(componentBuilder, n, string, valueModel);
        dynamicTabHandler.engage();
        dynamicTabHandler.nodeSet(this.getNode());
        this.dynamicTabHandlers.add(dynamicTabHandler);
    }

    protected void addTab(ValueModel valueModel, int n, Component component, String string) {
        this.addTab(valueModel, n, this.buildDefaultComponentBuilder(component), string);
    }

    protected void addTab(ComponentBuilder componentBuilder, int n, String string) {
        Component component = componentBuilder.buildComponent(this.getNode());
        this.insertTab(component, n, string);
    }

    protected void setSelectedTab(Component component) {
        this.tabbedPane.setSelectedComponent(component);
    }

    protected void destroyTab(Component component) {
        this.removeTab(component);
        if (component == null) {
            return;
        }
        for (DynamicTabHandler dynamicTabHandler : this.dynamicTabHandlers) {
            if (dynamicTabHandler.getComponent() != component) continue;
            dynamicTabHandler.disengage();
            this.dynamicTabHandlers.remove(dynamicTabHandler);
            return;
        }
    }

    public void setNode(ApplicationNode applicationNode, WorkbenchContext workbenchContext) {
        if (applicationNode == null) {
            this.previouslySelectedComponent = this.tabbedPane.getSelectedComponent();
        }
        super.setNode(applicationNode, workbenchContext);
        for (DynamicTabHandler dynamicTabHandler : this.dynamicTabHandlers) {
            dynamicTabHandler.nodeSet(applicationNode);
        }
        if (applicationNode != null) {
            if (CollectionTools.contains((Object[])this.tabbedPane.getComponents(), (Object)this.previouslySelectedComponent)) {
                this.setSelectedTab(this.previouslySelectedComponent);
            } else {
                this.setSelectedTab(this.tabbedPane.getComponentAt(0));
            }
        }
    }

    void insertTab(Component component, int n, String string) {
        ComponentTabWeightHolder componentTabWeightHolder = new ComponentTabWeightHolder(component, n);
        int n2 = this.insertTabWeightHolder(componentTabWeightHolder);
        this.tabbedPane.insertTab(this.resourceRepository().getString(string), null, component, null, n2);
    }

    private int insertTabWeightHolder(ComponentTabWeightHolder componentTabWeightHolder) {
        int n = this.componentTabWeightHolders.size();
        for (int i = 0; i < this.componentTabWeightHolders.size(); ++i) {
            ComponentTabWeightHolder componentTabWeightHolder2 = (ComponentTabWeightHolder)this.componentTabWeightHolders.get(i);
            if (componentTabWeightHolder2.getPageWeight() <= componentTabWeightHolder.getPageWeight()) continue;
            n = i;
            break;
        }
        this.componentTabWeightHolders.add(n, componentTabWeightHolder);
        return n;
    }

    void removeTab(Component component) {
        this.tabbedPane.remove(component);
        this.removeTabWeightHolderFor(component);
    }

    private void removeTabWeightHolderFor(Component component) {
        ComponentTabWeightHolder componentTabWeightHolder = null;
        for (ComponentTabWeightHolder componentTabWeightHolder2 : this.componentTabWeightHolders) {
            if (componentTabWeightHolder2.getComponent() != component) continue;
            componentTabWeightHolder = componentTabWeightHolder2;
            break;
        }
        if (componentTabWeightHolder == null) {
            throw new RuntimeException("DEBUG: Could not find the correct holder for tab.");
        }
        this.componentTabWeightHolders.remove(componentTabWeightHolder);
    }

    private ComponentBuilder buildDefaultComponentBuilder(Component component) {
        return new DefaultComponentBuilder(component);
    }

    private class DynamicTabNodeHolder
    extends PropertyValueModelWrapper {
        private ValueModel enabledStateModel;
        protected PropertyChangeListener enabledStateChangeListener;

        private DynamicTabNodeHolder(PropertyValueModel propertyValueModel, ValueModel valueModel) {
            super(propertyValueModel);
            this.enabledStateModel = valueModel;
        }

        protected void initialize() {
            super.initialize();
            this.enabledStateChangeListener = this.buildEnabledStateChangeListener();
        }

        protected PropertyChangeListener buildEnabledStateChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DynamicTabNodeHolder.this.enabledStateModelChanged(propertyChangeEvent);
                }
            };
        }

        public Object getValue() {
            return this.enabledStateModelValue() ? this.valueHolder.getValue() : null;
        }

        public void setValue(Object object) {
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.enabledStateModel.addPropertyChangeListener("value", this.enabledStateChangeListener);
        }

        protected void disengageValueHolder() {
            this.enabledStateModel.removePropertyChangeListener("value", this.enabledStateChangeListener);
            super.disengageValueHolder();
        }

        protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
            if (this.enabledStateModelValue()) {
                this.firePropertyChanged("value", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }

        protected void enabledStateModelChanged(PropertyChangeEvent propertyChangeEvent) {
            if (this.enabledStateModelValue()) {
                this.firePropertyChanged("value", null, this.valueHolder.getValue());
            } else {
                this.firePropertyChanged("value", this.valueHolder.getValue(), null);
            }
        }

        private boolean enabledStateModelValue() {
            return (Boolean)this.enabledStateModel.getValue();
        }
    }

    private class DefaultComponentBuilder
    implements ComponentBuilder {
        private Component component;

        private DefaultComponentBuilder(Component component) {
            this.component = component;
        }

        public Component buildComponent(PropertyValueModel propertyValueModel) {
            return this.component;
        }
    }

    private class ComponentTabWeightHolder {
        private Component component;
        private int pageWeight;

        private ComponentTabWeightHolder(Component component, int n) {
            this.pageWeight = n;
            this.component = component;
        }

        int getPageWeight() {
            return this.pageWeight;
        }

        Component getComponent() {
            return this.component;
        }
    }

    private class DynamicTabHandler
    implements PropertyChangeListener {
        private Component component;
        private String tabTitleKey;
        private int tabWeight;
        private ComponentBuilder componentBuilder;
        private boolean hasTabBeenAdded;
        private ValueModel enabledStateModel;

        private DynamicTabHandler(ComponentBuilder componentBuilder, int n, String string, ValueModel valueModel) {
            this.componentBuilder = componentBuilder;
            this.tabTitleKey = string;
            this.tabWeight = n;
            this.enabledStateModel = valueModel;
        }

        protected void engage() {
            this.enabledStateModel.addPropertyChangeListener("value", this);
        }

        protected void disengage() {
            this.enabledStateModel.removePropertyChangeListener("value", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl.booleanValue()) {
                this.addPropertiesPage();
            } else {
                this.removePropertiesPage();
            }
        }

        protected void nodeSet(ApplicationNode applicationNode) {
            if (applicationNode != null) {
                boolean bl = (Boolean)this.enabledStateModel.getValue();
                if (bl && !this.hasTabBeenAdded) {
                    this.addPropertiesPage();
                } else if (!bl && this.hasTabBeenAdded) {
                    this.removePropertiesPage();
                }
            }
        }

        private void addPropertiesPage() {
            this.component = this.buildComponent();
            TabbedPropertiesPage.this.insertTab(this.component, this.tabWeight, this.tabTitleKey);
            TabbedPropertiesPage.this.setSelectedTab(this.component);
            this.hasTabBeenAdded = true;
        }

        private void removePropertiesPage() {
            int n = TabbedPropertiesPage.this.tabbedPane.indexOfComponent(this.component);
            int n2 = TabbedPropertiesPage.this.tabbedPane.getSelectedIndex();
            TabbedPropertiesPage.this.removeTab(this.component);
            if (n < n2) {
                TabbedPropertiesPage.this.tabbedPane.setSelectedIndex(n2 - 1);
            }
            this.component = null;
            this.hasTabBeenAdded = false;
        }

        private Component buildComponent() {
            DynamicTabNodeHolder dynamicTabNodeHolder = new DynamicTabNodeHolder(TabbedPropertiesPage.this.getNodeHolder(), this.enabledStateModel);
            return this.componentBuilder.buildComponent(dynamicTabNodeHolder);
        }

        protected Component getComponent() {
            return this.component;
        }
    }
}

