/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Container;
import java.awt.LayoutManager;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class AccessibleTitledPanel
extends JPanel {
    public AccessibleTitledPanel() {
    }

    public AccessibleTitledPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAccessibleTitledPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAccessibleTitledPane
    extends JPanel.AccessibleJPanel {
        protected AccessibleAccessibleTitledPane() {
            super(AccessibleTitledPanel.this);
        }

        private boolean containerIsValid(Container container) {
            return container instanceof JComponent && !(container instanceof JScrollPane) && !(container instanceof JSplitPane) && !(container instanceof JTabbedPane);
        }

        private String findTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                String string = this.findTitle(compoundBorder.getInsideBorder());
                if (string == null) {
                    string = this.findTitle(compoundBorder.getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        public String getTitledBorderText() {
            return this.traverseForTitleText(AccessibleTitledPanel.this);
        }

        private String traverseForTitleText(Container container) {
            if (this.containerIsValid(container)) {
                JComponent jComponent = (JComponent)container;
                String string = this.findTitle(jComponent.getBorder());
                if (string != null) {
                    return string;
                }
                return this.traverseForTitleText(jComponent.getParent());
            }
            return null;
        }

        protected String getBorderTitle(Border border) {
            return this.getTitledBorderText();
        }
    }
}

