/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class AddRemoveListPanel
extends AddRemovePanel {
    private JList list;

    public AddRemoveListPanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel) {
        this(applicationContext, adapter, listValueModel, 2);
    }

    public AddRemoveListPanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, int n) {
        this(applicationContext, adapter, listValueModel, n, (String)null);
    }

    public AddRemoveListPanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, int n, String string) {
        this(applicationContext, adapter, listValueModel, n, string, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemoveListPanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, int n, String string, NodeSelector nodeSelector) {
        super(applicationContext, adapter, listValueModel, n, nodeSelector);
        this.initializeLayout(string);
    }

    public AddRemoveListPanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, String string) {
        this(applicationContext, adapter, listValueModel, 2, string);
    }

    protected void initialize(ListValueModel listValueModel) {
        super.initialize(listValueModel);
        this.list = SwingComponentFactory.buildList(new ListModelAdapter(listValueModel));
        this.list.setSelectionModel(this.getSelectionModel());
        this.list.setCellRenderer(new DisplayableListCellRenderer());
        this.list.addKeyListener(this.buildF3KeyListener());
        this.helpManager().addItemsToPopupMenuForComponent(new JMenuItem[]{this.buildGoToMenuItem()}, this.list);
    }

    protected void initializeLayout(String string) {
        this.initializeListPanel(string);
        this.initializeButtonPanel();
    }

    protected void initializeListPanel(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.getButtonOrientation() == 1) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
        } else if (this.getButtonOrientation() == 4) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.list.getAccessibleContext().setAccessibleName(string);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        jScrollPane.setPreferredSize(new Dimension(1, 1));
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public JComponent getComponent() {
        return this.list;
    }

    public JList getList() {
        return this.list;
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public Iterator selectedValues() {
        return CollectionTools.iterator((Object[])this.list.getSelectedValues());
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.list.setCellRenderer(listCellRenderer);
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public void setSelectedIndices(int[] nArray) {
        this.list.setSelectedIndices(nArray);
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.list.setSelectedValue(object, bl);
    }

    public void setSelectionInterval(int n, int n2) {
        this.list.setSelectionInterval(n, n2);
    }
}

