/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GridLayout;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class AddRemovePanel
extends AbstractPanel {
    private Adapter adapter;
    private NodeSelector nodeSelector;
    private int buttonOrientation;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    private JButton addButton;
    private JButton removeButton;
    private JButton optionalButton;
    private JButton upButton;
    private JButton downButton;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedItemHolder;

    public AddRemovePanel(ApplicationContext applicationContext, Adapter adapter, ListValueModel listValueModel) {
        this(applicationContext, adapter, listValueModel, 2);
    }

    public AddRemovePanel(ApplicationContext applicationContext, Adapter adapter, ListValueModel listValueModel, int n) {
        this(applicationContext, adapter, listValueModel, n, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemovePanel(ApplicationContext applicationContext, Adapter adapter, ListValueModel listValueModel, int n, NodeSelector nodeSelector) {
        super(applicationContext);
        this.adapter = adapter;
        this.buttonOrientation = n;
        this.nodeSelector = nodeSelector;
        this.initialize(listValueModel);
    }

    protected void initialize(ListValueModel listValueModel) {
        this.rowSelectionModel = this.buildRowSelectionModel(listValueModel);
        listValueModel.addListChangeListener(this.buildListChangeListener());
        this.selectedItemHolder = this.buildSelectedItemHolder();
        this.addButton = this.buildAddButton();
        this.removeButton = this.buildRemoveButton();
        this.optionalButton = this.buildOptionalButton(this.adapter instanceof OptionAdapter ? (OptionAdapter)this.adapter : null);
        this.upButton = this.buildUpButton(this.adapter instanceof UpDownAdapter ? (UpDownAdapter)this.adapter : null);
        this.downButton = this.buildDownButton(this.adapter instanceof UpDownAdapter ? (UpDownAdapter)this.adapter : null);
    }

    protected JMenuItem buildGoToMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(this.resourceRepository().getString("SELECT_IN_NAVIGATOR_POPUP_MENU_ITEM"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem.addActionListener(this.buildGoToListener());
        return jMenuItem;
    }

    private ActionListener buildGoToListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRemovePanel.this.goToSelectedItem();
            }
        };
    }

    protected KeyListener buildF3KeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 114) {
                    AddRemovePanel.this.goToSelectedItem();
                }
            }
        };
    }

    private void goToSelectedItem() {
        if (this.getSelectedValue() != null) {
            this.nodeSelector.selectNodeFor(this.getSelectedValue());
        }
    }

    public Object getSelectedValue() {
        return this.getSelectionModel().getSelectedValue();
    }

    protected ObjectListSelectionModel buildRowSelectionModel(ListValueModel listValueModel) {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(listValueModel));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AddRemovePanel.this.rowSelectionChanged(listSelectionEvent);
                }
            }
        };
    }

    private void rowSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.getSelectionModel().getSelectedValuesSize() == 1) {
            this.selectedItemHolder.setValue(this.getSelectionModel().getSelectedValue());
        } else {
            this.selectedItemHolder.setValue(null);
        }
        this.updateButtons();
        this.fireListSelectionEvent(listSelectionEvent);
    }

    private ListChangeListener buildListChangeListener() {
        return new ListChangeAdapter(){

            public void listChanged(ListChangeEvent listChangeEvent) {
                AddRemovePanel.this.updateButtons();
            }
        };
    }

    protected void updateButtons() {
        this.updateAddButton(this.addButton);
        this.updateRemoveButton(this.removeButton);
        this.updateOptionalButton(this.optionalButton);
        this.updateUpButton(this.upButton);
        this.updateDownButton(this.downButton);
    }

    protected void updateAddButton(JButton jButton) {
    }

    protected void updateRemoveButton(JButton jButton) {
        jButton.setEnabled(this.getSelectionModel().getSelectedValue() != null);
    }

    protected void updateOptionalButton(JButton jButton) {
        if (this.adapter instanceof OptionAdapter) {
            jButton.setEnabled(((OptionAdapter)this.adapter).enableOptionOnSelectionChange(this.rowSelectionModel));
        }
    }

    protected void updateUpButton(JButton jButton) {
        jButton.setEnabled(this.getSelectionModel().getMinSelectionIndex() > 0);
    }

    protected void updateDownButton(JButton jButton) {
        jButton.setEnabled(!this.getSelectionModel().isSelectionEmpty() && this.getSelectionModel().getMaxSelectionIndex() < this.getSelectionModel().getListModel().getSize() - 1);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    private void fireListSelectionEvent(ListSelectionEvent listSelectionEvent) {
        ListSelectionListener[] listSelectionListenerArray = (ListSelectionListener[])this.listenerList.getListeners(ListSelectionListener.class);
        int n = listSelectionListenerArray.length;
        while (--n >= 0) {
            listSelectionListenerArray[n].valueChanged(listSelectionEvent);
        }
    }

    private PropertyValueModel buildSelectedItemHolder() {
        return new SimplePropertyValueModel(null);
    }

    protected void initializeButtonPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildButtonPanel();
        if (this.buttonOrientation == 1) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
        } else if (this.buttonOrientation == 4) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
        } else if (this.buttonOrientation == 3) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.anchor = 19;
            gridBagConstraints.fill = 2;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.anchor = 22;
            gridBagConstraints.fill = 0;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected void buildButtonPanel(JComponent jComponent) {
        jComponent.add(this.addButton);
        jComponent.add(this.removeButton);
        jComponent.add(this.optionalButton);
        jComponent.add(this.upButton);
        jComponent.add(this.downButton);
    }

    private JComponent buildButtonPanel() {
        if (this.buttonOrientation == 4) {
            this.addAlignLeft(this.addButton);
            this.addAlignLeft(this.removeButton);
            this.addAlignLeft(this.optionalButton);
            this.addAlignLeft(this.upButton);
            this.addAlignLeft(this.downButton);
        } else if (this.buttonOrientation == 3) {
            this.addAlignRight(this.addButton);
            this.addAlignRight(this.removeButton);
            this.addAlignRight(this.optionalButton);
            this.addAlignRight(this.upButton);
            this.addAlignRight(this.downButton);
        }
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel();
        this.buildButtonPanel(accessibleTitledPanel);
        int n = accessibleTitledPanel.getComponentCount();
        if (this.buttonOrientation == 4 || this.buttonOrientation == 3) {
            accessibleTitledPanel.setLayout(new GridLayout(n, 1, 0, 5));
        } else {
            accessibleTitledPanel.setLayout(new GridLayout(1, n, 5, 0));
        }
        return accessibleTitledPanel;
    }

    protected String addButtonKey() {
        return "ADD_BUTTON";
    }

    protected JButton buildAddButton() {
        JButton jButton = this.buildButton(this.addButtonKey());
        jButton.addActionListener(this.buildAddItemActionHandler());
        return jButton;
    }

    private ActionListener buildAddItemActionHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRemovePanel.this.addNewItem();
            }
        };
    }

    protected void addNewItem() {
        this.getAdapter().addNewItem(this.getSelectionModel());
    }

    protected String removeButtonKey() {
        return "REMOVE_BUTTON";
    }

    protected JButton buildRemoveButton() {
        JButton jButton = this.buildButton(this.removeButtonKey());
        jButton.addActionListener(this.buildRemoveItemsActionHandler());
        jButton.setEnabled(false);
        return jButton;
    }

    private ActionListener buildRemoveItemsActionHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRemovePanel.this.removeSelectedItems();
            }
        };
    }

    protected void removeSelectedItems() {
        this.getAdapter().removeSelectedItems(this.getSelectionModel());
    }

    protected JButton buildOptionalButton(OptionAdapter optionAdapter) {
        JButton jButton = null;
        if (optionAdapter != null) {
            jButton = this.buildButton(optionAdapter.optionalButtonKey());
            jButton.addActionListener(this.buildOptionalActionHandler());
            jButton.setEnabled(false);
        } else {
            jButton = new JButton();
            jButton.setVisible(false);
        }
        return jButton;
    }

    private ActionListener buildOptionalActionHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OptionAdapter)AddRemovePanel.this.getAdapter()).optionOnSelection(AddRemovePanel.this.getSelectionModel());
            }
        };
    }

    protected String upButtonKey() {
        return "UP_BUTTON_TEXT";
    }

    protected JButton buildUpButton(UpDownAdapter upDownAdapter) {
        JButton jButton = null;
        if (upDownAdapter != null) {
            jButton = this.buildButton(this.upButtonKey());
            jButton.addActionListener(this.buildUpActionHandler());
            jButton.setEnabled(false);
        } else {
            jButton = new JButton();
            jButton.setVisible(false);
        }
        return jButton;
    }

    private ActionListener buildUpActionHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRemovePanel.this.moveItemsUp();
            }
        };
    }

    protected void moveItemsUp() {
        Object[] objectArray = this.getSelectionModel().getSelectedValues();
        ((UpDownAdapter)this.getAdapter()).moveItemsUp(objectArray);
        this.getSelectionModel().setSelectedValues(objectArray);
    }

    protected String downButtonKey() {
        return "DOWN_BUTTON_TEXT";
    }

    protected JButton buildDownButton(UpDownAdapter upDownAdapter) {
        JButton jButton = null;
        if (upDownAdapter != null) {
            jButton = this.buildButton(this.downButtonKey());
            jButton.addActionListener(this.buildDownActionHandler());
            jButton.setEnabled(false);
        } else {
            jButton = new JButton();
            jButton.setVisible(false);
        }
        return jButton;
    }

    private ActionListener buildDownActionHandler() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRemovePanel.this.moveItemsDown();
            }
        };
    }

    protected void moveItemsDown() {
        Object[] objectArray = this.getSelectionModel().getSelectedValues();
        ((UpDownAdapter)this.getAdapter()).moveItemsDown(objectArray);
        this.getSelectionModel().setSelectedValues(objectArray);
    }

    public ObjectListSelectionModel getSelectionModel() {
        return this.rowSelectionModel;
    }

    public PropertyValueModel getSelectedItemHolder() {
        return this.selectedItemHolder;
    }

    protected Adapter getAdapter() {
        return this.adapter;
    }

    protected JButton getAddButton() {
        return this.addButton;
    }

    protected JButton getRemoveButton() {
        return this.removeButton;
    }

    protected JButton getOptionalButton() {
        return this.optionalButton;
    }

    protected int getButtonOrientation() {
        return this.buttonOrientation;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getComponent().setEnabled(bl);
        this.addButton.setEnabled(bl);
        int n = this.getSelectionModel().getSelectedValuesSize();
        this.removeButton.setEnabled(bl && n > 0);
        this.optionalButton.setEnabled(bl && n == 1);
    }

    public abstract JComponent getComponent();

    public void setOptionalButtonEnabled(boolean bl) {
        this.optionalButton.setEnabled(bl);
    }

    public void setRemoveButtonEnabled(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    public void setAddButtonEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.getSelectionModel().setSelectedValue(object);
    }

    public static interface UpDownOptionAdapter
    extends OptionAdapter,
    UpDownAdapter {
    }

    public static interface UpDownAdapter
    extends Adapter {
        public void moveItemsUp(Object[] var1);

        public void moveItemsDown(Object[] var1);
    }

    public static interface OptionAdapter
    extends Adapter {
        public String optionalButtonKey();

        public void optionOnSelection(ObjectListSelectionModel var1);

        public boolean enableOptionOnSelectionChange(ObjectListSelectionModel var1);
    }

    public static interface Adapter {
        public void addNewItem(ObjectListSelectionModel var1);

        public void removeSelectedItems(ObjectListSelectionModel var1);
    }
}

