/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;

public class CheckList
extends AccessibleTitledPanel {
    JLabel accessibleLabel;
    EditableCheckList listBox;
    ListSelectionModel selectionModel;

    private CheckList() {
        super(new BorderLayout());
    }

    public CheckList(CollectionValueModel collectionValueModel, ListSelectionModel listSelectionModel) {
        this(collectionValueModel, listSelectionModel, CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER);
    }

    public CheckList(CollectionValueModel collectionValueModel, ListSelectionModel listSelectionModel, CellRendererAdapter cellRendererAdapter) {
        this(new CollectionListValueModelAdapter(collectionValueModel), listSelectionModel, cellRendererAdapter);
    }

    public CheckList(ListValueModel listValueModel, ListSelectionModel listSelectionModel) {
        this(listValueModel, listSelectionModel, CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER);
    }

    public CheckList(ListValueModel listValueModel, ListSelectionModel listSelectionModel, CellRendererAdapter cellRendererAdapter) {
        this();
        this.initialize(listValueModel, listSelectionModel, cellRendererAdapter);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                CheckList.this.listBox.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                CheckList.this.listBox.repaint();
            }
        };
    }

    private ListModel buildListModelAdapter(ListValueModel listValueModel) {
        return new ListModelAdapter(listValueModel);
    }

    private ListSelectionListener buildSelectionModelListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                    CheckList.this.repaintCell(i);
                }
            }
        };
    }

    protected void initialize(ListValueModel listValueModel, ListSelectionModel listSelectionModel, CellRendererAdapter cellRendererAdapter) {
        if (listValueModel == null || listSelectionModel == null || cellRendererAdapter == null) {
            throw new NullPointerException("ListValueModel, ListSelectionModel, CellRendererAdapter cannot be null");
        }
        this.selectionModel = listSelectionModel;
        listSelectionModel.addListSelectionListener(this.buildSelectionModelListener());
        this.listBox = new EditableCheckList(this.buildListModelAdapter(listValueModel));
        this.listBox.addFocusListener(this.buildFocusListener());
        this.listBox.setCellRenderer(new CheckBoxCellRenderer(cellRendererAdapter));
        this.add((Component)new JScrollPane(this.listBox), "Center");
        this.installEditing();
        this.add((Component)new StatusBarPane(), "First");
    }

    private void installEditing() {
        MouseHandler mouseHandler = new MouseHandler();
        this.listBox.addMouseListener(mouseHandler);
        this.listBox.addMouseMotionListener(mouseHandler);
        InputMap inputMap = (InputMap)UIManager.get("List.focusInputMap");
        inputMap.put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        inputMap.put(KeyStroke.getKeyStroke("released SPACE"), "released");
        ActionMap actionMap = this.listBox.getActionMap();
        actionMap.put("pressed", new PressedAction());
        actionMap.put("released", new ReleasedAction());
    }

    boolean isAccessibleContextInitialized() {
        return this.accessibleContext != null;
    }

    void repaintCell(int n) {
        Rectangle rectangle = this.listBox.getCellBounds(n, n);
        this.listBox.repaint(rectangle);
    }

    public void requestFocus() {
        this.listBox.requestFocus();
    }

    public boolean requestFocus(boolean bl) {
        return this.listBox.requestFocus(bl);
    }

    public boolean requestFocusInWindow() {
        return this.listBox.requestFocusInWindow();
    }

    protected boolean requestFocusInWindow(boolean bl) {
        return this.listBox.requestFocusInWindow(bl);
    }

    private void updateActiveDescendant(int n) {
        if (this.accessibleContext != null) {
            AccessibleContext accessibleContext = this.listBox.getAccessibleContext();
            Accessible accessible = accessibleContext.getAccessibleChild(n);
            this.accessibleLabel.setText(accessible.getAccessibleContext().getAccessibleName());
        }
    }

    void updateSelection(int n) {
        this.updateSelection(new int[]{n});
    }

    void updateSelection(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            if (!this.selectionModel.isSelectedIndex(nArray[n3])) continue;
            ++n2;
        }
        n3 = nArray.length != n2 ? 1 : 0;
        for (n = 0; n < nArray.length; ++n) {
            int n4 = nArray[n];
            if (n3 != 0) {
                this.selectionModel.addSelectionInterval(n4, n4);
                continue;
            }
            this.selectionModel.removeSelectionInterval(n4, n4);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.updateActiveDescendant(nArray[n]);
        }
    }

    private class StatusBarPane
    extends JPanel {
        public StatusBarPane() {
            super(new BorderLayout());
        }

        private void createStatusBar() {
            CheckList.this.accessibleLabel = new AccessibleLabel();
            CheckList.this.accessibleLabel.setVisible(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setVisible(false);
            statusBar.add(CheckList.this.accessibleLabel);
            this.add((Component)statusBar, "Center");
            this.validate();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarPane();
                this.createStatusBar();
            }
            return this.accessibleContext;
        }

        private class StatusBar
        extends JPanel {
            private StatusBar() {
            }

            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleStatusBar();
                }
                return this.accessibleContext;
            }

            protected class AccessibleStatusBar
            extends JPanel.AccessibleJPanel {
                protected AccessibleStatusBar() {
                    super(StatusBar.this);
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.STATUS_BAR;
                }
            }
        }

        protected class AccessibleStatusBarPane
        extends JPanel.AccessibleJPanel {
            protected AccessibleStatusBarPane() {
                super(StatusBarPane.this);
            }
        }

        private class AccessibleLabel
        extends JLabel {
            private AccessibleLabel() {
            }

            public void setText(String string) {
                String string2 = this.getText();
                super.setText(string);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
                }
            }
        }
    }

    private class ReleasedAction
    extends AbstractAction {
        private ReleasedAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = CheckList.this.listBox.getSelectedIndices();
            if (nArray.length > 0) {
                CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
                checkBoxCellRenderer.armedIndex = -1;
                checkBoxCellRenderer.pressedIndex = -1;
                CheckList.this.updateSelection(nArray);
            }
        }
    }

    private class PressedAction
    extends AbstractAction {
        private PressedAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = CheckList.this.listBox.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            checkBoxCellRenderer.armedIndex = nArray[0];
            checkBoxCellRenderer.pressedIndex = nArray[0];
            CheckList.this.repaintCell(nArray[0]);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int currentPressedIndex = -1;

        private MouseHandler() {
        }

        private int locationToIndex(Point point) {
            int n = SwingTools.checkBoxIconWidth();
            int n2 = CheckList.this.listBox.locationToIndex(point);
            Rectangle rectangle = CheckList.this.listBox.getCellBounds(n2, n2);
            if (!CheckList.this.listBox.getComponentOrientation().isLeftToRight()) {
                rectangle.x += rectangle.width - n;
            }
            rectangle.width = n;
            return rectangle.contains(point.x, point.y) ? n2 : -1;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            int n = checkBoxCellRenderer.rolloverIndex;
            if (n != -1) {
                checkBoxCellRenderer.armedIndex = -1;
                checkBoxCellRenderer.rolloverIndex = -1;
                CheckList.this.repaintCell(n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (CheckList.this.listBox.getModel().getSize() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = CheckList.this.listBox.locationToIndex(point);
            Rectangle rectangle = CheckList.this.listBox.getCellBounds(n, n);
            if (!rectangle.contains(point)) {
                n = -1;
            }
            CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            int n2 = checkBoxCellRenderer.rolloverIndex;
            if (n2 == n) {
                return;
            }
            checkBoxCellRenderer.rolloverIndex = n;
            int n3 = checkBoxCellRenderer.armedIndex = n == this.currentPressedIndex ? n : -1;
            if (n != -1) {
                CheckList.this.repaintCell(n);
            }
            if (n2 != -1) {
                CheckList.this.repaintCell(n2);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
                checkBoxCellRenderer.armedIndex = n;
                checkBoxCellRenderer.pressedIndex = n;
                this.currentPressedIndex = n;
                CheckList.this.repaintCell(n);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CheckList.this.listBox.getCellRenderer();
            Point point = mouseEvent.getPoint();
            int n = CheckList.this.listBox.locationToIndex(point);
            Rectangle rectangle = CheckList.this.listBox.getCellBounds(n, n);
            if (!rectangle.contains(point)) {
                n = -1;
            }
            if (this.currentPressedIndex != n || this.locationToIndex(mouseEvent.getPoint()) == -1) {
                this.currentPressedIndex = -1;
            }
            checkBoxCellRenderer.armedIndex = this.currentPressedIndex;
            checkBoxCellRenderer.pressedIndex = -1;
            checkBoxCellRenderer.rolloverIndex = n;
            if (this.currentPressedIndex != -1) {
                CheckList.this.updateSelection(this.currentPressedIndex);
            }
            this.currentPressedIndex = -1;
            if (n != -1) {
                CheckList.this.repaintCell(n);
            }
        }
    }

    private class EditableCheckList
    extends SwingComponentFactory.AccessibleList {
        EditableCheckList(ListModel listModel) {
            super(listModel);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleEditableCheckList();
            }
            return this.accessibleContext;
        }

        public boolean requestFocusInWindow(boolean bl) {
            return super.requestFocusInWindow(bl);
        }

        protected class AccessibleEditableCheckList
        extends SwingComponentFactory.AccessibleList.AccessibleAccessibleList
        implements ListSelectionListener {
            String ACCESSIBLE_CHECKBOX_CHECKED;
            String ACCESSIBLE_CHECKBOX_NOT_CHECKED;

            protected AccessibleEditableCheckList() {
                super(EditableCheckList.this);
                this.initialize();
            }

            public Accessible getAccessibleAt(Point point) {
                int n = EditableCheckList.this.locationToIndex(point);
                return this.getAccessibleChild(n);
            }

            public Accessible getAccessibleChild(int n) {
                if (n < 0 || n >= EditableCheckList.this.getModel().getSize()) {
                    return null;
                }
                return new AccessibleEditableCheckListChild((JList)EditableCheckList.this, n);
            }

            protected void initialize() {
                DefaultResourceRepository defaultResourceRepository = new DefaultResourceRepository(UIToolsResourceBundle.class);
                this.ACCESSIBLE_CHECKBOX_CHECKED = " " + defaultResourceRepository.getString("ACCESSIBLE_CHECKLIST_CHECKBOX_CHECKED");
                this.ACCESSIBLE_CHECKBOX_NOT_CHECKED = " " + defaultResourceRepository.getString("ACCESSIBLE_CHECKLIST_CHECKBOX_NOT_CHECKED");
            }

            protected class AccessibleEditableCheckListChild
            extends JList.AccessibleJList.AccessibleJListChild {
                private final int index;

                protected AccessibleEditableCheckListChild(JList jList, int n) {
                    super(AccessibleEditableCheckList.this, jList, n);
                    this.index = n;
                }

                public String getAccessibleName() {
                    String string = super.getAccessibleName();
                    string = CheckList.this.selectionModel.isSelectedIndex(this.index) ? string + AccessibleEditableCheckList.this.ACCESSIBLE_CHECKBOX_CHECKED : string + AccessibleEditableCheckList.this.ACCESSIBLE_CHECKBOX_NOT_CHECKED;
                    return string;
                }
            }
        }
    }

    private class CheckBoxCellRenderer
    extends AdaptableListCellRenderer {
        int armedIndex;
        int pressedIndex;
        int rolloverIndex;

        CheckBoxCellRenderer(CellRendererAdapter cellRendererAdapter) {
            super(cellRendererAdapter);
            this.pressedIndex = -1;
            this.armedIndex = -1;
            this.rolloverIndex = -1;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (CheckList.this.isAccessibleContextInitialized()) {
                this.getAccessibleContext();
            }
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            CheckBox checkBox = new CheckBox();
            this.updateCheckBoxUI(checkBox, bl);
            this.updateCheckBoxVisual(checkBox);
            this.updateCheckBoxButtonModel(checkBox, n);
            return checkBox;
        }

        private void updateCheckBoxButtonModel(CheckBox checkBox, int n) {
            ButtonModel buttonModel = checkBox.getModel();
            buttonModel.setPressed(this.pressedIndex == n);
            buttonModel.setArmed(this.armedIndex == n);
            buttonModel.setRollover(this.rolloverIndex == n);
            checkBox.setSelected(CheckList.this.selectionModel.isSelectedIndex(n));
        }

        private void updateCheckBoxUI(CheckBox checkBox, boolean bl) {
            checkBox.setHorizontalAlignment(this.getHorizontalAlignment());
            checkBox.setHorizontalTextPosition(this.getHorizontalTextPosition());
            checkBox.setVerticalAlignment(this.getVerticalAlignment());
            checkBox.setVerticalTextPosition(this.getVerticalTextPosition());
            checkBox.setComponentOrientation(this.getComponentOrientation());
            checkBox.setFont(this.getFont());
            checkBox.setEnabled(this.isEnabled());
            checkBox.setOpaque(this.isOpaque());
            checkBox.setBorder(this.getBorder());
            if (!CheckList.this.listBox.hasFocus() && bl) {
                checkBox.setForeground(CheckList.this.listBox.getForeground());
                checkBox.setBackground(UIManager.getColor("Panel.background"));
            } else {
                checkBox.setForeground(this.getForeground());
                checkBox.setBackground(this.getBackground());
            }
        }

        private void updateCheckBoxVisual(CheckBox checkBox) {
            checkBox.setIcon(this.getIcon());
            checkBox.setText(this.getText());
            if (CheckList.this.isAccessibleContextInitialized()) {
                checkBox.getAccessibleContext().setAccessibleName(this.accessibleContext.getAccessibleName());
            }
        }
    }

    private class CheckBox
    extends JCheckBox {
        private CheckBox() {
            this.initialize();
        }

        private void initialize() {
            this.setRolloverEnabled(true);
            this.setBorderPainted(true);
        }

        public void setIcon(Icon icon) {
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                return;
            }
            if (icon != null) {
                super.setIcon(new CompositeIcon(UIManager.getIcon("CheckBox.icon"), 3, icon));
            } else {
                super.setIcon(UIManager.getIcon("CheckBox.icon"));
            }
        }
    }
}

