/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Hashtable;

public class GridLayout
implements LayoutManager2,
Serializable {
    private int columns;
    private int componentIndex;
    private Hashtable constraintsTable = new Hashtable();
    private int hgap;
    private int rows;
    private int vgap;

    public GridLayout() {
    }

    public GridLayout(int n, int n2) {
        this.setRows(n);
        this.setColumns(n2);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        this(n, n2);
        this.setHgap(n3);
        this.setVgap(n4);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = new GridBagConstraints();
            ((GridBagConstraints)object).fill = 1;
        } else if (!(object instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("The constraints has to be GridBagConstraints");
        }
        this.constraintsTable.put(component, ((GridBagConstraints)object).clone());
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public int getColumns() {
        return this.columns;
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.constraintsTable.get(component);
        if (gridBagConstraints == null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.constraintsTable.put(component, gridBagConstraints);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getLayoutSize(Container container, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component component;
            Insets insets = container.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            int n3 = container.getComponentCount();
            int n4 = 0;
            int n5 = 0;
            int n6 = this.getRows();
            int n7 = this.getColumns();
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = n3;
            while (--n12 >= 0) {
                component = container.getComponent(n12);
                if (component.isVisible()) continue;
                if (n7 < 2) {
                    --n6;
                }
                if (n6 < 2) {
                    --n7;
                }
                --n3;
            }
            if (n6 > 0) {
                n7 = (n3 + n6 - 1) / n6;
            } else if (n7 > 0) {
                n6 = (n3 + n7 - 1) / n7;
            } else {
                return new Dimension();
            }
            n12 = container.getComponentCount();
            while (--n12 >= 0) {
                component = container.getComponent(n12);
                if (!component.isVisible()) continue;
                GridBagConstraints gridBagConstraints = this.getConstraints(component);
                Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (gridBagConstraints.fill != 1) {
                    if (n6 < 2 && (gridBagConstraints.fill == 3 || gridBagConstraints.fill == 0)) {
                        n10 += dimension.width;
                    } else if (gridBagConstraints.fill != 0) {
                        ++n4;
                        n8 = Math.max(n8, dimension.width);
                    } else {
                        n8 = Math.max(n8, dimension.width);
                    }
                    if (n7 < 2 && (gridBagConstraints.fill == 2 || gridBagConstraints.fill == 0)) {
                        n11 += dimension.height;
                        continue;
                    }
                    if (gridBagConstraints.fill != 0) {
                        ++n5;
                        n9 = Math.max(n9, dimension.height);
                        continue;
                    }
                    n9 = Math.max(n9, dimension.height);
                    continue;
                }
                ++n4;
                ++n5;
                n8 = Math.max(n8, dimension.width);
                n9 = Math.max(n9, dimension.height);
            }
            n12 = 0;
            int n13 = 0;
            if (n6 < 2) {
                n12 = n + n10 + n8 * n4 + (n7 - 1) * this.getHgap();
                n13 = n2 + Math.max(n11, n9) + (n6 - 1) * this.getVgap();
            } else {
                n12 = n + Math.max(n10, n8) + (n7 - 1) * this.getHgap();
                n13 = n2 + n11 + n9 * n5 + (n6 - 1) * this.getVgap();
            }
            return new Dimension(n12, n13);
        }
    }

    private Component getNextVisibleComponent(Container container, int n) {
        Component component = null;
        int n2 = container.getComponentCount();
        while (this.componentIndex < n2) {
            if ((component = container.getComponent(this.componentIndex++)).isVisible()) {
                return component;
            }
            component.setBounds(0, 0, 0, 0);
        }
        return null;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        if (container == null) {
            return;
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            GridBagConstraints gridBagConstraints;
            Dimension dimension;
            Component component;
            int n = container.getComponentCount();
            if (n == 0) {
                return;
            }
            Insets insets = container.getInsets();
            boolean bl = container.getComponentOrientation().isLeftToRight();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            int n4 = container.getWidth() - n2;
            int n5 = container.getHeight() - n3;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.getRows();
            int n9 = this.getColumns();
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            double d = 1.0;
            double d2 = 1.0;
            int n16 = n;
            while (--n16 >= 0) {
                component = container.getComponent(n16);
                if (component.isVisible()) continue;
                if (n9 < 2) {
                    --n8;
                } else if (n8 < 2) {
                    --n9;
                }
                --n;
            }
            if (n8 > 0) {
                n9 = (n + n8 - 1) / n8;
            } else if (n9 > 0) {
                n8 = (n + n9 - 1) / n9;
            } else {
                return;
            }
            for (n16 = 0; n16 < container.getComponentCount(); ++n16) {
                component = container.getComponent(n16);
                if (!component.isVisible()) continue;
                dimension = component.getPreferredSize();
                gridBagConstraints = this.getConstraints(component);
                if (gridBagConstraints.fill != 1) {
                    if (n8 < 2 && (gridBagConstraints.fill == 3 || gridBagConstraints.fill == 0)) {
                        n12 += dimension.width;
                        ++n13;
                    } else if (gridBagConstraints.fill != 0) {
                        ++n6;
                        n10 = Math.max(n10, dimension.width);
                    } else {
                        n10 = Math.max(n10, dimension.width);
                    }
                    if (n9 < 2 && (gridBagConstraints.fill == 2 || gridBagConstraints.fill == 0)) {
                        n14 += dimension.height;
                        ++n15;
                        continue;
                    }
                    if (gridBagConstraints.fill != 0) {
                        ++n7;
                        n11 = Math.max(n11, dimension.height);
                        continue;
                    }
                    n11 = Math.max(n11, dimension.height);
                    continue;
                }
                ++n6;
                ++n7;
                n10 = Math.max(n10, dimension.width);
                n11 = Math.max(n11, dimension.height);
            }
            n16 = n4 - n2 - (n - 1) * this.getHgap();
            int n17 = n5 - n3 - (n - 1) * this.getVgap();
            if (n6 == 0) {
                n6 = 1;
            }
            if (n8 < 2) {
                n10 = (n16 -= n12) / n6;
                n11 = container.getHeight();
            }
            if (n9 < 2) {
                n10 = n4;
                n11 = (n17 -= n14) / n6;
            }
            if (n13 > 0 && n12 > n4) {
                d = (double)n4 / (double)n12;
            }
            if (n15 > 0 && n14 > n5) {
                d2 = (double)n5 / (double)n14;
            }
            int n18 = insets.top;
            this.componentIndex = 0;
            int n19 = bl ? insets.left : insets.right + n4 - insets.left;
            n4 = 0;
            n5 = 0;
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < n9 && (component = this.getNextVisibleComponent(container, this.componentIndex)) != null; ++j) {
                    gridBagConstraints = this.getConstraints(component);
                    if (gridBagConstraints.fill != 1) {
                        dimension = component.getPreferredSize();
                        n4 = gridBagConstraints.fill == 3 || gridBagConstraints.fill == 0 ? (int)((double)dimension.width * d) : n10;
                        n5 = gridBagConstraints.fill == 2 || gridBagConstraints.fill == 0 ? (int)((double)dimension.height * d2) : n11;
                        if (bl) {
                            component.setBounds(n19, n18, n4, n5);
                        } else {
                            component.setBounds(n19 - n4, n18, n4, n5);
                        }
                        if (n9 > 1) {
                            n5 = Math.max(n11, n5);
                        }
                    } else {
                        n4 = n10;
                        n5 = n11;
                        if (bl) {
                            component.setBounds(n19, n18, n4, n5);
                        } else {
                            component.setBounds(n19 - n4, n18, n4, n5);
                        }
                    }
                    if (bl) {
                        n19 += n4 + this.getHgap();
                        continue;
                    }
                    n19 -= n4 - this.getHgap();
                }
                n19 = bl ? insets.left : insets.right + n4 - insets.left;
                n18 += n5 + this.getVgap();
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void removeLayoutComponent(Component component) {
        this.constraintsTable.remove(component);
    }

    public void setColumns(int n) {
        this.columns = n;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.constraintsTable.put(component, gridBagConstraints.clone());
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }
}

