/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;

public class GroupBox
extends AccessibleTitledPanel {
    private static final String FILL_VERTICAL = "fillVertical";
    public static final JComponent NO_PANE = new JComponent(){};

    private GroupBox() {
        super(new GridBagLayout());
    }

    public GroupBox(AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3, JComponent jComponent) {
        this(new AbstractButton[]{abstractButton, abstractButton2, abstractButton3}, new JComponent[]{NO_PANE, NO_PANE, jComponent});
    }

    public GroupBox(AbstractButton abstractButton, AbstractButton abstractButton2, JComponent jComponent) {
        this(new AbstractButton[]{abstractButton, abstractButton2}, new JComponent[]{NO_PANE, jComponent});
    }

    public GroupBox(AbstractButton abstractButton, JComponent jComponent) {
        this(new AbstractButton[]{abstractButton}, new JComponent[]{jComponent});
    }

    public GroupBox(AbstractButton abstractButton, JComponent jComponent, AbstractButton abstractButton2, JComponent jComponent2) {
        this(new AbstractButton[]{abstractButton, abstractButton2}, new JComponent[]{jComponent, jComponent2});
    }

    public GroupBox(AbstractButton[] abstractButtonArray, JComponent jComponent) {
        this(abstractButtonArray, GroupBox.componentArray(abstractButtonArray.length, jComponent));
    }

    public GroupBox(AbstractButton[] abstractButtonArray, JComponent[] jComponentArray) {
        this();
        this.initializeLayout(abstractButtonArray, jComponentArray);
    }

    private static JComponent[] componentArray(int n, JComponent jComponent) {
        Object[] objectArray = new JComponent[n];
        Arrays.fill(objectArray, NO_PANE);
        objectArray[n - 1] = jComponent;
        return objectArray;
    }

    public static void fillVertical(JComponent jComponent) {
        jComponent.putClientProperty(FILL_VERTICAL, Boolean.TRUE);
    }

    private ItemListener buildRepainterHandler() {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
                abstractButton.repaint();
            }
        };
    }

    private void checkIntegrity(AbstractButton[] abstractButtonArray, JComponent[] jComponentArray) {
        if (abstractButtonArray.length == 0) {
            throw new NullPointerException("At least one button has to be used to create a GroupBox");
        }
        if (jComponentArray.length == 0) {
            throw new NullPointerException("At least one pane has to be used to create a GroupBox");
        }
        if (abstractButtonArray.length != jComponentArray.length) {
            throw new NullPointerException("The count of panes and buttons has to be the same, if no pane is associated with a button, null as to be set as for the pane");
        }
    }

    private Border createPaneBorder(AbstractButton abstractButton, JComponent jComponent) {
        return BorderFactory.createCompoundBorder(new AccessibleTitledBorder(abstractButton), BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGroupBox();
        }
        return this.accessibleContext;
    }

    protected void initializeLayout(AbstractButton[] abstractButtonArray, JComponent[] jComponentArray) {
        this.checkIntegrity(abstractButtonArray, jComponentArray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            boolean bl = i > 0 && jComponentArray[i - 1] != NO_PANE;
            AbstractButton abstractButton = abstractButtonArray[i];
            abstractButton.setOpaque(false);
            abstractButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), abstractButton.getBorder()));
            if (jComponentArray[i] != NO_PANE) {
                abstractButton.addItemListener(this.buildRepainterHandler());
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.insets = new Insets(bl ? 5 : 0, 0, 0, 0);
            this.add((Component)abstractButton, gridBagConstraints);
            JComponent jComponent = jComponentArray[i];
            if (jComponent == NO_PANE) continue;
            boolean bl2 = this.shouldFillVertical(jComponent);
            int n = abstractButton.getPreferredSize().height / 2 - 6;
            jComponent.setBorder(BorderFactory.createCompoundBorder(this.createPaneBorder(abstractButton, jComponent), jComponent.getBorder()));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = bl2 ? 1.0 : 0.0;
            gridBagConstraints.fill = bl2 ? 1 : 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(bl ? n + 5 : n, 0, 0, 0);
            this.add((Component)jComponent, gridBagConstraints);
        }
    }

    private boolean shouldFillVertical(JComponent jComponent) {
        Boolean bl = (Boolean)jComponent.getClientProperty(FILL_VERTICAL);
        return bl != null ? bl : false;
    }

    private static class AccessibleTitledBorder
    extends TitledBorder {
        private boolean changeTitle;

        private AccessibleTitledBorder(AbstractButton abstractButton) {
            super(abstractButton.getText());
            abstractButton.setFont(this.getFont(abstractButton));
            abstractButton.setForeground(this.getTitleColor());
        }

        public String getTitle() {
            if (this.changeTitle) {
                return "      " + super.getTitle();
            }
            return super.getTitle();
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.changeTitle = true;
            this.setTitleColor(component.getBackground());
            super.paintBorder(component, graphics, n, n2, n3, n4);
            this.changeTitle = false;
        }
    }

    protected class AccessibleGroupBox
    extends AccessibleTitledPanel.AccessibleAccessibleTitledPane {
        protected AccessibleGroupBox() {
        }
    }
}

