/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RegexpDocument
extends PlainDocument {
    private Pattern regularExpression;
    private static final Hashtable cachedRegularExpressions = new Hashtable();
    public static final int RE_CLASS = 2;
    public static final int RE_FIELD = 6;
    public static final int RE_FULLY_QUALIFIED_CLASS_NAME = 3;
    public static final int RE_INTERFACE = 4;
    public static final int RE_METHOD = 5;
    public static final int RE_NONE = 0;
    public static final int RE_NUMERIC_DECIMAL = 10;
    public static final int RE_NUMERIC_DECIMAL_NEGATIVE = 12;
    public static final int RE_NUMERIC_DECIMAL_POSITIVE = 11;
    public static final int RE_NUMERIC_DECIMAL_STRICT = 15;
    public static final int RE_NUMERIC_INTEGER = 7;
    public static final int RE_NUMERIC_INTEGER_NEGATIVE = 9;
    public static final int RE_NUMERIC_INTEGER_POSITIVE = 8;
    public static final int RE_NUMERIC_INTEGER_STRICT = 16;
    public static final int RE_OTHER = 14;
    public static final int RE_PACKAGE = 1;
    public static final int RE_SQL_RELATED = 13;
    public static final String RE_SYNTAX_CLASS = "([\\p{L}_][\\p{L}\\p{N}_]*(\\$[\\p{L}_][\\p{L}\\p{N}_]+)*(\\$\\p{N}+)?(\\$\\z)?)*";
    public static final String RE_SYNTAX_FULLY_QUALIFIED_CLASS_NAME = "([\\p{L}_][\\p{L}\\p{N}_]*(\\.[\\p{L}_][\\p{L}\\p{N}_]*)*(\\$[\\p{L}_][\\p{L}\\p{N}_]+)*(\\$\\p{N}+)?((\\.\\z)|(\\$\\z))?)*";
    public static final String RE_SYNTAX_IDENTIFIER = "([\\p{L}_][\\p{L}\\p{N}_]*)*";
    public static final String RE_SYNTAX_NONE = ".*";
    public static final String RE_SYNTAX_NUMERIC_DECIMAL = "[\\+-]?\\d*\\.?\\d*";
    public static final String RE_SYNTAX_NUMERIC_DECIMAL_NEGATIVE = "-?\\d*\\.?\\d*";
    public static final String RE_SYNTAX_NUMERIC_DECIMAL_POSITIVE = "\\+?\\d*\\.?\\d*";
    public static final String RE_SYNTAX_NUMERIC_DECIMAL_STRICT = "\\d*\\.?\\d*";
    public static final String RE_SYNTAX_NUMERIC_INTEGER = "[\\+-]?\\d*";
    public static final String RE_SYNTAX_NUMERIC_INTEGER_NEGATIVE = "-?\\d*";
    public static final String RE_SYNTAX_NUMERIC_INTEGER_POSITIVE = "\\+?\\d*";
    public static final String RE_SYNTAX_NUMERIC_INTEGER_STRICT = "\\d*";
    public static final String RE_SYNTAX_PACKAGE = "([\\p{L}_][\\p{L}\\p{N}_]*(\\.[\\p{L}_][\\p{L}\\p{N}_]*)*(\\.\\z)?)*";

    public RegexpDocument() {
        this(0);
    }

    public RegexpDocument(int n) {
        this(RegexpDocument.buildRegularExpression(n));
    }

    public RegexpDocument(Pattern pattern) {
        this.initialize(pattern);
    }

    public RegexpDocument(String string) {
        this(RegexpDocument.buildRegularExpression(string));
    }

    public static Document buildDocument(int n) {
        return new RegexpDocument(n);
    }

    public static Document buildDocument(Pattern pattern) {
        return new RegexpDocument(pattern);
    }

    public static Document buildDocument(String string) {
        return new RegexpDocument(string);
    }

    public static Pattern buildRegularExpression(int n) {
        switch (n) {
            case 2: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_CLASS);
            }
            case 3: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_FULLY_QUALIFIED_CLASS_NAME);
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_IDENTIFIER);
            }
            case 7: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_INTEGER);
            }
            case 9: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_INTEGER_NEGATIVE);
            }
            case 8: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_INTEGER_POSITIVE);
            }
            case 10: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_DECIMAL);
            }
            case 12: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_DECIMAL_NEGATIVE);
            }
            case 11: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_NUMERIC_DECIMAL_POSITIVE);
            }
            case 1: {
                return RegexpDocument.buildRegularExpression(RE_SYNTAX_PACKAGE);
            }
        }
        return null;
    }

    public static Pattern buildRegularExpression(String string) {
        return RegexpDocument.buildRegularExpression(string, 64);
    }

    public static Pattern buildRegularExpression(String string, int n) {
        Pattern pattern = (Pattern)cachedRegularExpressions.get(string);
        if (pattern == null) {
            pattern = Pattern.compile(string, n);
            cachedRegularExpressions.put(string, pattern);
        }
        return pattern;
    }

    protected Pattern getRegularExpression() {
        return this.regularExpression;
    }

    protected void initialize(Pattern pattern) {
        this.regularExpression = pattern;
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.regularExpression != null) {
            StringBuffer stringBuffer = new StringBuffer(this.getText(0, this.getLength()));
            stringBuffer.insert(n, string);
            String string2 = stringBuffer.toString();
            Matcher matcher = this.regularExpression.matcher(string2);
            if (!matcher.matches()) {
                return;
            }
        }
        super.insertString(n, string, attributeSet);
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.regularExpression != null) {
            StringBuffer stringBuffer = new StringBuffer(this.getText(0, this.getLength()));
            String string = (stringBuffer = stringBuffer.delete(n, n + n2)).toString();
            Matcher matcher = this.regularExpression.matcher(string);
            if (!matcher.matches()) {
                return;
            }
        }
        super.remove(n, n2);
    }
}

