/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickTrigger;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.NullPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.Combo;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxEditorWithDefault;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboBoxModelWithDefaultHandler;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExpandablePane;
import org.eclipse.persistence.tools.workbench.uitools.swing.SpinnerWithDefaultHandler;
import org.eclipse.persistence.tools.workbench.uitools.swing.TriStateCheckBox;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

public class SwingComponentFactory {
    private static DoubleClickMouseHandler doubleClickMouseHandler = new DoubleClickMouseHandler();
    private static Border STANDARD_EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String LABELED_BY_KEY = "labeledBy";

    public static void addDoubleClickMouseListener(Component component, DoubleClickMouseListener doubleClickMouseListener) {
        Object[] objectArray = (MouseListener[])component.getListeners(MouseListener.class);
        if (!CollectionTools.contains((Object[])objectArray, (Object)doubleClickMouseHandler)) {
            component.addMouseListener(doubleClickMouseHandler);
        }
        doubleClickMouseHandler.addMouseListener(component, doubleClickMouseListener);
    }

    public static JButton buildButton(String string, ResourceRepository resourceRepository) {
        JButton jButton = new JButton();
        jButton.setName(string);
        SwingComponentFactory.setTextFor(jButton, string, resourceRepository);
        return jButton;
    }

    public static final JButton buildBrowseButton(String string, ResourceRepository resourceRepository, Accessible accessible) {
        BrowseButton browseButton = new BrowseButton(accessible);
        browseButton.setName(string);
        SwingComponentFactory.setTextFor(browseButton, string, resourceRepository);
        return browseButton;
    }

    public static JCheckBox buildCheckBox(String string, ButtonModel buttonModel, ResourceRepository resourceRepository) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setModel(buttonModel);
        jCheckBox.setName(string);
        SwingComponentFactory.setTextFor(jCheckBox, string, resourceRepository);
        return jCheckBox;
    }

    private static PropertyValueModel buildCommentAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "comment"){

            protected Object getValueFromSubject() {
                return ((AbstractNodeModel)this.subject).getComment();
            }

            protected void setValueOnSubject(Object object) {
                ((AbstractNodeModel)this.subject).setComment((String)object);
            }
        };
    }

    private static Document buildCommentDocument(ValueModel valueModel) {
        return new DocumentAdapter(SwingComponentFactory.buildCommentAdapter(valueModel));
    }

    public static JComponent buildCommentPanel(ValueModel valueModel, ResourceRepository resourceRepository) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("COMMENT_LABEL", resourceRepository);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextArea jTextArea = new JTextArea(SwingComponentFactory.buildCommentDocument(valueModel));
        jTextArea.setFont(jLabel.getFont());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel.setLabelFor(jTextArea);
        int n = jTextArea.getFontMetrics(jTextArea.getFont()).getHeight();
        Insets insets = jTextArea.getBorder().getBorderInsets(jTextArea);
        n = 2 * n + insets.top + insets.bottom;
        Dimension dimension = new Dimension(10, n);
        jScrollPane.getViewport().setPreferredSize(dimension);
        jScrollPane.getViewport().setMinimumSize(dimension);
        jScrollPane.getViewport().setMaximumSize(dimension);
        return jPanel;
    }

    public static JComponent buildDoNotAskAgainPanel(String string, PropertyValueModel propertyValueModel, ResourceRepository resourceRepository) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        LabelArea labelArea = new LabelArea(string);
        labelArea.setScrollable(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)labelArea, gridBagConstraints);
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("DONT_SHOW_THIS_AGAIN_CHECK_BOX", new CheckBoxModelAdapter(propertyValueModel), resourceRepository);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        return jPanel;
    }

    public static JLabel buildLabel(String string, ResourceRepository resourceRepository) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        SwingComponentFactory.setTextFor(jLabel, string, resourceRepository);
        return jLabel;
    }

    public static JList buildList() {
        return new AccessibleList();
    }

    public static JList buildList(ListModel listModel) {
        return new AccessibleList(listModel);
    }

    public static JList buildList(Vector vector) {
        return new AccessibleList(vector);
    }

    public static Border buildTitledBorder(ResourceRepository resourceRepository, String string) {
        return BorderFactory.createTitledBorder(resourceRepository.getString(string));
    }

    public static JRadioButton buildRadioButton(String string, ButtonModel buttonModel, ResourceRepository resourceRepository) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(buttonModel);
        jRadioButton.setName(string);
        SwingComponentFactory.setTextFor(jRadioButton, string, resourceRepository);
        return jRadioButton;
    }

    public static JSpinner buildSpinnerNumber(SpinnerNumberModel spinnerNumberModel) {
        return SwingComponentFactory.buildSpinnerNumber(spinnerNumberModel, 4);
    }

    public static JSpinner buildSpinnerNumber(SpinnerNumberModel spinnerNumberModel, int n) {
        JSpinner jSpinner;
        block2: {
            jSpinner = new JSpinner(spinnerNumberModel);
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
            JFormattedTextField jFormattedTextField = numberEditor.getTextField();
            jFormattedTextField.setColumns(n);
            try {
                String string = jFormattedTextField.getFormatter().valueToString(spinnerNumberModel.getValue());
                jFormattedTextField.setText(string);
            }
            catch (ParseException parseException) {
                if (spinnerNumberModel.getValue() == null) break block2;
                jFormattedTextField.setText(spinnerNumberModel.getValue().toString());
            }
        }
        return jSpinner;
    }

    public static Border buildStandardEmptyBorder() {
        return STANDARD_EMPTY_BORDER;
    }

    public static JTable buildTable(TableModel tableModel) {
        return SwingComponentFactory.buildTable(tableModel, null, null);
    }

    public static JTable buildTable(TableModel tableModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable(tableModel, null, listSelectionModel);
    }

    public static JTable buildTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        InternalJTable internalJTable = new InternalJTable(tableModel, tableColumnModel, listSelectionModel);
        internalJTable.setDoubleBuffered(true);
        internalJTable.setAutoResizeMode(1);
        return internalJTable;
    }

    public static void attachTableEditorCanceler(final JTable jTable, ValueModel valueModel) {
        valueModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().cancelCellEditing();
                }
            }
        });
    }

    public static void attachDateSpinnerCommiter(final JSpinner jSpinner, ValueModel valueModel) {
        valueModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                try {
                    jSpinner.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
    }

    public static JTextField buildTextField(Document document) {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(document);
        return jTextField;
    }

    public static JTree buildTree() {
        return new AccessibleTree();
    }

    public static JTree buildTree(TreeModel treeModel) {
        return new AccessibleTree(treeModel);
    }

    public static void installCellRenderer(JComboBox jComboBox, ListCellRenderer listCellRenderer) {
        jComboBox.setPrototypeDisplayValue(ComboBoxTableCellRenderer.prototypeLabel);
        jComboBox.setRenderer(new InternalListCellRenderer(listCellRenderer, jComboBox.getRenderer()));
    }

    public static void installComboBoxEditorWithDefault(JComboBox jComboBox, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, BidiStringConverter bidiStringConverter, Object object) {
        SwingComponentFactory.installComboBoxEditorWithDefault(jComboBox, valueModel, propertyValueModel, valueModel2, bidiStringConverter, object, null);
    }

    public static void installComboBoxEditorWithDefault(JComboBox jComboBox, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, BidiStringConverter bidiStringConverter, Object object, CellRendererAdapter cellRendererAdapter) {
        jComboBox.setEditable(true);
        ComboBoxEditorWithDefault comboBoxEditorWithDefault = new ComboBoxEditorWithDefault(jComboBox.getEditor(), valueModel, propertyValueModel, valueModel2, cellRendererAdapter);
        ComboBoxEditorAdapter comboBoxEditorAdapter = new ComboBoxEditorAdapter(comboBoxEditorWithDefault, bidiStringConverter, object);
        jComboBox.setEditor(comboBoxEditorAdapter);
    }

    public static void removeDoubleClickMouseListener(Component component, DoubleClickMouseListener doubleClickMouseListener) {
        doubleClickMouseHandler.removeMouseListener(component, doubleClickMouseListener);
        if (!doubleClickMouseHandler.hasListeners(component)) {
            component.removeMouseListener(doubleClickMouseHandler);
        }
    }

    public static void setTextFor(AbstractButton abstractButton, String string, Object[] objectArray, ResourceRepository resourceRepository) {
        abstractButton.setText(resourceRepository.getString(string, objectArray));
        abstractButton.setMnemonic(resourceRepository.getMnemonic(string));
        abstractButton.setDisplayedMnemonicIndex(resourceRepository.getMnemonicIndex(string));
    }

    public static void setTextFor(AbstractButton abstractButton, String string, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(abstractButton, string, EMPTY_OBJECT_ARRAY, resourceRepository);
    }

    public static void setTextFor(JLabel jLabel, String string, Object object, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(jLabel, string, new Object[]{object}, resourceRepository);
    }

    public static void setTextFor(JLabel jLabel, String string, Object[] objectArray, ResourceRepository resourceRepository) {
        jLabel.setText(resourceRepository.getString(string, objectArray));
        jLabel.setDisplayedMnemonic(resourceRepository.getMnemonic(string));
        jLabel.setDisplayedMnemonicIndex(resourceRepository.getMnemonicIndex(string));
    }

    public static void setTextFor(JLabel jLabel, String string, ResourceRepository resourceRepository) {
        SwingComponentFactory.setTextFor(jLabel, string, EMPTY_OBJECT_ARRAY, resourceRepository);
    }

    public static void updateButtonAccessibleName(JLabel jLabel, AbstractButton abstractButton) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(jLabel.getAccessibleContext().getAccessibleName());
        stringBuffer.append(" ");
        stringBuffer.append(abstractButton.getAccessibleContext().getAccessibleName());
        abstractButton.getAccessibleContext().setAccessibleName(stringBuffer.toString());
    }

    public static Border buildTitledBorder(String string, ResourceRepository resourceRepository) {
        return BorderFactory.createTitledBorder(resourceRepository.getString(string));
    }

    public static Border buildPaneTitledBorder(String string, ResourceRepository resourceRepository) {
        return BorderFactory.createCompoundBorder(SwingComponentFactory.buildTitledBorder(string, resourceRepository), BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    public static ExpandablePane buildExpandablePanel(String string, JComponent jComponent, boolean bl, ResourceRepository resourceRepository) {
        return SwingComponentFactory.buildExpandablePanel(string, string, jComponent, bl, resourceRepository);
    }

    public static ExpandablePane buildExpandablePanel(String string, JComponent jComponent, ResourceRepository resourceRepository) {
        return SwingComponentFactory.buildExpandablePanel(string, string, jComponent, false, resourceRepository);
    }

    public static ExpandablePane buildExpandablePanel(String string, String string2, JComponent jComponent, boolean bl, ResourceRepository resourceRepository) {
        return new ExpandablePane(resourceRepository.getString(string), resourceRepository.getString(string2), resourceRepository.getIcon("expand"), resourceRepository.getIcon("collapse"), resourceRepository.getIcon("expand.disabled"), resourceRepository.getIcon("collapse.disabled"), resourceRepository.getIcon("expand.focus"), resourceRepository.getIcon("collapse.focus"), resourceRepository.getIcon("expand.pressed"), resourceRepository.getIcon("collapse.pressed"), jComponent, bl);
    }

    public static ExpandablePane buildExpandablePanel(String string, String string2, JComponent jComponent, ResourceRepository resourceRepository) {
        return SwingComponentFactory.buildExpandablePanel(string, string2, jComponent, false, resourceRepository);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, cellRendererAdapter, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, cellRendererAdapter, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledComboBox(String string, ComboBoxModel comboBoxModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    private static JComponent buildLabeledComboBoxImp(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, JComponent jComponent, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl, boolean bl2) {
        return SwingComponentFactory.buildLabeledComponent(string, (JComponent)(bl2 ? SwingComponentFactory.buildListChooser(comboBoxModel, cellRendererAdapter) : SwingComponentFactory.buildComboBox(comboBoxModel, cellRendererAdapter)), jComponent == null ? new Spacer() : jComponent, resourceRepository, componentAligner, componentAligner2, bl);
    }

    private static JComponent buildLabeledComboBoxImp(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl, boolean bl2) {
        return SwingComponentFactory.buildLabeledComponent(string, (JComponent)(bl2 ? SwingComponentFactory.buildListChooser(comboBoxModel, listCellRenderer) : SwingComponentFactory.buildComboBox(comboBoxModel, listCellRenderer)), jComponent == null ? new Spacer() : jComponent, resourceRepository, componentAligner, componentAligner2, bl);
    }

    public static Combo buildComboBox(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        Combo combo = SwingComponentFactory.buildComboBox(comboBoxModel);
        if (listCellRenderer != null) {
            SwingComponentFactory.installCellRenderer(combo, listCellRenderer);
        }
        return combo;
    }

    public static Combo buildComboBox(ComboBoxModel comboBoxModel) {
        Combo combo = new Combo(comboBoxModel);
        return combo;
    }

    public static ListChooser buildListChooser(ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer) {
        ListChooser listChooser = SwingComponentFactory.buildListChooser(comboBoxModel);
        if (listCellRenderer != null) {
            SwingComponentFactory.installCellRenderer(listChooser, listCellRenderer);
        }
        return listChooser;
    }

    public static ListChooser buildListChooser(ComboBoxModel comboBoxModel) {
        ListChooser listChooser = comboBoxModel instanceof CachingComboBoxModel ? new ListChooser((CachingComboBoxModel)comboBoxModel) : new ListChooser(comboBoxModel);
        listChooser.setLongListSize(Integer.MAX_VALUE);
        return listChooser;
    }

    public static JComponent buildLabeledComponent(String string, JComponent jComponent, JComponent jComponent2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, jComponent2, resourceRepository, componentAligner, componentAligner2, false);
    }

    public static JComponent buildLabeledComponent(String string, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, (JComponent)new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    private static JComponent buildLabeledComponent(String string, JComponent jComponent, JComponent jComponent2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl) {
        return SwingComponentFactory.buildLabeledComponent(SwingComponentFactory.buildLabel(string, resourceRepository), jComponent, jComponent2, resourceRepository, componentAligner, componentAligner2, bl);
    }

    public static JComponent buildLabeledComponent(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(jComponent, jComponent2, jComponent3, resourceRepository, componentAligner, componentAligner2, false);
    }

    private static JComponent buildLabeledComponent(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = bl ? 2 : 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        componentAligner.add(jComponent);
        gridBagConstraints.gridx = bl ? 0 : 1;
        gridBagConstraints.gridy = bl ? 1 : 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(bl ? 1 : 0, bl ? 0 : 5, 0, 0);
        if (jComponent2 instanceof JScrollPane || jComponent2 instanceof Scrollable) {
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
        } else {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
        }
        pane.add((Component)jComponent2, gridBagConstraints);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            jLabel.setLabelFor(jComponent2);
        } else {
            jComponent2.putClientProperty(LABELED_BY_KEY, jComponent);
        }
        if (jComponent3 != null) {
            gridBagConstraints.gridx = bl ? 1 : 2;
            gridBagConstraints.gridy = bl ? 1 : 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(bl ? 1 : 0, 5, 0, 0);
            pane.add((Component)jComponent3, gridBagConstraints);
            componentAligner2.add(jComponent3);
            if (jComponent3 instanceof AbstractButton && jComponent instanceof Accessible) {
                SwingComponentFactory.updateButtonAccessibleName((Accessible)((Object)jComponent), jComponent3);
            }
        }
        return pane;
    }

    private static JComponent buildLabeledEditableComboBoxImp(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl, boolean bl2) {
        JComponent jComponent2 = SwingComponentFactory.buildLabeledComboBoxImp(string, (ComboBoxModel)new ComboBoxModelWithDefaultHandler(comboBoxModel, valueModel2), listCellRenderer, jComponent, object, resourceRepository, componentAligner, componentAligner2, bl, bl2);
        JComboBox jComboBox = (JComboBox)jComponent2.getComponent(1);
        SwingComponentFactory.installComboBoxEditorWithDefault(jComboBox, valueModel, propertyValueModel, valueModel2, bidiStringConverter, object);
        return jComponent2;
    }

    public static void updateButtonAccessibleName(Accessible accessible, JComponent jComponent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(accessible.getAccessibleContext().getAccessibleName());
        stringBuilder.append(' ');
        stringBuilder.append(jComponent.getAccessibleContext().getAccessibleName());
        jComponent.getAccessibleContext().setAccessibleName(stringBuilder.toString());
    }

    public static ListChooser buildListChooser(ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter) {
        ListChooser listChooser = SwingComponentFactory.buildListChooser(comboBoxModel);
        if (cellRendererAdapter != null) {
            listChooser.setRendererAdapter(cellRendererAdapter);
        }
        return listChooser;
    }

    public static Combo buildComboBox(ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter) {
        Combo combo = SwingComponentFactory.buildComboBox(comboBoxModel);
        if (cellRendererAdapter != null) {
            combo.setRendererAdapter(cellRendererAdapter);
        }
        return combo;
    }

    private static JComponent buildLabeledEditableComboBoxImp(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, CellRendererAdapter cellRendererAdapter, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2, boolean bl, boolean bl2) {
        JComponent jComponent2 = SwingComponentFactory.buildLabeledComboBoxImp(string, (ComboBoxModel)new ComboBoxModelWithDefaultHandler(comboBoxModel, valueModel2), cellRendererAdapter, jComponent, object, resourceRepository, componentAligner, componentAligner2, bl, bl2);
        JComboBox jComboBox = (JComboBox)jComponent2.getComponent(1);
        SwingComponentFactory.installComboBoxEditorWithDefault(jComboBox, valueModel, propertyValueModel, valueModel2, bidiStringConverter, object);
        return jComponent2;
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, CellRendererAdapter cellRendererAdapter, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), cellRendererAdapter, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, CellRendererAdapter cellRendererAdapter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), cellRendererAdapter, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, jComponent, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, CellRendererAdapter cellRendererAdapter, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, cellRendererAdapter, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, jComponent, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, false);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, CellRendererAdapter cellRendererAdapter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), cellRendererAdapter, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, jComponent, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, jComponent, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, cellRendererAdapter, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, cellRendererAdapter, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, jComponent, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledListChooser(String string, ComboBoxModel comboBoxModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, null, resourceRepository, componentAligner, componentAligner2, false, true);
    }

    public static JComponent buildLabeledNonEditableTextField(String string, Document document, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        JTextField jTextField = SwingComponentFactory.buildTextField(document);
        jTextField.setEditable(false);
        return SwingComponentFactory.buildLabeledComponent(string, (JComponent)jTextField, jComponent, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledNonEditableTextField(String string, Document document, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledNonEditableTextField(string, document, new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledSpinnerDate(String string, SpinnerDateModel spinnerDateModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, SwingComponentFactory.buildSpinnerDate(spinnerDateModel), resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel, int n, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel(string, resourceRepository);
        pane.add((Component)jLabel, gridBagConstraints);
        componentAligner.add(jLabel);
        JSpinner jSpinner = SwingComponentFactory.buildSpinnerNumber(spinnerNumberModel, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)jSpinner, gridBagConstraints);
        jLabel.setLabelFor(jSpinner);
        jSpinner.setName(string);
        Spacer spacer = new Spacer();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        pane.add((Component)spacer, gridBagConstraints);
        componentAligner2.add(spacer);
        return pane;
    }

    public static JComponent buildLabeledSpinnerNumber(String string, SpinnerNumberModel spinnerNumberModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(string, spinnerNumberModel, 4, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledSpinnerNumber(String string, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Comparable comparable, Comparable comparable2, Number number, int n, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel(string, resourceRepository);
        pane.add((Component)jLabel, gridBagConstraints);
        componentAligner.add(jLabel);
        JSpinner jSpinner = SwingComponentFactory.buildSpinnerNumber(valueModel, propertyValueModel, valueModel2, comparable, comparable2, number, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add((Component)jSpinner, gridBagConstraints);
        jLabel.setLabelFor(jSpinner);
        jSpinner.setName(string);
        Spacer spacer = new Spacer();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        pane.add((Component)spacer, gridBagConstraints);
        componentAligner2.add(spacer);
        return pane;
    }

    public static JComponent buildLabeledSpinnerNumber(String string, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Comparable comparable, Comparable comparable2, Number number, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledSpinnerNumber(string, valueModel, propertyValueModel, valueModel2, comparable, comparable2, number, 4, resourceRepository, componentAligner, componentAligner2);
    }

    public static JSpinner buildSpinnerDate(SpinnerDateModel spinnerDateModel) {
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(spinnerDateModel);
        return jSpinner;
    }

    public static JSpinner buildSpinnerNumber(ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Comparable comparable, Comparable comparable2, Number number, int n) {
        SpinnerWithDefaultHandler spinnerWithDefaultHandler = new SpinnerWithDefaultHandler(valueModel, propertyValueModel, valueModel2, comparable, comparable2, number);
        JSpinner jSpinner = spinnerWithDefaultHandler.getSpinner();
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
        JFormattedTextField jFormattedTextField = numberEditor.getTextField();
        jFormattedTextField.setColumns(n);
        return jSpinner;
    }

    public static JComponent buildLabeledTextField(String string, Document document, int n, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, (JComponent)SwingComponentFactory.buildTextField(document, n), jComponent, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledTextField(String string, Document document, int n, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledTextField(string, document, n, new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledTextField(String string, Document document, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, (JComponent)SwingComponentFactory.buildTextField(document), jComponent, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledTextField(String string, Document document, JTextField jTextField, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        jTextField.setDocument(document);
        return SwingComponentFactory.buildLabeledComponent(string, jTextField, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildLabeledTextField(String string, Document document, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledTextField(string, document, new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JTextField buildTextField(Document document, int n) {
        JTextField jTextField = new JTextField(document, null, n);
        return jTextField;
    }

    public static JToggleButton buildToggleButton(String string, ResourceRepository resourceRepository) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setName(string);
        SwingComponentFactory.setTextFor(jToggleButton, string, resourceRepository);
        return jToggleButton;
    }

    public static JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, CellRendererAdapter cellRendererAdapter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, cellRendererAdapter, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, (Object)jComponent, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, (Object)jComponent, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledComboBox(String string, ComboBoxModel comboBoxModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledComponent(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(jComponent, jComponent2, jComponent3, resourceRepository, componentAligner, componentAligner2, true);
    }

    public static JComponent buildTopLabeledComponent(String string, JComponent jComponent, JComponent jComponent2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, jComponent2, resourceRepository, componentAligner, componentAligner2, true);
    }

    public static JComponent buildTopLabeledComponent(String string, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComponent(string, jComponent, (JComponent)new Spacer(), resourceRepository, componentAligner, componentAligner2, true);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableComboBox(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, false);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, (ValueModel)NullPropertyValueModel.instance(), (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, jComponent, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, BidiStringConverter bidiStringConverter, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, bidiStringConverter, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, listCellRenderer, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, Object object, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, object, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledEditableListChooser(String string, ComboBoxModel comboBoxModel, ValueModel valueModel, PropertyValueModel propertyValueModel, ValueModel valueModel2, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledEditableComboBoxImp(string, comboBoxModel, valueModel, propertyValueModel, valueModel2, (CellRendererAdapter)null, BidiStringConverter.DEFAULT_INSTANCE, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, (Object)jComponent, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, (Object)jComponent, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, listCellRenderer, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledListChooser(String string, ComboBoxModel comboBoxModel, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildLabeledComboBoxImp(string, comboBoxModel, (CellRendererAdapter)null, null, null, resourceRepository, componentAligner, componentAligner2, true, true);
    }

    public static JComponent buildTopLabeledNonEditableTextField(String string, Document document, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        JTextField jTextField = SwingComponentFactory.buildTextField(document);
        jTextField.setEditable(false);
        return SwingComponentFactory.buildTopLabeledComponent(string, (JComponent)jTextField, jComponent, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildTopLabeledTextArea(String string, Document document, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildTopLabeledComponent(string, (JComponent)SwingComponentFactory.buildTextArea(document), (JComponent)new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildTopLabeledTextField(String string, Document document, int n, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildTopLabeledComponent(string, (JComponent)SwingComponentFactory.buildTextField(document, n), (JComponent)new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildTopLabeledTextField(String string, Document document, JComponent jComponent, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildTopLabeledComponent(string, (JComponent)SwingComponentFactory.buildTextField(document), jComponent, resourceRepository, componentAligner, componentAligner2);
    }

    public static JComponent buildTopLabeledTextField(String string, Document document, ResourceRepository resourceRepository, ComponentAligner componentAligner, ComponentAligner componentAligner2) {
        return SwingComponentFactory.buildTopLabeledTextField(string, document, new Spacer(), resourceRepository, componentAligner, componentAligner2);
    }

    public static JTextArea buildTextArea(Document document) {
        TextArea textArea = new TextArea(document);
        return textArea;
    }

    public static TriStateCheckBox buildTriStateCheckBox(String string, TriStateCheckBox.TriStateButtonModel triStateButtonModel, ResourceRepository resourceRepository) {
        TriStateCheckBox triStateCheckBox = new TriStateCheckBox();
        triStateCheckBox.setModel(triStateButtonModel);
        triStateCheckBox.setOpaque(false);
        SwingComponentFactory.setTextFor(triStateCheckBox, string, resourceRepository);
        return triStateCheckBox;
    }

    private static class TextArea
    extends JTextArea {
        private int minimumHeight;

        TextArea(Document document) {
            super(document);
            this.initialize();
        }

        private int calculateMinimumHeight() {
            int n = this.getFontMetrics(this.getFont()).getHeight() * 5;
            Insets insets = this.getInsets();
            return n += insets.top + insets.bottom;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.minimumHeight == 0) {
                this.minimumHeight = this.calculateMinimumHeight();
            }
            dimension.height = Math.max(this.minimumHeight, dimension.height);
            return dimension;
        }

        private void initialize() {
            this.setFont(UIManager.getFont("Label.font"));
            Insets insets = this.getMargin();
            this.setBorder(BorderFactory.createCompoundBorder());
        }
    }

    private static class InternalListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer customRenderer;
        private final ListCellRenderer defaultDelegate;

        public InternalListCellRenderer(ListCellRenderer listCellRenderer, ListCellRenderer listCellRenderer2) {
            this.customRenderer = listCellRenderer;
            this.defaultDelegate = listCellRenderer2;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == ComboBoxTableCellRenderer.prototypeLabel) {
                return ComboBoxTableCellRenderer.prototypeLabel;
            }
            JLabel jLabel = (JLabel)this.customRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            JLabel jLabel2 = (JLabel)this.defaultDelegate.getListCellRendererComponent(jList, null, n, bl, bl2);
            jLabel2.setText(jLabel.getText());
            jLabel2.setIcon(jLabel.getIcon());
            jLabel2.setToolTipText(jLabel.getToolTipText());
            jLabel2.getAccessibleContext().setAccessibleName(jLabel.getAccessibleContext().getAccessibleName());
            if (!jList.hasFocus() && bl && jList.isFocusable()) {
                jLabel2.setForeground(jList.getForeground());
                jLabel2.setBackground(UIManager.getColor("Panel.background"));
            }
            if (jLabel2.getIcon() == null) {
                jLabel2.setIcon(EmptyIcon.SMALL_ICON);
                jLabel2.setPreferredSize(jLabel2.getPreferredSize());
                jLabel2.setIcon(null);
            }
            return jLabel2;
        }
    }

    private static class InternalJTable
    extends JTable {
        InternalJTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
            super(tableModel, tableColumnModel, listSelectionModel);
        }

        public Color getBackground() {
            if (!this.isEnabled()) {
                return UIManager.getColor("control");
            }
            return super.getBackground();
        }

        public Color getForeground() {
            if (!this.isEnabled()) {
                return UIManager.getColor("controlText");
            }
            return super.getForeground();
        }

        private boolean isMousePressed(MouseEvent mouseEvent) {
            return (mouseEvent.getModifiers() & 0x1F5) != 0;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (this.isEditing() && SwingUtilities.isLeftMouseButton(mouseEvent) && this.isMousePressed(mouseEvent) && !(rectangle = this.getCellRect(this.getEditingRow(), this.getEditingColumn(), true)).contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.getCellEditor().stopCellEditing();
            }
            super.processMouseEvent(mouseEvent);
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            if (bl2 != bl && this.getParent() != null) {
                this.getParent().setBackground(this.getBackground());
                this.getParent().repaint();
            }
        }
    }

    private static class DoubleClickMouseHandler
    extends MouseAdapter {
        private final Map componentMouseListeners;
        private final DoubleClickTrigger trigger = new DoubleClickTrigger();

        DoubleClickMouseHandler() {
            this.componentMouseListeners = new Hashtable();
        }

        void addMouseListener(Component component, DoubleClickMouseListener doubleClickMouseListener) {
            Vector<DoubleClickMouseListener> vector = (Vector<DoubleClickMouseListener>)this.componentMouseListeners.get(component);
            if (vector == null) {
                vector = new Vector<DoubleClickMouseListener>();
                this.componentMouseListeners.put(component, vector);
            }
            vector.add(doubleClickMouseListener);
        }

        private void fireMouseDoucleClicked(MouseEvent mouseEvent) {
            List list = (List)this.componentMouseListeners.get(mouseEvent.getComponent());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((DoubleClickMouseListener)iterator.next()).mouseDoubleClicked(mouseEvent);
            }
        }

        boolean hasListeners(Component component) {
            return this.componentMouseListeners.containsKey(component);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.trigger.isDoubleClick(mouseEvent)) {
                this.fireMouseDoucleClicked(mouseEvent);
            }
        }

        void removeMouseListener(Component component, DoubleClickMouseListener doubleClickMouseListener) {
            List list = (List)this.componentMouseListeners.get(component);
            if (list == null || !list.contains(doubleClickMouseListener)) {
                throw new IllegalStateException("Can't remove a listener that was not registered");
            }
            list.remove(doubleClickMouseListener);
            if (list.isEmpty()) {
                list.remove(component);
            }
        }
    }

    public static class AccessibleTree
    extends JTree {
        public AccessibleTree() {
        }

        public AccessibleTree(TreeModel treeModel) {
            super(treeModel);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleAccessibleTree();
            }
            return this.accessibleContext;
        }

        protected class AccessibleAccessibleTree
        extends JTree.AccessibleJTree {
            protected AccessibleAccessibleTree() {
                super(AccessibleTree.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string != null) {
                    return string;
                }
                if (AccessibleTree.this.getParent() instanceof JViewport) {
                    JComponent jComponent = (JComponent)AccessibleTree.this.getParent().getParent().getParent();
                    return jComponent.getAccessibleContext().getAccessibleName();
                }
                return null;
            }
        }
    }

    public static class AccessibleList
    extends JList {
        public AccessibleList() {
        }

        public AccessibleList(ListModel listModel) {
            super(listModel);
        }

        public AccessibleList(Vector vector) {
            super(vector);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleAccessibleList();
            }
            return this.accessibleContext;
        }

        protected class AccessibleAccessibleList
        extends JList.AccessibleJList {
            protected AccessibleAccessibleList() {
                super(AccessibleList.this);
            }

            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string != null) {
                    return string;
                }
                if (AccessibleList.this.getParent() instanceof JViewport) {
                    JComponent jComponent = (JComponent)AccessibleList.this.getParent().getParent().getParent();
                    return jComponent.getAccessibleContext().getAccessibleName();
                }
                return null;
            }
        }
    }

    protected static class BrowseButton
    extends JButton {
        Accessible labeler;

        protected BrowseButton(Accessible accessible) {
            this.labeler = accessible;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                if (this.labeler == null) {
                    return super.getAccessibleContext();
                }
                this.accessibleContext = new AccessibleBrowseButton();
            }
            return this.accessibleContext;
        }

        protected class AccessibleBrowseButton
        extends JButton.AccessibleJButton {
            protected AccessibleBrowseButton() {
                super(BrowseButton.this);
            }

            public String getAccessibleDescription() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(BrowseButton.this.labeler.getAccessibleContext().getAccessibleDescription());
                stringBuffer.append(" ");
                stringBuffer.append(super.getAccessibleDescription());
                return stringBuffer.toString();
            }

            public String getAccessibleName() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(BrowseButton.this.labeler.getAccessibleContext().getAccessibleName());
                stringBuffer.append(" ");
                stringBuffer.append(super.getAccessibleName());
                return stringBuffer.toString();
            }
        }
    }
}

