/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

public final class AutomapAction
extends AbstractEnablableFrameworkAction {
    public AutomapAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("AUTOMAP_ACTION");
        this.initializeToolTipText("AUTOMAP_ACTION.TOOLTIP");
        this.initializeIcon("automap");
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return ((MappingsApplicationNode)applicationNode).isAutoMappable();
    }

    protected void execute() {
        ApplicationNode[] applicationNodeArray = this.selectedProjectNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            this.execute((ProjectNode)applicationNodeArray[i]);
        }
    }

    private void execute(ProjectNode projectNode) {
        if (projectNode.canAutomapDescriptors()) {
            projectNode.getProject().automap(this.selectedDescriptorsFor(projectNode));
            this.showResults(this.prepareResults(this.selectedNodesFor(projectNode)));
        } else {
            this.showError(projectNode.getCannotAutomapDescriptorsStringKey());
        }
    }

    private Collection selectedDescriptorsFor(ProjectNode projectNode) {
        HashSet hashSet = new HashSet();
        for (MappingsApplicationNode mappingsApplicationNode : this.selectedNodesFor(projectNode)) {
            if (mappingsApplicationNode.getProjectNode() != projectNode) continue;
            mappingsApplicationNode.addDescriptorsTo(hashSet);
        }
        return hashSet;
    }

    private Collection selectedNodesFor(ProjectNode projectNode) {
        ArrayList<MappingsApplicationNode> arrayList = new ArrayList<MappingsApplicationNode>();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            MappingsApplicationNode mappingsApplicationNode = (MappingsApplicationNode)applicationNodeArray[i];
            if (mappingsApplicationNode.getProjectNode() != projectNode) continue;
            arrayList.add(mappingsApplicationNode);
        }
        return arrayList;
    }

    private Collection prepareResults(Collection collection) {
        ArrayList<StatusDialog.Status> arrayList = new ArrayList<StatusDialog.Status>(collection.size());
        for (ApplicationNode applicationNode : collection) {
            MWError mWError = this.buildError(applicationNode);
            LinkedHashMap<MWError, MWError> linkedHashMap = new LinkedHashMap<MWError, MWError>();
            linkedHashMap.put(mWError, mWError);
            StatusDialog.Status status = StatusDialog.createStatus((Object)applicationNode, linkedHashMap);
            arrayList.add(status);
        }
        return arrayList;
    }

    private MWError buildError(ApplicationNode applicationNode) {
        return new MWError(((AutomappableNode)((Object)applicationNode)).getAutomapSuccessfulStringKey(), (Object)applicationNode.displayString());
    }

    private void showResults(Collection collection) {
        StatusDialog statusDialog = new StatusDialog(this.getWorkbenchContext(), collection, "AUTOMAP_STATUS_DIALOG_TITLE", "dialog.automap"){

            protected CellRendererAdapter buildNodeRenderer(Object object) {
                return object instanceof ApplicationNode ? this.buildApplicationNodeAdapter() : super.buildNodeRenderer(object);
            }

            private CellRendererAdapter buildApplicationNodeAdapter() {
                return new AbstractCellRendererAdapter(){

                    public String buildAccessibleName(Object object) {
                        return ((ApplicationNode)object).accessibleName();
                    }

                    public Icon buildIcon(Object object) {
                        return ((ApplicationNode)object).icon();
                    }

                    public String buildText(Object object) {
                        return ((ApplicationNode)object).displayString();
                    }
                };
            }
        };
        statusDialog.setVisible(true);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString(string), this.resourceRepository().getString(string + ".title"), 2);
    }
}

