/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProjectDeploymentXmlGenerationCoordinator;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction
extends AbstractEnablableFrameworkAction {
    ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_ACTION");
        this.initializeToolTipText("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_ACTION.toolTipText");
        this.initializeIcon("GENERATE_XML");
    }

    protected void execute() {
        ProjectDeploymentXmlGenerationCoordinator projectDeploymentXmlGenerationCoordinator = new ProjectDeploymentXmlGenerationCoordinator(this.getWorkbenchContext());
        ApplicationNode[] applicationNodeArray = this.selectedProjectNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            MWProject mWProject = (MWProject)applicationNodeArray[i].getValue();
            if (!projectDeploymentXmlGenerationCoordinator.exportProjectDeploymentXml(mWProject)) continue;
            File file = mWProject.deploymentXMLFile();
            Project project = XMLProjectReader.read((String)file.getAbsolutePath(), (ClassLoader)this.buildClassLoader(mWProject));
            DatabaseSessionImpl databaseSessionImpl = (DatabaseSessionImpl)project.createDatabaseSession();
            databaseSessionImpl.dontLogMessages();
            databaseSessionImpl.initializeDescriptors();
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("EXPORT_DEPLOYMENT_XML_AND_INITIALIZE_RUNTIME_DESCRIPTORS_STATUS_BAR"));
        }
    }

    private ClassLoader buildClassLoader(MWProject mWProject) {
        Classpath classpath = new Classpath(CollectionTools.list((Iterator)mWProject.getRepository().fullyQualifiedClasspathEntries()));
        return new URLClassLoader(classpath.urls(), this.getClass().getClassLoader());
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return this.selectedProjectNodes().length > 0;
    }
}

