/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuItemDescription;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.LegacyProjectReadCallback;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AddOrRefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomapAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.CreateNewClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportSpecificDescriptorModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.LegacyProjectMigrationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ManageNonDescriptorClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginResourceBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewProjectAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.OracleHelpAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProblemsBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemoveAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.preferences.MappingsPreferencesNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.ExportTableCreatorJavaSourceAction;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Command;
import org.eclipse.persistence.tools.workbench.utility.Stack;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedObject;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedStack;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MappingsPlugin
implements Plugin {
    private ApplicationContext mwApplicationContext;
    private SynchronizedObject synchronizedIOManager;
    private Map propertiesPageCache;
    SynchronizedStack propertiesPageBuilderStack;
    private static final String MAPPINGS_PREFERENCES_NODE = "mappings";
    public static final String REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "persistence type remove ejb2x info";
    public static final String REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "persistence type remove ejb info";
    public static final String CHANGE_QUERY_TYPE_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "query change query type";
    public static final String CHANGE_QUERY_FORMAT_DO_NOT_SHOW_THIS_AGAIN_PREFERENCE = "query change query format";
    public static final String EXPORT_LOCATION_PREFERENCE = "export location";
    private static final String[] PRE_BUILT_PROPERTIES_PAGES = new String[]{"org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabasePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackagePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.AggregateDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.InterfaceDescriptorPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.EisCompositeDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.EisRootDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.OXDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.AggregateMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.DirectToFieldMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.DirectToXmlTypePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.ManyToManyMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.OneToManyMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.OneToOneMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalDirectCollectionMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalDirectMapMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.VariableOneToOneMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisCompositeCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXCompositeCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisCompositeObjectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXCompositeObjectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisOneToManyTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisOneToOneTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OxDirectCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisDirectCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OxDirectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisDirectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.EisProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.OXProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryPanel"};

    MappingsPlugin(ApplicationContext applicationContext) {
        this.mwApplicationContext = this.wrap(applicationContext);
        this.startInitializeSynchronizedIOManager();
        this.initializePreferences();
        this.initializePropertiesPageBuilder();
    }

    private void startInitializeSynchronizedIOManager() {
        this.synchronizedIOManager = new SynchronizedObject();
        Thread thread = new Thread(this.buildInitializeSynchronizedIOManagerRunnable(), "Initialize Mappings I/O Manager");
        thread.setPriority(1);
        thread.start();
    }

    private Runnable buildInitializeSynchronizedIOManagerRunnable() {
        return new Runnable(){

            public void run() {
                MappingsPlugin.this.initializeSynchronizedIOManager();
            }
        };
    }

    void initializeSynchronizedIOManager() {
        try {
            this.synchronizedIOManager.execute(this.buildInitializeIOManagerCommand());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private Command buildInitializeIOManagerCommand() {
        return new Command(){

            public void execute() {
                MappingsPlugin.this.initializeIOManager();
            }
        };
    }

    void initializeIOManager() {
        this.synchronizedIOManager.setValue((Object)new ProjectIOManager());
    }

    private void initializePreferences() {
        Preferences preferences = this.mwApplicationContext.getPreferences();
        String string = preferences.get(REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, TriStateBoolean.UNDEFINED.toString());
        preferences.put(REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, string);
        string = preferences.get(REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, TriStateBoolean.UNDEFINED.toString());
        preferences.put(REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, string);
    }

    private void initializePropertiesPageBuilder() {
        this.propertiesPageCache = new HashMap(PRE_BUILT_PROPERTIES_PAGES.length);
        this.propertiesPageBuilderStack = new SynchronizedStack();
        int n = PRE_BUILT_PROPERTIES_PAGES.length;
        while (n-- > 0) {
            this.propertiesPageBuilderStack.push((Object)this.classForName(PRE_BUILT_PROPERTIES_PAGES[n]));
        }
        new PropertiesPageBuilder().start();
    }

    private Class classForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(string);
        }
    }

    public JMenuItem[] buildNewMenuItems(WorkbenchContext workbenchContext) {
        workbenchContext = this.wrap(workbenchContext);
        JMenuItem[] jMenuItemArray = new JMenuItem[]{new JMenuItem(this.buildNewProjectAction(workbenchContext))};
        return jMenuItemArray;
    }

    public ApplicationNode open(File file, WorkbenchContext workbenchContext) throws UnsupportedFileException, OpenException {
        if (!FileTools.extension((File)file).equalsIgnoreCase(".mwp")) {
            throw new UnsupportedFileException();
        }
        MWProject mWProject = null;
        Preferences preferences = workbenchContext.getApplicationContext().getPreferences().node(MAPPINGS_PREFERENCES_NODE);
        workbenchContext = this.wrap(workbenchContext);
        LocalCallback localCallback = new LocalCallback(workbenchContext);
        try {
            mWProject = this.getIOManager().read(file, preferences, FileNotFoundListener.NULL_INSTANCE, (LegacyProjectReadCallback)localCallback);
        }
        catch (CancelException cancelException) {
            throw cancelException;
        }
        catch (Throwable throwable) {
            throw new OpenException(throwable);
        }
        ApplicationNode applicationNode = this.buildProjectNode(mWProject, workbenchContext);
        if (localCallback.saveLegacyProjectNow()) {
            if (!applicationNode.saveAs(file, workbenchContext)) {
                throw new CancelException();
            }
            JOptionPane.showMessageDialog(workbenchContext.getCurrentWindow(), new LabelArea(workbenchContext.getApplicationContext().getResourceRepository().getString("LEGACY_MIGRATION_COMPLETE.MESSAGE")), workbenchContext.getApplicationContext().getResourceRepository().getString("LEGACY_MIGRATION_COMPLETE.TITLE"), 1);
        }
        return applicationNode;
    }

    public ComponentContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.wrap(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(new ToolBarButtonDescription(this.getExportDeploymentXmlAction(workbenchContext)));
        toolBarDescription.add(toolBarButtonGroupDescription);
        ToolBarButtonGroupDescription toolBarButtonGroupDescription2 = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription2.add(new ToolBarButtonDescription(this.getRefreshClassesAction(workbenchContext)));
        toolBarButtonGroupDescription2.add(new ToolBarButtonDescription(this.getAddOrRefreshClassesAction(workbenchContext)));
        toolBarButtonGroupDescription2.add(new ToolBarButtonDescription(this.getCreateNewClassAction(workbenchContext)));
        toolBarDescription.add(toolBarButtonGroupDescription2);
        return toolBarDescription;
    }

    public ComponentContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.wrap(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.buildExportMenuDescription(workbenchContext));
        rootMenuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(new MenuItemDescription(this.getRefreshClassesAction(workbenchContext)));
        menuGroupDescription2.add(new MenuItemDescription(this.getAddOrRefreshClassesAction(workbenchContext)));
        menuGroupDescription2.add(new MenuItemDescription(this.getCreateNewClassAction(workbenchContext)));
        menuGroupDescription2.add(new MenuItemDescription(this.getManageNonDescriptorClassesAction(workbenchContext)));
        rootMenuDescription.add(menuGroupDescription2);
        return rootMenuDescription;
    }

    public PreferencesNode[] buildPreferencesNodes(PreferencesContext preferencesContext) {
        return new PreferencesNode[]{new MappingsPreferencesNode((PreferencesContext)this.wrap(preferencesContext))};
    }

    public ProjectIOManager getIOManager() {
        try {
            this.synchronizedIOManager.waitUntilNotNull();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return (ProjectIOManager)this.synchronizedIOManager.getValue();
    }

    public AddOrRefreshClassesAction getAddOrRefreshClassesAction(WorkbenchContext workbenchContext) {
        return new AddOrRefreshClassesAction(workbenchContext);
    }

    public AutomapAction getAutomapAction(WorkbenchContext workbenchContext) {
        return new AutomapAction(workbenchContext);
    }

    public CreateNewClassAction getCreateNewClassAction(WorkbenchContext workbenchContext) {
        return new CreateNewClassAction(workbenchContext);
    }

    public ManageNonDescriptorClassesAction getManageNonDescriptorClassesAction(WorkbenchContext workbenchContext) {
        return new ManageNonDescriptorClassesAction(workbenchContext);
    }

    public ExportDeploymentXmlAction getExportDeploymentXmlAction(WorkbenchContext workbenchContext) {
        return new ExportDeploymentXmlAction(workbenchContext);
    }

    public ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext workbenchContext) {
        return new ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(workbenchContext);
    }

    public ExportJavaSourceAction getExportProjectJavaSourceAction(WorkbenchContext workbenchContext) {
        return new ExportJavaSourceAction(workbenchContext);
    }

    public ExportModelJavaSourceAction getExportModelJavaSourceAction(WorkbenchContext workbenchContext) {
        return new ExportModelJavaSourceAction(workbenchContext);
    }

    public ExportSpecificDescriptorModelJavaSourceAction getExportSpecificDescriptorModelJavaSourceAction(WorkbenchContext workbenchContext) {
        return new ExportSpecificDescriptorModelJavaSourceAction(workbenchContext);
    }

    public RefreshClassesAction getRefreshClassesAction(WorkbenchContext workbenchContext) {
        return new RefreshClassesAction(workbenchContext);
    }

    public RemoveAction getRemoveAction(WorkbenchContext workbenchContext) {
        return new RemoveAction(workbenchContext);
    }

    public OracleHelpAction getHelpAction(WorkbenchContext workbenchContext) {
        return new OracleHelpAction(workbenchContext);
    }

    public ExportTableCreatorJavaSourceAction getExportTableCreatorJavaSourceAction(WorkbenchContext workbenchContext) {
        return new ExportTableCreatorJavaSourceAction(workbenchContext);
    }

    public boolean isDevelopmentModeIn(WorkbenchContext workbenchContext) {
        return workbenchContext.getApplicationContext().getApplication().isDevelopmentMode();
    }

    private WorkbenchContext wrap(WorkbenchContext workbenchContext) {
        return workbenchContext.buildExpandedApplicationContextWorkbenchContext(this.wrap(workbenchContext.getApplicationContext()));
    }

    ApplicationContext wrap(ApplicationContext applicationContext) {
        ApplicationContext applicationContext2 = applicationContext.buildExpandedResourceRepositoryContext(MappingsPluginResourceBundle.class, new MappingsPluginIconResourceFileNameMap());
        applicationContext2 = applicationContext2.buildExpandedResourceRepositoryContext(ProblemsBundle.class);
        return applicationContext2.buildRedirectedPreferencesContext(MAPPINGS_PREFERENCES_NODE);
    }

    FrameworkAction buildNewProjectAction(WorkbenchContext workbenchContext) {
        return new NewProjectAction(this, workbenchContext);
    }

    ApplicationNode buildProjectNode(MWProject mWProject, WorkbenchContext workbenchContext) {
        return ProjectNode.forProject(mWProject, workbenchContext.getApplicationContext(), this);
    }

    private MenuDescription buildExportMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDescription = new MenuDescription(workbenchContext.getApplicationContext().getResourceRepository().getString("EXPORT_MENU"), null, workbenchContext.getApplicationContext().getResourceRepository().getMnemonic("EXPORT_MENU"), workbenchContext.getApplicationContext().getResourceRepository().getIcon("file.export"));
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(new MenuItemDescription(this.getExportDeploymentXmlAction(workbenchContext)));
        if (this.isDevelopmentModeIn(workbenchContext)) {
            menuGroupDescription.add(new MenuItemDescription(this.getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(workbenchContext)));
        }
        menuGroupDescription.add(new MenuItemDescription(this.getExportProjectJavaSourceAction(workbenchContext)));
        menuGroupDescription.add(new MenuItemDescription(this.getExportModelJavaSourceAction(workbenchContext)));
        menuGroupDescription.add(new MenuItemDescription(this.getExportTableCreatorJavaSourceAction(workbenchContext)));
        menuDescription.add(menuGroupDescription);
        return menuDescription;
    }

    public Component buildPropertiesPage(Class clazz) {
        return this.getPropertiesPageCacheEntry(clazz).buildPropertiesPage();
    }

    public void releasePropertiesPage(Component component) {
        this.getPropertiesPageCacheEntry(component.getClass()).releasePropertiesPage(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertiesPageCacheEntry getPropertiesPageCacheEntry(Class clazz) {
        Map map = this.propertiesPageCache;
        synchronized (map) {
            PropertiesPageCacheEntry propertiesPageCacheEntry = (PropertiesPageCacheEntry)this.propertiesPageCache.get(clazz);
            if (propertiesPageCacheEntry == null) {
                propertiesPageCacheEntry = new PropertiesPageCacheEntry(clazz, this.mwApplicationContext, (Stack)this.propertiesPageBuilderStack);
                this.propertiesPageCache.put(clazz, propertiesPageCacheEntry);
            }
            return propertiesPageCacheEntry;
        }
    }

    public static File buildExportDirectory(MWProject mWProject, String string, Preferences preferences) {
        File file = new File(string);
        if (StringTools.stringIsEmpty((String)string) || file.isAbsolute()) {
            if (!file.exists()) {
                file = mWProject.getSaveDirectory();
            }
            if (file == null) {
                file = new File(preferences.get(EXPORT_LOCATION_PREFERENCE, ""));
            }
            if (!file.exists()) {
                file = FileTools.userHomeDirectory();
            }
        } else {
            File file2 = mWProject.getSaveDirectory();
            if (file2 == null) {
                file = new File(preferences.get(EXPORT_LOCATION_PREFERENCE, ""));
                if (!file.exists()) {
                    file = FileTools.userHomeDirectory();
                }
            } else if (!(file = new File(file2, file.getPath())).exists()) {
                file = file2;
            }
        }
        return file;
    }

    private static class LocalCallback
    implements LegacyProjectReadCallback {
        private WorkbenchContext context;
        private boolean saveLegacyProjectNow;

        LocalCallback(WorkbenchContext workbenchContext) {
            this.context = workbenchContext;
            this.saveLegacyProjectNow = false;
        }

        public void checkLegacyRead(String string) {
            LegacyProjectMigrationDialog legacyProjectMigrationDialog = new LegacyProjectMigrationDialog(this.context);
            legacyProjectMigrationDialog.show();
            if (legacyProjectMigrationDialog.wasCanceled()) {
                throw new CancelException();
            }
            this.saveLegacyProjectNow = !legacyProjectMigrationDialog.saveLater();
        }

        boolean saveLegacyProjectNow() {
            return this.saveLegacyProjectNow;
        }
    }

    private class PropertiesPageBuilder
    extends Thread {
        PropertiesPageBuilder() {
            super("Properties Page Builder");
            this.setPriority(1);
        }

        public void run() {
            while (true) {
                Class clazz = null;
                try {
                    clazz = (Class)MappingsPlugin.this.propertiesPageBuilderStack.waitToPop();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.buildPropertiesPage(clazz);
            }
        }

        private void buildPropertiesPage(Class clazz) {
            try {
                MappingsPlugin.this.getPropertiesPageCacheEntry(clazz).installPropertiesPage();
            }
            catch (Throwable throwable) {
                new PropertiesPageBuilder().start();
                throw new RuntimeException(throwable);
            }
        }
    }

    private static class PropertiesPageCacheEntry {
        private final Class propertiesPageClass;
        private final WorkbenchContext workbenchContext;
        private final Stack propertiesPageBuilderStack;
        private final SynchronizedStack propertiesPages;

        PropertiesPageCacheEntry(Class clazz, ApplicationContext applicationContext, Stack stack) {
            this.propertiesPageClass = clazz;
            this.workbenchContext = this.buildWorkbenchContext(applicationContext);
            this.propertiesPageBuilderStack = stack;
            this.propertiesPages = new SynchronizedStack();
        }

        private WorkbenchContext buildWorkbenchContext(ApplicationContext applicationContext) {
            Class[] classArray = (Class[])ClassTools.getStaticFieldValue((Class)this.propertiesPageClass, (String)"REQUIRED_RESOURCE_BUNDLES");
            for (int i = 0; i < classArray.length; ++i) {
                applicationContext = applicationContext.buildExpandedResourceRepositoryContext(classArray[i]);
            }
            return new ShellWorkbenchContext(applicationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Component buildPropertiesPage() {
            SynchronizedStack synchronizedStack = this.propertiesPages;
            synchronized (synchronizedStack) {
                Component component;
                if (this.propertiesPages.isEmpty()) {
                    this.propertiesPageBuilderStack.push((Object)this.propertiesPageClass);
                }
                try {
                    component = (Component)this.propertiesPages.waitToPop();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                if (this.propertiesPages.isEmpty()) {
                    this.propertiesPageBuilderStack.push((Object)this.propertiesPageClass);
                }
                return component;
            }
        }

        void releasePropertiesPage(Component component) {
            this.propertiesPages.push((Object)component);
        }

        void installPropertiesPage() throws Throwable {
            try {
                this.propertiesPages.push(ClassTools.newInstance((Class)this.propertiesPageClass, WorkbenchContext.class, (Object)this.workbenchContext));
            }
            catch (Throwable throwable) {
                try {
                    this.propertiesPages.push((Object)new EmptyPropertiesPage(this.workbenchContext));
                }
                catch (Throwable throwable2) {
                    this.propertiesPages.push(null);
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }
}

