/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class NewClassNameDialog
extends AbstractValidatingDialog {
    private PropertyValueModel shortClassNameHolder;
    private JTextField shortClassNameTextField;
    private JComboBox packageComboBox;
    protected final Collection packageNames;
    private final String initialPackageName;
    private final String initialShortClassName;
    private boolean allowExistingType;
    private final MWProject project;

    NewClassNameDialog(MWProject mWProject, WorkbenchContext workbenchContext) {
        this(Collections.EMPTY_SET, mWProject, workbenchContext);
    }

    NewClassNameDialog(Collection collection, MWProject mWProject, WorkbenchContext workbenchContext) {
        this(collection, "", mWProject, workbenchContext);
    }

    public NewClassNameDialog(Collection collection, String string, MWProject mWProject, WorkbenchContext workbenchContext) {
        this(collection, string, NewClassNameDialog.buildInitialShortClassName(string, mWProject, workbenchContext), mWProject, workbenchContext);
    }

    public NewClassNameDialog(Collection collection, String string, String string2, MWProject mWProject, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.packageNames = collection;
        this.initialPackageName = string;
        this.initialShortClassName = string2;
        this.allowExistingType = true;
        this.project = mWProject;
    }

    private static String buildInitialShortClassName(String string, MWProject mWProject, WorkbenchContext workbenchContext) {
        return NameTools.uniqueNameFor((String)workbenchContext.getApplicationContext().getResourceRepository().getString("NEW_CLASS_NAME_DIALOG_INITIAL_CLASS_NAME"), (Iterator)NewClassNameDialog.descriptorNamesInPackage(string, mWProject));
    }

    private static Iterator descriptorNamesInPackage(String string, MWProject mWProject) {
        Iterator iterator = mWProject.descriptorsInPackage(string);
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((MWDescriptor)object).shortName();
            }
        };
    }

    protected String helpTopicId() {
        return "dialog.createNewClass";
    }

    protected void initialize() {
        super.initialize();
        this.shortClassNameHolder = new SimplePropertyValueModel("");
        this.setTitle(this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_TITLE"));
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = SwingComponentFactory.buildLabel("NEW_CLASS_NAME_DIALOG_PACKAGE_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.packageComboBox = this.buildPackageComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.packageComboBox, gridBagConstraints);
        jLabel.setLabelFor(this.packageComboBox);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("NEW_CLASS_NAME_DIALOG_CLASS_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.shortClassNameTextField = new JTextField(this.buildShortClassNameDocumentAdapter(), null, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.shortClassNameTextField, gridBagConstraints);
        jLabel2.setLabelFor(this.shortClassNameTextField);
        return jPanel;
    }

    private JComboBox buildPackageComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        JTextField jTextField = this.packageComboBoxTextField(jComboBox);
        jTextField.setDocument(new RegexpDocument(1));
        jTextField.getDocument().addDocumentListener(this.buildShortClassNameDocumentListener());
        jComboBox.setModel(new ComboBoxModelAdapter(new ReadOnlyCollectionValueModel(this.packageNames), (PropertyValueModel)new SimplePropertyValueModel(this.initialPackageName)));
        return jComboBox;
    }

    private JTextField packageComboBoxTextField() {
        return this.packageComboBoxTextField(this.packageComboBox);
    }

    private JTextField packageComboBoxTextField(JComboBox jComboBox) {
        return (JTextField)jComboBox.getEditor().getEditorComponent();
    }

    protected Component initialFocusComponent() {
        return this.shortClassNameTextField;
    }

    private Document buildShortClassNameDocumentAdapter() {
        DocumentAdapter documentAdapter = new DocumentAdapter(this.shortClassNameHolder, this.buildShortClassNameDocument());
        documentAdapter.addDocumentListener(this.buildShortClassNameDocumentListener());
        return documentAdapter;
    }

    private RegexpDocument buildShortClassNameDocument() {
        return new RegexpDocument(2);
    }

    private DocumentListener buildShortClassNameDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validateClassName();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validateClassName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validateClassName();
            }

            private void validateClassName() {
                if (NewClassNameDialog.this.isVisible()) {
                    NewClassNameDialog.this.validateClassName();
                }
            }
        };
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.shortClassNameHolder.setValue(this.initialShortClassName);
        this.shortClassNameTextField.selectAll();
        this.validateClassName();
    }

    public void setAllowExistingType(boolean bl) {
        this.allowExistingType = bl;
    }

    public String packageName() {
        String string = this.packageComboBoxTextField().getText().trim();
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String shortClassName() {
        return this.shortClassNameTextField.getText().trim();
    }

    public String className() {
        String string = this.packageName();
        String string2 = this.shortClassName();
        return string.length() == 0 ? string2 : string + '.' + string2;
    }

    void validateClassName() {
        String string;
        block2: {
            block8: {
                block9: {
                    String string2;
                    block7: {
                        String string3;
                        block6: {
                            String string4;
                            block5: {
                                block4: {
                                    block3: {
                                        block1: {
                                            string4 = this.shortClassName();
                                            string2 = this.className();
                                            string3 = string2.toLowerCase();
                                            string = null;
                                            if (string4.length() != 0) break block1;
                                            string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_NO_CLASS_NAME_SPECIFIED");
                                            break block2;
                                        }
                                        if (!NameTools.javaReservedWordsContains((String)string4)) break block3;
                                        string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_INVALID", string4);
                                        break block2;
                                    }
                                    if (!MWClassRepository.coreClassNamesContains((String)string2)) break block4;
                                    string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_RESERVED", string2);
                                    break block2;
                                }
                                String string5 = MWClassRepository.coreClassNameIgnoreCase((String)string2);
                                if (string5 == null) break block5;
                                string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_RESERVED_DIFFERENT_CASE", string5);
                                break block2;
                            }
                            if (string2.toLowerCase().equals(this.initialClassName().toLowerCase())) break block2;
                            if (!CollectionTools.contains((Iterator)this.descriptorNames(), (Object)string2) || string2.equals(this.initialClassName())) break block6;
                            string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_DESCRIPTOR_ALREADY_EXISTS", string4);
                            break block2;
                        }
                        if (!CollectionTools.contains((Iterator)this.descriptorNamesToLowerCase(), (Object)string3)) break block7;
                        string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_DESCRIPTOR_ALREADY_EXISTS_DIFFERENT_CASE");
                        break block2;
                    }
                    MWClass mWClass = this.project.getRepository().typeNamedIgnoreCase(string2);
                    if (mWClass == null) break block8;
                    if (!mWClass.getName().equals(string2)) break block9;
                    if (this.allowExistingType) break block2;
                    string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_ALREADY_EXISTS", string2);
                    break block2;
                }
                string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_ALREADY_EXISTS_DIFFERENT_CASE");
                break block2;
            }
            String[] stringArray = this.packageName().split("\\.");
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = stringArray[i];
                if (!NameTools.javaReservedWordsContains((String)string6)) continue;
                string = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_INVALID", string6);
                break;
            }
        }
        this.setErrorMessage(string);
        this.getOKAction().setEnabled(string == null);
    }

    private Iterator descriptorNames() {
        return new TransformationIterator(this.project.descriptors()){

            protected Object transform(Object object) {
                return ((MWDescriptor)object).getName();
            }
        };
    }

    private Iterator descriptorNamesToLowerCase() {
        return new TransformationIterator(this.descriptorNames()){

            protected Object transform(Object object) {
                return ((String)object).toLowerCase();
            }
        };
    }

    private String initialClassName() {
        return this.initialPackageName + '.' + this.initialShortClassName;
    }
}

