/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class ProjectCreationDialog
extends AbstractValidatingDialog {
    public static final String DATABASE_PLATFORM_PREFERENCE = "database platform";
    public static final String DATABASE_PLATFORM_PREFERENCE_DEFAULT = "Oracle11";
    private JTextField nameTextField;
    private JRadioButton relationalRadioButton;
    private JRadioButton xmlRadioButton;
    private JRadioButton eisRadioButton;
    private SimplePropertyValueModel databasePlatformHolder;
    private ComboBoxModel j2cAdapterComboBoxModel;

    ProjectCreationDialog(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("PROJECT_CREATION_DIALOG_TITLE"));
        JPanel jPanel2 = this.buildProjectNamePanel();
        this.helpManager().addTopicID(jPanel2, this.helpTopicId() + ".name");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = this.buildDataSourcePanel();
        this.helpManager().addTopicID(jPanel3, this.helpTopicId() + ".datasource");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildProjectNamePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = SwingComponentFactory.buildLabel("PROJECT_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField(35);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ProjectCreationDialog.this.updateDialog();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ProjectCreationDialog.this.updateDialog();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ProjectCreationDialog.this.updateDialog();
            }
        });
        return jPanel;
    }

    private JPanel buildDataSourcePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("DATASOURCE_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.relationalRadioButton = new JRadioButton();
        this.relationalRadioButton.setText(this.resourceRepository().getString("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setMnemonic(this.resourceRepository().getMnemonic("RELATIONAL_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.relationalRadioButton, gridBagConstraints);
        buttonGroup.add(this.relationalRadioButton);
        this.relationalRadioButton.setSelected(true);
        JPanel jPanel2 = this.buildRelationalPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.eisRadioButton = new JRadioButton();
        this.eisRadioButton.setText(this.resourceRepository().getString("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setMnemonic(this.resourceRepository().getMnemonic("EIS_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.eisRadioButton, gridBagConstraints);
        buttonGroup.add(this.eisRadioButton);
        JPanel jPanel3 = this.buildEisPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.xmlRadioButton = new JRadioButton();
        this.xmlRadioButton.setText(this.resourceRepository().getString("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setMnemonic(this.resourceRepository().getMnemonic("XML_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.xmlRadioButton, gridBagConstraints);
        buttonGroup.add(this.xmlRadioButton);
        return jPanel;
    }

    private JPanel buildRelationalPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridBagLayout());
        int n = SwingTools.checkBoxIconWidth();
        final JLabel jLabel = new JLabel(this.resourceRepository().getString("DATABASE_PLATFORM_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DATABASE_PLATFORM_LABEL"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_PLATFORM_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        accessibleTitledPanel.add((Component)jLabel, gridBagConstraints);
        String string = this.preferences().get(DATABASE_PLATFORM_PREFERENCE, DATABASE_PLATFORM_PREFERENCE_DEFAULT);
        this.databasePlatformHolder = new SimplePropertyValueModel();
        this.databasePlatformHolder.setValue(DatabasePlatformRepository.getDefault().platformNamed(string));
        final JComboBox jComboBox = PlatformComponentFactory.buildPlatformChooser(this.databasePlatformHolder);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        accessibleTitledPanel.add((Component)jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.relationalRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jComboBox.setEnabled(ProjectCreationDialog.this.relationalRadioButton.isSelected());
                jLabel.setEnabled(ProjectCreationDialog.this.relationalRadioButton.isSelected());
            }
        });
        return accessibleTitledPanel;
    }

    private JPanel buildEisPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = SwingTools.checkBoxIconWidth();
        final JLabel jLabel = new JLabel(this.resourceRepository().getString("EIS_PLATFORM_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DATABASE_PLATFORM_LABEL"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_PLATFORM_LABEL"));
        jLabel.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.j2cAdapterComboBoxModel = this.buildJ2CAdaptersComboBoxModel();
        final JComboBox jComboBox = new JComboBox(this.j2cAdapterComboBoxModel);
        String string = this.preferences().get("eis platform", MWEisLoginSpec.PLATFORM_PREFERENCE_DEFAULT);
        jComboBox.setSelectedItem(string);
        jComboBox.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.add(jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.eisRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jComboBox.setEnabled(ProjectCreationDialog.this.eisRadioButton.isSelected());
                jLabel.setEnabled(ProjectCreationDialog.this.eisRadioButton.isSelected());
            }
        });
        return jPanel;
    }

    private void updateDialog() {
        String string = this.nameTextField.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessageKey("PROJECT_CREATION_DIALOG_NO_FILE_NAME");
            this.getOKAction().setEnabled(false);
        } else if (FileTools.fileNameIsInvalid((String)string)) {
            this.setErrorMessageKey("PROJECT_CREATION_DIALOG_INVALID_FILE_NAME");
            this.getOKAction().setEnabled(false);
        } else {
            this.clearErrorMessage();
            this.getOKAction().setEnabled(true);
        }
    }

    private ComboBoxModel buildJ2CAdaptersComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.supportedJ2CAdapters()));
    }

    MWProject getProject() {
        String string = this.nameTextField.getText().trim();
        DefaultSPIManager defaultSPIManager = new DefaultSPIManager(this.preferences(), string);
        if (this.relationalRadioButton.isSelected()) {
            DatabasePlatform databasePlatform = (DatabasePlatform)this.databasePlatformHolder.getValue();
            this.preferences().put(DATABASE_PLATFORM_PREFERENCE, databasePlatform.getName());
            return new MWRelationalProject(string, (SPIManager)defaultSPIManager, databasePlatform);
        }
        if (this.xmlRadioButton.isSelected()) {
            return new MWOXProject(string, (SPIManager)defaultSPIManager);
        }
        String string2 = (String)this.j2cAdapterComboBoxModel.getSelectedItem();
        this.preferences().put("eis platform", string2);
        return new MWEisProject(string, string2, (SPIManager)defaultSPIManager);
    }

    private Iterator supportedJ2CAdapters() {
        return MWEisLoginSpec.j2CAdapterNames();
    }

    protected String helpTopicId() {
        return "dialog.projectCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

