/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorCreationFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class RefreshClassesAction
extends AbstractFrameworkAction {
    public static final String EJB_JAR_XML_EXCEPTION_ERROR = "EJB_JAR_XML_EXCEPTION_ERROR";
    public static final String EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR = "EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR";
    public static final String INVALID_DOC_TYPE_ERROR = "INVALID_DOC_TYPE_ERROR";

    RefreshClassesAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("REFRESH_CLASSES_ACTION");
        this.initializeAccelerator("REFRESH_CLASSES_ACTION.accelerator");
        this.initializeToolTipText("REFRESH_CLASSES_ACTION.toolTipText");
        this.initializeIcon("synchronize");
    }

    protected void execute() {
        this.navigatorSelectionModel().pushExpansionState();
        this.refreshDescriptors(this.selectedProjectNodes(), this.selectedNodes());
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private void refreshDescriptors(ApplicationNode[] applicationNodeArray, ApplicationNode[] applicationNodeArray2) {
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            ((MWProject)applicationNodeArray[i].getValue()).getRepository().refreshExternalClassDescriptions();
        }
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = new ExternalClassLoadFailureContainer();
        DescriptorCreationFailureContainer descriptorCreationFailureContainer = new DescriptorCreationFailureContainer();
        HashBag hashBag = new HashBag();
        for (int i = 0; i < applicationNodeArray2.length; ++i) {
            ((MappingsApplicationNode)applicationNodeArray2[i]).addDescriptorsTo((Collection)hashBag);
        }
        Iterator iterator = hashBag.uniqueIterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            if (((MWDescriptor)iterator.next()).inheritedAttributesSize() > 0) {
                bl = true;
            }
            if (!bl || !this.promptToRefreshWithInheritedAttributes(this.getWorkbenchContext())) continue;
            return;
        }
        iterator = hashBag.uniqueIterator();
        while (iterator.hasNext()) {
            ((MWDescriptor)iterator.next()).refreshClass(externalClassLoadFailureContainer, (DescriptorCreationFailureListener)descriptorCreationFailureContainer);
        }
        if (externalClassLoadFailureContainer.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), externalClassLoadFailureContainer).show();
            return;
        }
        if (descriptorCreationFailureContainer.containsFailures()) {
            new DescriptorCreationFailuresDialog(descriptorCreationFailureContainer, this.getWorkbenchContext()).show();
        }
    }

    private boolean canReadWithProblems(MWProject mWProject, LinkedHashMap linkedHashMap) {
        StatusDialog.Status status = StatusDialog.createStatus((Object)mWProject, linkedHashMap);
        CustomizedStatusDialog customizedStatusDialog = new CustomizedStatusDialog(Collections.singleton(status));
        customizedStatusDialog.setVisible(true);
        return customizedStatusDialog.wasConfirmed();
    }

    private void showResult(Collection collection) {
        StatusDialog statusDialog = new StatusDialog(this.getWorkbenchContext(), collection, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_EJB_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml"){

            protected CellRendererAdapter buildNodeRenderer(Object object) {
                if (object instanceof MWProject) {
                    return new ProjectCellRendererAdapter(this.resourceRepository());
                }
                return super.buildNodeRenderer(object);
            }
        };
        statusDialog.setVisible(true);
    }

    private boolean promptToUpdateProjectFromEjbJarXml(WorkbenchContext workbenchContext) {
        int n = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR"), this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR.title"), 0);
        return n == 0;
    }

    private boolean promptToRefreshWithInheritedAttributes(WorkbenchContext workbenchContext) {
        int n = JOptionPane.showConfirmDialog(workbenchContext.getCurrentWindow(), this.resourceRepository().getString("REFRESH_DESCRIPTORS_WITH_INHERITED_ATTRIBUTES_WARNING", StringTools.CR), this.resourceRepository().getString("REFRESH_DESCRIPTORS_WITH_INHERITED_ATTRIBUTES_TITLE"), 0, 2);
        return n == 1;
    }

    private class CustomizedStatusDialog
    extends StatusDialog {
        private CustomizedStatusDialog(Collection collection) {
            super(RefreshClassesAction.this.getWorkbenchContext(), collection, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml");
        }

        protected Action buildCancelAction() {
            AbstractAction abstractAction = (AbstractAction)super.buildCancelAction();
            abstractAction.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON"));
            abstractAction.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON")));
            return abstractAction;
        }

        protected CellRendererAdapter buildNodeRenderer(Object object) {
            if (object instanceof MWProject) {
                return new ProjectCellRendererAdapter(this.resourceRepository());
            }
            return super.buildNodeRenderer(object);
        }

        protected Action buildOKAction() {
            AbstractAction abstractAction = (AbstractAction)super.buildOKAction();
            abstractAction.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON"));
            abstractAction.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON")));
            return abstractAction;
        }

        protected boolean cancelButtonIsVisible() {
            return true;
        }
    }
}

