/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;

public final class RemoveAction
extends AbstractFrameworkAction {
    public RemoveAction(WorkbenchContext workbenchContext) {
        this(workbenchContext, "remove");
    }

    public RemoveAction(WorkbenchContext workbenchContext, String string) {
        super(workbenchContext);
        this.initializeIcon(string);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("REMOVE_ACTION");
        this.initializeToolTipText("REMOVE_ACTION.toolTipText");
    }

    protected void execute() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        if (applicationNodeArray.length == 1 ? !this.confirmSingleItemRemoval((RemovableNode)((Object)applicationNodeArray[0])) : !this.confirmMultipleItemRemoval()) {
            return;
        }
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            ((RemovableNode)((Object)applicationNodeArray[i])).remove();
        }
    }

    protected boolean confirmSingleItemRemoval(RemovableNode removableNode) {
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CONFIRM_REMOVE.message", removableNode.getName()), this.resourceRepository().getString("CONFIRM_REMOVE.title"), 0);
        return n == 0;
    }

    protected boolean confirmMultipleItemRemoval() {
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CONFIRM_MULTIPLE_REMOVE.message"), this.resourceRepository().getString("CONFIRM_REMOVE.title"), 0);
        return n == 0;
    }
}

