/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.BasicDescriptorClassCodeGenPolicy;

public final class SourceCodeGenerator {
    private ApplicationContext context;
    private MWProject project;
    private Collection descriptors;
    private File sourceRootDirectory;
    private boolean overwriteFiles;
    private boolean continueGenerating;
    private boolean anyFileWritten;
    private Collection fileAlreadyExistsListeners;
    private Collection continuableExceptionListeners;

    public SourceCodeGenerator(ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.fileAlreadyExistsListeners = new Vector();
        this.continuableExceptionListeners = new Vector();
        this.continueGenerating = true;
    }

    private ApplicationContext getApplicationContext() {
        return this.context;
    }

    public boolean shouldOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean bl) {
        this.overwriteFiles = bl;
    }

    public void generateSourceCode(MWProject mWProject, Collection collection) {
        this.generateSourceCode(mWProject, collection, null);
    }

    public void generateSourceCode(MWProject mWProject, Collection collection, File file) {
        this.project = mWProject;
        this.descriptors = collection;
        this.sourceRootDirectory = file;
        if (!this.overwriteFiles) {
            this.checkForExistingFiles();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.generateSourceCode((MWDescriptor)iterator.next());
        }
    }

    private void generateSourceCode(MWDescriptor mWDescriptor) {
        this.writeClassDefinition(new BasicDescriptorClassCodeGenPolicy(mWDescriptor, this.getApplicationContext()).classDefinition());
    }

    public void checkForExistingFiles() {
        MWDescriptor mWDescriptor;
        File file = null;
        Iterator iterator = this.descriptors.iterator();
        while (iterator.hasNext() && (file = this.doesFileExist(mWDescriptor = (MWDescriptor)iterator.next())) == null) {
        }
        if (file != null) {
            this.fireFileAlreadyExistsEvent(file);
        }
    }

    private File doesFileExist(MWDescriptor mWDescriptor) {
        return this.doesFileExist(new BasicDescriptorClassCodeGenPolicy(mWDescriptor, this.getApplicationContext()).classDefinition());
    }

    private File doesFileExist(ClassDefinition classDefinition) {
        String string;
        File file;
        if (!this.continueGenerating) {
            return null;
        }
        if (classDefinition == null) {
            return null;
        }
        File file2 = this.sourceRootDirectory;
        if (file2 == null) {
            file2 = this.project.absoluteModelSourceDirectory();
        }
        if ((file = new File(string = this.buildDirectory(classDefinition.getPackageName(), file2), classDefinition.getName() + ".java")).exists()) {
            return file;
        }
        return null;
    }

    public void writeClassDefinition(ClassDefinition classDefinition) {
        if (!this.continueGenerating) {
            return;
        }
        if (classDefinition == null) {
            return;
        }
        File file = this.sourceRootDirectory;
        if (file == null) {
            file = this.project.absoluteModelSourceDirectory();
        }
        String string = this.buildDirectory(classDefinition.getPackageName(), file);
        File file2 = new File(string, classDefinition.getName() + ".java");
        CodeGenerator codeGenerator = new CodeGenerator();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            codeGenerator.setOutput((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8"));
        }
        catch (IOException iOException) {
            this.fireContinuableExceptionEvent(iOException);
            return;
        }
        classDefinition.write(codeGenerator);
        this.anyFileWritten = true;
        try {
            codeGenerator.getOutput().flush();
            codeGenerator.getOutput().close();
        }
        catch (IOException iOException) {
            this.fireContinuableExceptionEvent(iOException);
            return;
        }
    }

    public void removeFileAlreadyExistsListener(FileAlreadyExistsListener fileAlreadyExistsListener) {
        this.fileAlreadyExistsListeners.remove(fileAlreadyExistsListener);
    }

    private String buildDirectory(String string, File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        File file2 = file;
        file2.mkdir();
        while (stringTokenizer.hasMoreTokens()) {
            file2 = new File(file2.getPath() + File.separator + stringTokenizer.nextToken());
            file2.mkdir();
        }
        return file2.getPath();
    }

    public void addContinuableExceptionListener(ContinuableExceptionListener continuableExceptionListener) {
        this.continuableExceptionListeners.add(continuableExceptionListener);
    }

    private void fireContinuableExceptionEvent(Exception exception) {
        Iterator iterator = this.continuableExceptionListeners.iterator();
        while (iterator.hasNext()) {
            this.continueGenerating &= ((ContinuableExceptionListener)iterator.next()).continueOnException(new ContinuableExceptionEvent(this, exception));
        }
    }

    public void addFileAlreadyExistsListener(FileAlreadyExistsListener fileAlreadyExistsListener) {
        this.fileAlreadyExistsListeners.add(fileAlreadyExistsListener);
    }

    private void fireFileAlreadyExistsEvent(File file) {
        Iterator iterator = this.fileAlreadyExistsListeners.iterator();
        while (iterator.hasNext()) {
            this.continueGenerating &= ((FileAlreadyExistsListener)iterator.next()).fileAlreadyExists(this.project, new FileAlreadyExistsEvent(this, file));
        }
    }

    public boolean isAnyFileWritten() {
        return this.anyFileWritten;
    }

    public static interface FileAlreadyExistsListener
    extends EventListener {
        public boolean fileAlreadyExists(MWProject var1, FileAlreadyExistsEvent var2);
    }

    public class FileAlreadyExistsEvent
    extends EventObject {
        private File file;

        protected FileAlreadyExistsEvent(Object object, File file) {
            super(object);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static interface ContinuableExceptionListener
    extends EventListener {
        public boolean continueOnException(ContinuableExceptionEvent var1);
    }

    public class ContinuableExceptionEvent
    extends EventObject {
        private Exception exception;

        protected ContinuableExceptionEvent(Object object, Exception exception) {
            super(object);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

