/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class StatusDialog
extends AbstractDialog {
    private final String helpTopicId;
    private final String messageKey;
    private final Collection status;
    JTree tree;

    public StatusDialog(WorkbenchContext workbenchContext, Collection collection, String string) {
        this(workbenchContext, collection, string, "dialog.status");
    }

    public StatusDialog(WorkbenchContext workbenchContext, Dialog dialog, Collection collection, String string) {
        this(workbenchContext, dialog, collection, string, "dialog.status");
    }

    public StatusDialog(WorkbenchContext workbenchContext, Collection collection, String string, String string2) {
        this(workbenchContext, collection, string, "STATUS_DIALOG_MESSAGE", string2);
    }

    public StatusDialog(WorkbenchContext workbenchContext, Dialog dialog, Collection collection, String string, String string2) {
        this(workbenchContext, dialog, collection, string, "STATUS_DIALOG_MESSAGE", string2);
    }

    public StatusDialog(WorkbenchContext workbenchContext, Collection collection, String string, String string2, String string3) {
        super(workbenchContext);
        if (collection == null) {
            throw new NullPointerException("The collection of status cannot be null");
        }
        this.status = collection;
        this.messageKey = string2;
        this.helpTopicId = string3;
        this.setTitle(this.resourceRepository().getString(string));
    }

    public StatusDialog(WorkbenchContext workbenchContext, Dialog dialog, Collection collection, String string, String string2, String string3) {
        super(workbenchContext, dialog);
        if (collection == null) {
            throw new NullPointerException("The collection of status cannot be null");
        }
        this.status = collection;
        this.messageKey = string2;
        this.helpTopicId = string3;
        this.setTitle(this.resourceRepository().getString(string));
    }

    public static Status createStatus(Object object, List list) {
        return StatusDialog.createStatus(object, list, Collections.EMPTY_LIST);
    }

    public static Status createStatus(Object object, List list, List list2) {
        return new LocalStatus(object, list, list2);
    }

    public static Status createStatus(Object object, Map map) {
        return StatusDialog.createStatus(object, new Vector(map.keySet()));
    }

    public static Status createStatus(Object object, Map map, List list) {
        return StatusDialog.createStatus(object, new Vector(map.keySet()), list);
    }

    private ComponentListener buildComponentListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                StatusDialog.this.updateTree();
            }
        };
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString(this.messageKey));
        labelArea.getAccessibleContext().setAccessibleName(labelArea.getText());
        labelArea.setScrollable(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)labelArea, gridBagConstraints);
        this.tree = new StatusTree();
        this.tree.setRowHeight(0);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setDoubleBuffered(true);
        this.tree.setCellRenderer(new StatusTreeNodeRenderer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.addComponentListener(this.buildComponentListener());
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        labelArea.setLabelFor(this.tree);
        return jPanel;
    }

    protected CellRendererAdapter buildNodeRenderer(Object object) {
        if (object instanceof Node) {
            return CellRendererAdapter.NODE_CELL_RENDERER_ADAPTER;
        }
        if (object instanceof Displayable) {
            return CellRendererAdapter.DISPLAYABLE_CELL_RENDERER_ADAPTER;
        }
        if (object instanceof MWError) {
            return new MWErrorCellRendererAdapter();
        }
        return CellRendererAdapter.DEFAULT_CELL_RENDERER_ADAPTER;
    }

    private void buildTreeContent() {
        MutableTreeNode mutableTreeNode = this.rootNode();
        Iterator iterator = this.status.iterator();
        while (iterator.hasNext()) {
            this.buildTreeNode(mutableTreeNode, (Status)iterator.next());
        }
    }

    private void buildTreeNode(MutableTreeNode mutableTreeNode, Status status) {
        StatusTreeNode statusTreeNode = this.buildTreeNode(status.getItem(), false);
        mutableTreeNode.insert(statusTreeNode, mutableTreeNode.getChildCount());
        Iterator iterator = status.status();
        while (iterator.hasNext()) {
            StatusTreeNode statusTreeNode2 = this.buildTreeNode(iterator.next(), true);
            statusTreeNode.insert(statusTreeNode2, statusTreeNode.getChildCount());
        }
        iterator = status.children();
        while (iterator.hasNext()) {
            this.buildTreeNode(statusTreeNode, (Status)iterator.next());
        }
    }

    private StatusTreeNode buildTreeNode(Object object, boolean bl) {
        return new StatusTreeNode(object, this.buildNodeRenderer(object));
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    private void expandAll(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode.isLeaf()) {
            return;
        }
        this.expandPath(mutableTreeNode);
        Enumeration<? extends TreeNode> enumeration = mutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)enumeration.nextElement();
            this.expandAll(mutableTreeNode2);
        }
    }

    private void expandPath(MutableTreeNode mutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        Object[] objectArray = defaultTreeModel.getPathToRoot(mutableTreeNode);
        this.tree.expandPath(new TreePath(objectArray));
    }

    protected String helpTopicId() {
        return this.helpTopicId;
    }

    protected void initialize(WorkbenchContext workbenchContext) {
        super.initialize(workbenchContext.buildExpandedResourceRepositoryContext(UiCommonBundle.class));
    }

    protected void prepareToShow() {
        this.setSize(455, 230);
        this.setLocationRelativeTo(this.getParent());
        this.buildTreeContent();
        this.updateTree();
    }

    void updateTree() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.expandAll(this.rootNode());
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected final MutableTreeNode rootNode() {
        return (MutableTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
    }

    private class StatusTreeNodeRenderer
    extends SimpleTreeCellRenderer {
        private StatusTreeNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            return defaultMutableTreeNode.isRoot() ? this : super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        protected String buildAccessibleName(Object object) {
            return ((StatusTreeNode)object).buildAccessibleName();
        }

        protected Icon buildIcon(Object object) {
            return ((StatusTreeNode)object).buildIcon();
        }

        protected String buildText(Object object) {
            return ((StatusTreeNode)object).buildText();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusNode();
            }
            return this.accessibleContext;
        }

        protected class AccessibleStatusNode
        extends JLabel.AccessibleJLabel {
            protected AccessibleStatusNode() {
                super(StatusTreeNodeRenderer.this);
            }

            public String getAccessibleName() {
                return super.getAccessibleName();
            }
        }
    }

    private class StatusTreeNode
    extends DefaultMutableTreeNode {
        private final CellRendererAdapter renderer;

        private StatusTreeNode(Object object, CellRendererAdapter cellRendererAdapter) {
            super(object);
            this.renderer = cellRendererAdapter;
        }

        public String buildAccessibleName() {
            return this.renderer.buildAccessibleName(this.getUserObject());
        }

        public Icon buildIcon() {
            return this.renderer.buildIcon(this.getUserObject());
        }

        public String buildText() {
            return this.renderer.buildText(this.getUserObject());
        }
    }

    private class StatusTree
    extends SwingComponentFactory.AccessibleTree {
        private StatusTree() {
            super(new DefaultTreeModel(new DefaultMutableTreeNode("")));
        }

        public void collapsePath(TreePath treePath) {
        }

        public void collapseRow(int n) {
        }

        protected void setExpandedState(TreePath treePath, boolean bl) {
            if (bl) {
                super.setExpandedState(treePath, bl);
            }
        }
    }

    private static class LocalStatus
    implements Status {
        private final List children;
        private final Object item;
        private final List status;

        public LocalStatus(Object object, List list, List list2) {
            this.item = object;
            this.status = list;
            this.children = list2;
        }

        public Iterator children() {
            return this.children.iterator();
        }

        public Object getItem() {
            return this.item;
        }

        public Iterator status() {
            return this.status.iterator();
        }
    }

    protected class MWErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected MWErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object object) {
            MWError mWError = (MWError)object;
            String string = mWError.getErrorId();
            if (string.endsWith("SUCCESSFUL")) {
                return StatusDialog.this.resourceRepository().getIcon("approve");
            }
            if (string.endsWith("ERROR")) {
                return StatusDialog.this.resourceRepository().getIcon("error");
            }
            return StatusDialog.this.resourceRepository().getIcon("warning");
        }

        public String buildText(Object object) {
            MWError mWError = (MWError)object;
            return StatusDialog.this.resourceRepository().getString(mWError.getErrorId(), mWError.getArguments());
        }
    }

    public static interface Status {
        public Iterator children();

        public Object getItem();

        public Iterator status();
    }
}

