/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ColumnPairsPanel
extends AbstractPanel {
    private PropertyValueModel referenceHolder;
    private ListValueModel sourceColumnsHolder;
    private ListValueModel targetColumnsHolder;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedColumnPairHolder;
    private CollectionValueModel sortedColumnPairsAdapter;
    private Collection componentsForEnablement;
    private Action removeAction;
    private JTable table;

    public ColumnPairsPanel(WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel propertyValueModel) {
        this.referenceHolder = propertyValueModel;
        this.componentsForEnablement = new Vector();
        this.sourceColumnsHolder = this.buildSortedColumnsHolder(this.buildSourceTableHolder());
        this.targetColumnsHolder = this.buildSortedColumnsHolder(this.buildTargetTableHolder());
        this.sortedColumnPairsAdapter = this.buildColumnPairsAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedColumnPairHolder = this.buildSelectedColumnPairHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildSortedColumnsHolder(PropertyValueModel propertyValueModel) {
        return new SortedListValueModelAdapter(this.buildColumnsAdapter(propertyValueModel));
    }

    private CollectionValueModel buildColumnsAdapter(PropertyValueModel propertyValueModel) {
        return new CollectionAspectAdapter(propertyValueModel, "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private PropertyValueModel buildSourceTableHolder() {
        return new PropertyAspectAdapter(this.referenceHolder){

            protected Object getValueFromSubject() {
                return ((MWReference)this.subject).getSourceTable();
            }
        };
    }

    private PropertyValueModel buildTargetTableHolder() {
        return new PropertyAspectAdapter(this.referenceHolder, "targetTable"){

            protected Object getValueFromSubject() {
                return ((MWReference)this.subject).getTargetTable();
            }
        };
    }

    private CollectionValueModel buildColumnPairsAdapter() {
        return new CollectionAspectAdapter(this.referenceHolder, "columnPairs"){

            protected Iterator getValueFromSubject() {
                return ((MWReference)this.subject).columnPairs();
            }

            protected int sizeFromSubject() {
                return ((MWReference)this.subject).columnPairsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedColumnPairsAdapter, this.buildColumnAdapter());
    }

    protected ColumnAdapter buildColumnAdapter() {
        return new ColumnPairsColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedColumnPairHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedColumnPairsAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        objectListSelectionModel.setSelectionMode(0);
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ColumnPairsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object object = this.rowSelectionModel.getSelectedValue();
        this.selectedColumnPairHolder.setValue(object);
        boolean bl = object != null;
        this.removeAction.setEnabled(bl);
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.buildButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.table = this.buildTable();
        this.componentsForEnablement.add(this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        SwingComponentFactory.attachTableEditorCanceler(jTable, this.referenceHolder);
        jTable.getTableHeader().setReorderingAllowed(false);
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildSourceColumnComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildSourceColumnComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer2 = this.buildTargetColumnComboBoxRenderer();
        tableColumn2.setCellRenderer(comboBoxTableCellRenderer2);
        tableColumn2.setCellEditor(new TableCellEditorAdapter(this.buildTargetColumnComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer2.getPreferredHeight());
        jTable.setRowHeight(n);
        return jTable;
    }

    private ListCellRenderer buildColumnListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? "" : ((MWColumn)object).getName();
            }
        };
    }

    private ComboBoxTableCellRenderer buildSourceColumnComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildSourceColumnComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private ComboBoxModel buildSourceColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.sourceColumnsHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ComboBoxTableCellRenderer buildTargetColumnComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildTargetColumnComboBoxModel(), this.buildColumnListCellRenderer());
    }

    private ComboBoxModel buildTargetColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.targetColumnsHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        JButton jButton = this.buildAddButton();
        this.componentsForEnablement.add(jButton);
        jPanel.add(jButton);
        this.addAlignRight(jButton);
        JButton jButton2 = this.buildRemoveButton();
        this.componentsForEnablement.add(jButton2);
        jPanel.add(jButton2);
        this.addAlignRight(jButton2);
        return jPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("ADD_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnPairsPanel.this.addColumnPair();
            }
        };
        abstractFrameworkAction.setEnabled(false);
        this.referenceHolder.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                abstractFrameworkAction.setEnabled(ColumnPairsPanel.this.selectedReference() != null);
            }
        });
        return abstractFrameworkAction;
    }

    private void addColumnPair() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (this.selectedReference().getSourceTable().columnsSize() == 0 || this.selectedReference().getTargetTable().columnsSize() == 0) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("TABLE_HAS_NO_FIELDS.message"), this.resourceRepository().getString("TABLE_HAS_NO_FIELDS.title"), 2);
            return;
        }
        this.selectedReference().addColumnPair((MWColumn)this.selectedReference().getSourceTable().columns().next(), (MWColumn)this.selectedReference().getTargetTable().columns().next());
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnPairsPanel.this.removeColumnPair();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeColumnPair() {
        MWColumnPair mWColumnPair;
        int n;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.title"), 0, 3)) == 0 && (mWColumnPair = this.selectedColumnPair()) != null) {
            this.selectedReference().removeColumnPair(mWColumnPair);
        }
    }

    private MWColumnPair selectedColumnPair() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWColumnPair)this.rowSelectionModel.getSelectedValue();
    }

    private MWReference selectedReference() {
        return (MWReference)this.referenceHolder.getValue();
    }

    public Collection getComponentsForEnablement() {
        return this.componentsForEnablement;
    }

    public static class ColumnPairsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int SOURCE_FIELD_COLUMN = 0;
        public static final int TARGET_FIELD_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"SOURCE_COLUMN_COLUMN_HEADER", "TARGET_COLUMN_COLUMN_HEADER"};

        protected ColumnPairsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return true;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWColumnPair mWColumnPair = (MWColumnPair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildSourceColumnAdapter(mWColumnPair), this.buildTargetColumnAdapter(mWColumnPair)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildSourceColumnAdapter(MWColumnPair mWColumnPair) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("sourceColumn", (Model)mWColumnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getSourceColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnPair)this.subject).setSourceColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildTargetColumnAdapter(MWColumnPair mWColumnPair) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("targetColumn", (Model)mWColumnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getTargetColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnPair)this.subject).setTargetColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }
    }
}

