/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SpinnerTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class ColumnsPropertiesPage
extends ScrollablePropertiesPage {
    private ListValueModel databaseTypesHolder;
    private ListValueModel sortedColumnsAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedColumnHolder;
    private Action removeAction;
    private Action renameAction;
    private JTable table;

    public ColumnsPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.databaseTypesHolder = this.buildDatabaseTypesListHolder();
        this.sortedColumnsAdapter = this.buildSortedColumnsAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedColumnHolder = this.buildSelectedColumnHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ListValueModel buildDatabaseTypesListHolder() {
        return new CollectionListValueModelAdapter(this.buildDatabaseTypesHolder());
    }

    private CollectionValueModel buildDatabaseTypesHolder() {
        return new CollectionAspectAdapter(this.buildDatabasePlatformAdapter(), "databaseTypes"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypes();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypesSize();
            }
        };
    }

    private PropertyValueModel buildDatabasePlatformAdapter() {
        return new PropertyAspectAdapter(this.buildDatabaseAdapter(), "databasePlatform"){

            protected Object getValueFromSubject() {
                return ((MWDatabase)this.subject).getDatabasePlatform();
            }
        };
    }

    private ValueModel buildDatabaseAdapter() {
        return new TransformationPropertyValueModel(this.getSelectionHolder()){

            protected Object transform(Object object) {
                return object == null ? null : ((MWTable)object).getDatabase();
            }

            protected Object reverseTransform(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ListValueModel buildSortedColumnsAdapter() {
        return new SortedListValueModelAdapter(this.buildColumnNameAdapter());
    }

    private ListValueModel buildColumnNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnsAdapter(), "name");
    }

    private CollectionValueModel buildColumnsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedColumnsAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ColumnsColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedColumnHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedColumnsAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ColumnsPropertiesPage.this.rowSelectionChanged(listSelectionEvent);
                }
            }
        };
    }

    void rowSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = this.rowSelectionModel.getSelectedValue();
        this.selectedColumnHolder.setValue(object);
        boolean bl = object != null;
        this.removeAction.setEnabled(bl);
        this.renameAction.setEnabled(bl);
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.table = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        jTable.setAutoResizeMode(0);
        jTable.getTableHeader().setReorderingAllowed(false);
        SwingComponentFactory.attachTableEditorCanceler(jTable, this.getSelectionHolder());
        this.updateTableColumns(jTable);
        return jTable;
    }

    private void updateTableColumns(JTable jTable) {
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildDatabaseTypeComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildDatabaseTypeComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(2);
        SpinnerTableCellRenderer spinnerTableCellRenderer = this.buildSizeRenderer();
        tableColumn.setCellRenderer(spinnerTableCellRenderer);
        tableColumn.setCellEditor(this.buildSizeEditor());
        n = Math.max(n, spinnerTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(3);
        SpinnerTableCellRenderer spinnerTableCellRenderer2 = this.buildSubSizeRenderer();
        tableColumn.setCellRenderer(spinnerTableCellRenderer2);
        tableColumn.setCellEditor(this.buildSubSizeEditor());
        n = Math.max(n, spinnerTableCellRenderer2.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(4);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = this.buildAllowsNullRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer);
        tableColumn.setCellEditor(this.buildAllowsNullEditor());
        n = Math.max(n, checkBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(5);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer2 = new CheckBoxTableCellRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer2);
        tableColumn.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        n = Math.max(n, checkBoxTableCellRenderer2.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(6);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer3 = new CheckBoxTableCellRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer3);
        tableColumn.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        n = Math.max(n, checkBoxTableCellRenderer3.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(7);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer4 = this.buildIdentityRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer4);
        tableColumn.setCellEditor(this.buildIdentityEditor());
        n = Math.max(n, checkBoxTableCellRenderer4.getPreferredHeight());
        jTable.setRowHeight(n);
    }

    private SpinnerTableCellRenderer buildNumberSpinnerRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0)));
    }

    private SpinnerTableCellRenderer buildSizeRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0))){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsSize()) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildSizeEditor() {
        return new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsSize()) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                return null;
            }
        };
    }

    private SpinnerTableCellRenderer buildSubSizeRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0))){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsSubSize()) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildSubSizeEditor() {
        return new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsSubSize()) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                return null;
            }
        };
    }

    private CheckBoxTableCellRenderer buildAllowsNullRenderer() {
        return new CheckBoxTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsNull()) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildAllowsNullEditor() {
        return new TableCellEditorAdapter(new CheckBoxTableCellRenderer()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).getDatabaseType().allowsNull()) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                return null;
            }
        };
    }

    private CheckBoxTableCellRenderer buildIdentityRenderer() {
        return new CheckBoxTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).supportsIdentityClause()) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildIdentityEditor() {
        return new TableCellEditorAdapter(new CheckBoxTableCellRenderer()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (ColumnsPropertiesPage.this.column(n).supportsIdentityClause()) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                return null;
            }
        };
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.add(this.buildAddButton());
        jPanel.add(this.buildRemoveButton());
        jPanel.add(this.buildRenameButton());
        return jPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("ADD_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnsPropertiesPage.this.addColumn();
            }
        };
        abstractFrameworkAction.setEnabled(true);
        return abstractFrameworkAction;
    }

    void addColumn() {
        String string;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((string = this.promptUserForColumnName()) != null) {
            this.setSelectedColumn(this.table().addColumn(string));
        }
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnsPropertiesPage.this.removeColumn();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    void removeColumn() {
        int n;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((n = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("removeField.message"), this.resourceRepository().getString("removeField.title"), 0, 3)) == 0) {
            this.table().removeColumns(this.selectedColumns());
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        this.renameAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("RENAME_DATABASE_FIELD_BUTTON_TEXT");
                this.initializeMnemonic("RENAME_DATABASE_FIELD_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnsPropertiesPage.this.renameColumn();
            }
        };
        this.renameAction.setEnabled(false);
        return this.renameAction;
    }

    void renameColumn() {
        Iterator iterator = this.selectedColumns();
        while (iterator.hasNext()) {
            MWColumn mWColumn = (MWColumn)iterator.next();
            String string = this.promptUserForColumnName(mWColumn.getName(), "RENAME_FIELD_DIALOG", "dialog.dbFieldRename");
            if (string == null) continue;
            mWColumn.setName(string);
            this.setSelectedColumn(mWColumn);
        }
    }

    private String promptUserForColumnName() {
        String string = NameTools.uniqueNameFor((String)this.resourceRepository().getString("NEW_FIELD_DEFAULT_NAME"), (Iterator)this.columnNames());
        return this.promptUserForColumnName(string, "ADD_NEW_FIELD_DIALOG", "dialog.dbFieldAdd");
    }

    private String promptUserForColumnName(String string, String string2, String string3) {
        NewNameDialog newNameDialog = this.buildNewNameDialog(string, string2, string3);
        newNameDialog.show();
        return newNameDialog.wasConfirmed() ? newNameDialog.getNewName() : null;
    }

    protected String helpTopicId() {
        return "table.columns";
    }

    private NewNameDialog buildNewNameDialog(String string, String string2, String string3) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.columnNames());
        builder.setOriginalName(string);
        builder.setTextFieldDescription(this.resourceRepository().getString(string2 + ".message"));
        builder.setTitle(this.resourceRepository().getString(string2 + ".title"));
        builder.setHelpTopicId(string3);
        return builder.buildDialog(this.getWorkbenchContext());
    }

    private Iterator columnNames() {
        return new TransformationIterator(this.table().columns()){

            protected Object transform(Object object) {
                return ((MWColumn)object).getName();
            }
        };
    }

    private ComboBoxTableCellRenderer buildDatabaseTypeComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildDatabaseTypeComboBoxModel(), this.buildDatabaseTypeListCellRenderer());
    }

    private ComboBoxModel buildDatabaseTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.databaseTypesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildDatabaseTypeListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((DatabaseType)object).getName();
            }
        };
    }

    private Iterator selectedColumns() {
        return CollectionTools.iterator((Object[])this.rowSelectionModel.getSelectedValues());
    }

    void setSelectedColumn(MWColumn mWColumn) {
        this.rowSelectionModel.setSelectedValue(mWColumn);
    }

    MWColumn column(int n) {
        return (MWColumn)this.sortedColumnsAdapter.getItem(n);
    }

    private MWTable table() {
        return (MWTable)this.getSelectionHolder().getValue();
    }

    public static class ColumnsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 8;
        public static final int NAME_COLUMN = 0;
        public static final int TYPE_COLUMN = 1;
        public static final int SIZE_COLUMN = 2;
        public static final int SUB_SIZE_COLUMN = 3;
        public static final int ALLOWS_NULL_COLUMN = 4;
        public static final int UNIQUE_COLUMN = 5;
        public static final int PRIMARY_KEY_COLUMN = 6;
        public static final int IDENTITY_COLUMN = 7;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"NAME_COLUMN_HEADER", "TYPE_COLUMN_HEADER", "SIZE_COLUMN_HEADER", "SUB_SIZE_COLUMN_HEADER", "ALLOWS_NULL_COLUMN_HEADER", "UNIQUE_COLUMN_HEADER", "PRIMARY_KEY_COLUMN_HEADER", "IDENTITY_COLUMN_HEADER"};

        protected ColumnsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Integer.class;
                }
                case 4: {
                    return Boolean.class;
                }
                case 6: {
                    return Boolean.class;
                }
                case 5: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n != 0;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWColumn mWColumn = (MWColumn)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[8];
            propertyValueModelArray[0] = this.buildNameAdapter(mWColumn);
            propertyValueModelArray[1] = this.buildTypeAdapter(mWColumn);
            propertyValueModelArray[2] = this.buildSizeAdapter(mWColumn);
            propertyValueModelArray[3] = this.buildSubSizeAdapter(mWColumn);
            propertyValueModelArray[4] = this.buildAllowsNullAdapter(mWColumn);
            propertyValueModelArray[6] = this.buildPrimaryKeyAdapter(mWColumn);
            propertyValueModelArray[7] = this.buildIdentityAdapter(mWColumn);
            propertyValueModelArray[5] = this.buildUniqueAdapter(mWColumn);
            return propertyValueModelArray;
        }

        private PropertyValueModel buildNameAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("name", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).getName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setName((String)object);
                }
            };
        }

        private PropertyValueModel buildTypeAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("databaseType", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).getDatabaseType();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setDatabaseType((DatabaseType)object);
                }
            };
        }

        private PropertyValueModel buildSizeAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("size", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return new Integer(((MWColumn)this.subject).getSize());
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setSize(((Integer)object).intValue());
                }
            };
        }

        private PropertyValueModel buildSubSizeAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("subSize", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return new Integer(((MWColumn)this.subject).getSubSize());
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setSubSize(((Integer)object).intValue());
                }
            };
        }

        private PropertyValueModel buildAllowsNullAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("allowsNull", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).allowsNull();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setAllowsNull(((Boolean)object).booleanValue());
                }
            };
        }

        private PropertyValueModel buildPrimaryKeyAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("primaryKey", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isPrimaryKey();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setPrimaryKey(((Boolean)object).booleanValue());
                }
            };
        }

        private PropertyValueModel buildIdentityAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("identity", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isIdentity();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setIdentity(((Boolean)object).booleanValue());
                }
            };
        }

        private PropertyValueModel buildUniqueAdapter(MWColumn mWColumn) {
            return new PropertyAspectAdapter("unique", (Model)mWColumn){

                protected Object getValueFromSubject() {
                    return ((MWColumn)this.subject).isUnique();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumn)this.subject).setUnique(((Boolean)object).booleanValue());
                }
            };
        }
    }
}

