/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.AddNewTableAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.AddOrRefreshTablesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabasePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.LogInAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.LogOutAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class DatabaseNode
extends MappingsApplicationNode
implements ProjectNode.Child {
    private ListValueModel childrenModel;
    protected static final String[] DATABASE_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"databasePlatform"};
    protected static final String[] DATABASE_ICON_PROPERTY_NAMES = new String[]{"hasBranchProblems", "connected"};

    public DatabaseNode(MWDatabase mWDatabase, RelationalProjectNode relationalProjectNode, MappingsPlugin mappingsPlugin, ApplicationContext applicationContext) {
        super((MWModel)mWDatabase, (TreeNodeValueModel)relationalProjectNode, (Plugin)mappingsPlugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildDatabaseNodeAdapter(), "displayString");
    }

    protected ListValueModel buildDatabaseNodeAdapter() {
        return new TransformationListValueModelAdapter(this.buildTablesAspectAdapter()){

            protected Object transformItem(Object object) {
                return new TableNode((MWTable)object, DatabaseNode.this);
            }
        };
    }

    protected CollectionValueModel buildTablesAspectAdapter() {
        return new CollectionAspectAdapter(this, "tables"){

            protected Iterator getValueFromSubject() {
                return ((MWDatabase)this.subject).tables();
            }

            protected int sizeFromSubject() {
                return ((MWDatabase)this.subject).tablesSize();
            }
        };
    }

    public int getProjectNodeChildPriority() {
        return 1;
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    public String helpTopicID() {
        return "database";
    }

    public String buildIconKey() {
        return this.getDatabase().isConnected() ? "database.connected" : "database";
    }

    private FrameworkAction getAddNewTableAction(WorkbenchContext workbenchContext) {
        return new AddNewTableAction(workbenchContext);
    }

    private FrameworkAction getAddOrRefreshTablesAction(WorkbenchContext workbenchContext) {
        return new AddOrRefreshTablesAction(workbenchContext);
    }

    private FrameworkAction getDatabaseLogInAction(WorkbenchContext workbenchContext) {
        return new LogInAction(workbenchContext);
    }

    private FrameworkAction getDatabaseLogOutAction(WorkbenchContext workbenchContext) {
        return new LogOutAction(workbenchContext);
    }

    protected String[] displayStringPropertyNames() {
        return DATABASE_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected String[] iconPropertyNames() {
        return DATABASE_ICON_PROPERTY_NAMES;
    }

    protected Class propertiesPageClass() {
        return DatabasePropertiesPage.class;
    }

    public MWDatabase getDatabase() {
        return (MWDatabase)this.getValue();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getDatabaseLogInAction(workbenchContext2));
        menuGroupDescription.add(this.getDatabaseLogOutAction(workbenchContext2));
        rootMenuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(this.getAddNewTableAction(workbenchContext2));
        menuGroupDescription2.add(this.getAddOrRefreshTablesAction(workbenchContext2));
        rootMenuDescription.add(menuGroupDescription2);
        rootMenuDescription.add(this.buildOracleHelpMenuGroup(workbenchContext2));
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription.add(this.getDatabaseLogInAction(workbenchContext2));
        toolBarButtonGroupDescription.add(this.getDatabaseLogOutAction(workbenchContext2));
        toolBarDescription.add(toolBarButtonGroupDescription);
        ToolBarButtonGroupDescription toolBarButtonGroupDescription2 = new ToolBarButtonGroupDescription();
        toolBarButtonGroupDescription2.add(this.getAddNewTableAction(workbenchContext2));
        toolBarButtonGroupDescription2.add(this.getAddOrRefreshTablesAction(workbenchContext2));
        toolBarDescription.add(toolBarButtonGroupDescription2);
        return toolBarDescription;
    }

    public TableNode tableNodeFor(MWTable mWTable) {
        return (TableNode)this.descendantNodeForValue((Node)mWTable);
    }
}

