/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class DatabasePlatformChooserDialog
extends AbstractDialog {
    JList list;
    private PropertyValueModel selectionHolder;

    DatabasePlatformChooserDialog(WorkbenchContext workbenchContext, PropertyValueModel propertyValueModel) {
        super(workbenchContext, workbenchContext.getApplicationContext().getResourceRepository().getString("DATABASE_PLATFORMS_DIALOG.title"));
        this.selectionHolder = propertyValueModel;
    }

    private DoubleClickMouseListener buildDoubleClickMouseListener() {
        return new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                DatabasePlatformChooserDialog.this.clickOK();
            }
        };
    }

    private ListSelectionListener buildListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JList jList = (JList)listSelectionEvent.getSource();
                    DatabasePlatformChooserDialog.this.getOKAction().setEnabled(jList.getSelectedValue() != null);
                }
            }
        };
    }

    protected Component buildMainPanel() {
        this.list = PlatformComponentFactory.buildPlatformList(this.selectionHolder);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this.buildListSelectionListener());
        SwingComponentFactory.addDoubleClickMouseListener(this.list, this.buildDoubleClickMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.getViewport().setPreferredSize(this.list.getPreferredSize());
        return jScrollPane;
    }

    protected String helpTopicId() {
        return "dialog.databasePlatform";
    }

    protected Component initialFocusComponent() {
        return this.list;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }
}

