/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class LoginSpecPanel
extends AbstractPanel {
    private PropertyValueModel selectedLoginSpecHolder;

    public LoginSpecPanel(PropertyValueModel propertyValueModel, ApplicationContext applicationContext) {
        super(applicationContext);
        this.initialize(propertyValueModel);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        this.selectedLoginSpecHolder = propertyValueModel;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("DRIVER_CLASS_COMBO_BOX_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jLabel));
        this.addAlignLeft(jLabel);
        JComboBox jComboBox = this.buildDriverClassComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        jComboBox.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jComboBox));
        JLabel jLabel2 = this.buildLabel("URL_COMBO_BOX_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jLabel2));
        this.addAlignLeft(jLabel2);
        JComboBox jComboBox2 = this.buildConnectionUrlComboBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)jComboBox2, gridBagConstraints);
        jLabel2.setLabelFor(jComboBox2);
        jComboBox2.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jComboBox2));
        JLabel jLabel3 = this.buildLabel("USERNAME_TEXT_FIELD_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel3.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jLabel3));
        this.addAlignLeft(jLabel3);
        JTextField jTextField = this.buildUserNameTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        jLabel3.setLabelFor(jTextField);
        jTextField.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jTextField));
        JLabel jLabel4 = this.buildLabel("PASSWORD_TEXT_FIELD_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel4.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jLabel4));
        this.addAlignLeft(jLabel4);
        JPasswordField jPasswordField = this.buildPasswordField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)jPasswordField, gridBagConstraints);
        jLabel4.setLabelFor(jPasswordField);
        jPasswordField.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jPasswordField));
        JCheckBox jCheckBox = this.buildSavePasswordCheckBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox.setEnabled(false);
        this.selectedLoginSpecHolder.addPropertyChangeListener("value", this.buildSelectedLoginInfoListener(jCheckBox));
    }

    private JComboBox buildDriverClassComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildSortedDriverClassesHolder(), this.buildDriverClassAdapter()));
        jComboBox.setEditable(true);
        return jComboBox;
    }

    private ListValueModel buildSortedDriverClassesHolder() {
        return new SortedListValueModelAdapter(this.buildAllDriverClassesAdapter());
    }

    private CollectionValueModel buildAllDriverClassesAdapter() {
        return new CollectionAspectAdapter(this.selectedLoginSpecHolder){

            protected Iterator getValueFromSubject() {
                return LoginSpecPanel.this.compositeDriverClassIterator(MWLoginSpec.commonDriverClassNames());
            }

            protected int sizeFromSubject() {
                return LoginSpecPanel.this.compositeDriverClassSize(MWLoginSpec.commonDriverClassNamesSize());
            }
        };
    }

    private Iterator compositeDriverClassIterator(Iterator iterator) {
        String string = this.preferences().get("database driver class", null);
        if (string != null) {
            return new CompositeIterator(iterator, (Iterator)new SingleElementIterator((Object)string));
        }
        return iterator;
    }

    private int compositeDriverClassSize(int n) {
        String string = this.preferences().get("database driver class", null);
        if (string != null) {
            ++n;
        }
        return n;
    }

    private PropertyValueModel buildDriverClassAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "driverClassName"){

            protected Object getValueFromSubject() {
                String string = ((MWLoginSpec)this.subject).getDriverClassName();
                if (string == null && (string = LoginSpecPanel.this.preferences().get("database driver class", null)) != null) {
                    ((MWLoginSpec)this.subject).setDriverClassName(string);
                }
                return string;
            }

            protected void setValueOnSubject(Object object) {
                ((MWLoginSpec)this.subject).setDriverClassName((String)object);
            }
        };
    }

    private JComboBox buildConnectionUrlComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildSortedConnectionUrlsHolder(), this.buildConnectionUrlAdapter()));
        jComboBox.setEditable(true);
        return jComboBox;
    }

    private ListValueModel buildSortedConnectionUrlsHolder() {
        return new SortedListValueModelAdapter(this.buildAllConnectionUrlsAdapter());
    }

    private CollectionValueModel buildAllConnectionUrlsAdapter() {
        return new CollectionAspectAdapter(this.selectedLoginSpecHolder, "candidateURLs"){

            protected Iterator getValueFromSubject() {
                return LoginSpecPanel.this.compositeConnectionUrlIterator(((MWLoginSpec)this.subject).candidateURLs());
            }

            protected int sizeFromSubject() {
                return LoginSpecPanel.this.compositeConnectionUrlSize(((MWLoginSpec)this.subject).candidateURLsSize());
            }
        };
    }

    private Iterator compositeConnectionUrlIterator(Iterator iterator) {
        String string = this.preferences().get("database connection url", null);
        if (string != null) {
            return new CompositeIterator(iterator, (Iterator)new SingleElementIterator((Object)string));
        }
        return iterator;
    }

    private int compositeConnectionUrlSize(int n) {
        String string = this.preferences().get("database connection url", null);
        if (string != null) {
            ++n;
        }
        return n;
    }

    private PropertyValueModel buildConnectionUrlAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "url"){

            protected Object getValueFromSubject() {
                String string = ((MWLoginSpec)this.subject).getURL();
                if (string == null && (string = LoginSpecPanel.this.preferences().get("database connection url", null)) != null) {
                    ((MWLoginSpec)this.subject).setURL(string);
                }
                return string;
            }

            protected void setValueOnSubject(Object object) {
                String string = (String)object;
                MWLoginSpec mWLoginSpec = (MWLoginSpec)this.subject;
                if (string == null || string.length() == 0) {
                    mWLoginSpec.setURL(null);
                } else {
                    mWLoginSpec.setURL(string);
                }
            }
        };
    }

    private JTextField buildUserNameTextField() {
        return new JTextField(this.buildUserNameDocumentAdapter(), null, 1);
    }

    private Document buildUserNameDocumentAdapter() {
        return new DocumentAdapter(this.buildUserNameAdapter());
    }

    private PropertyValueModel buildUserNameAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "userName"){

            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).getUserName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWLoginSpec)this.subject).setUserName((String)object);
            }
        };
    }

    private JPasswordField buildPasswordField() {
        return new JPasswordField(this.buildPasswordDocumentAdapter(), null, 1);
    }

    private Document buildPasswordDocumentAdapter() {
        return new DocumentAdapter(this.buildPasswordAdapter());
    }

    private PropertyValueModel buildPasswordAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "password"){

            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).getPassword();
            }

            protected void setValueOnSubject(Object object) {
                ((MWLoginSpec)this.subject).setPassword((String)object);
            }
        };
    }

    private JCheckBox buildSavePasswordCheckBox() {
        return this.buildCheckBox("SAVE_PASSWORD_CHECK_BOX", this.buildSavePasswordCheckBoxModelAdapter());
    }

    private ButtonModel buildSavePasswordCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildSavePasswordPropertyAdapter());
    }

    private PropertyValueModel buildSavePasswordPropertyAdapter() {
        return new PropertyAspectAdapter(this.selectedLoginSpecHolder, "savePassword"){

            protected Object getValueFromSubject() {
                return ((MWLoginSpec)this.subject).isSavePassword();
            }

            protected void setValueOnSubject(Object object) {
                ((MWLoginSpec)this.subject).setSavePassword(((Boolean)object).booleanValue());
            }
        };
    }

    private PropertyChangeListener buildSelectedLoginInfoListener(final Component component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(propertyChangeEvent.getNewValue() != null);
            }
        };
    }
}

