/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

final class RelationshipGenerationDialog
extends AbstractDialog
implements ActionListener,
ListSelectionListener {
    private TreeSet availableListData;
    private TreeSet selectedListData;
    private JList availableList;
    private JList selectedList;
    private JButton oneToManyButton;
    private JButton oneToOneButton;
    private boolean generateBidirectionalRelationships;
    private JCheckBox generateBidirectionalRelationshipsCheckBox;
    protected static final String ID_ONE_TO_ONE = "One-To-One";
    protected static final String ID_CREATE = "Create";
    protected static final String ID_SKIP = "Skip";
    protected static final String ID_ONE_TO_MANY = "One-To-Many";
    protected static final String ID_DESELECT_ITEMS = "Deselect Items";

    public RelationshipGenerationDialog(Vector vector, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.setAvailableListData(vector);
        this.setSelectedListData(new Vector());
    }

    public boolean getGenerateBidirectionalRelationships() {
        return this.generateBidirectionalRelationshipsCheckBox.isSelected();
    }

    private ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                MWRelationshipHolder mWRelationshipHolder = (MWRelationshipHolder)object;
                jLabel.setText(mWRelationshipHolder.displayString());
                if (mWRelationshipHolder.isOneToOne()) {
                    jLabel.setIcon(RelationshipGenerationDialog.this.resourceRepository().getIcon("mapping.oneToOne"));
                } else if (mWRelationshipHolder.isOneToMany()) {
                    jLabel.setIcon(RelationshipGenerationDialog.this.resourceRepository().getIcon("mapping.oneToMany"));
                }
                return jLabel;
            }
        };
    }

    public Collection getRelationshipsToCreate() {
        return new Vector(this.selectedListData);
    }

    protected String helpTopicId() {
        return "dialog.relationshipGenerator";
    }

    protected Component initialFocusComponent() {
        return this.availableList;
    }

    protected void initialize(WorkbenchContext workbenchContext) {
        super.initialize(workbenchContext);
        this.setTitle(this.resourceRepository().getString("chooseRelationshipsToGenerate.title"));
    }

    protected void prepareToShow() {
        this.setSize(800, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString("basedOnTheForeignKeysOfThe"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.add((Component)labelArea, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        jPanel.add((Component)jSeparator, gridBagConstraints);
        JLabel jLabel = SwingComponentFactory.buildLabel("potentialRelationships", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.availableList = new JList();
        this.availableList.setCellRenderer(this.getListCellRenderer());
        this.availableList.setSelectionMode(2);
        this.availableList.addListSelectionListener(this);
        this.availableList.setListData(this.availableListData.toArray());
        jLabel.setLabelFor(this.availableList);
        JScrollPane jScrollPane = new JScrollPane(this.availableList);
        jScrollPane.getViewport().setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("selectedRelationships", this.resourceRepository());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.selectedList = SwingComponentFactory.buildList();
        this.selectedList.setCellRenderer(this.getListCellRenderer());
        this.selectedList.setSelectionMode(2);
        this.selectedList.setListData(this.selectedListData.toArray());
        SwingComponentFactory.addDoubleClickMouseListener(this.selectedList, new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                RelationshipGenerationDialog.this.deselectItems();
            }
        });
        jLabel2.setLabelFor(this.selectedList);
        JScrollPane jScrollPane2 = new JScrollPane(this.selectedList);
        jScrollPane2.getViewport().setPreferredSize(new Dimension(0, 0));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 5);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        this.oneToOneButton = new JButton();
        this.oneToOneButton.setIcon(this.resourceRepository().getIcon("mapping.oneToOne"));
        this.oneToOneButton.setToolTipText(this.resourceRepository().getString("mapAsOneToOne"));
        this.oneToOneButton.setActionCommand(ID_ONE_TO_ONE);
        this.oneToOneButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        jPanel.add((Component)this.oneToOneButton, gridBagConstraints);
        this.oneToManyButton = new JButton();
        this.oneToManyButton.setIcon(this.resourceRepository().getIcon("mapping.oneToMany"));
        this.oneToManyButton.setToolTipText(this.resourceRepository().getString("mapAsOneToMany"));
        this.oneToManyButton.setActionCommand(ID_ONE_TO_MANY);
        this.oneToManyButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.oneToManyButton, gridBagConstraints);
        JButton jButton = new JButton();
        jButton.addActionListener(this.buildAction());
        jButton.setIcon(this.resourceRepository().getIcon("shuttle.left"));
        jButton.setEnabled(false);
        jButton.setToolTipText(this.resourceRepository().getString("removeSelectedMappings"));
        this.selectedList.addListSelectionListener(this.buildSelectionListListener(jButton));
        jButton.setActionCommand(ID_DESELECT_ITEMS);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.generateBidirectionalRelationshipsCheckBox = new JCheckBox(this.resourceRepository().getString("generateBidirectionalRelationships"));
        this.generateBidirectionalRelationshipsCheckBox.setMnemonic(this.resourceRepository().getMnemonic("generateBidirectionalRelationships"));
        this.generateBidirectionalRelationshipsCheckBox.setSelected(this.generateBidirectionalRelationships);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.generateBidirectionalRelationshipsCheckBox, gridBagConstraints);
        return jPanel;
    }

    private ListSelectionListener buildSelectionListListener(final JButton jButton) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (RelationshipGenerationDialog.this.selectedList.getSelectedValues().length > 0) {
                    jButton.setEnabled(true);
                } else {
                    jButton.setEnabled(false);
                }
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == ID_ONE_TO_ONE) {
            this.selectItems(ID_ONE_TO_ONE);
        } else if (string == ID_ONE_TO_MANY) {
            this.selectItems(ID_ONE_TO_MANY);
        } else if (string == ID_DESELECT_ITEMS) {
            this.deselectItems();
        }
    }

    private AbstractFrameworkAction buildAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            public void actionPerformed(ActionEvent actionEvent) {
                RelationshipGenerationDialog.this.actionPerformed(actionEvent);
            }
        };
    }

    private void deselectItems() {
        TreeSet treeSet = this.selectedListData;
        TreeSet treeSet2 = this.availableListData;
        Object[] objectArray = this.selectedList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            ((MWRelationshipHolder)objectArray[i]).setNoRelationship();
            treeSet.remove(objectArray[i]);
            treeSet2.add(objectArray[i]);
        }
        this.availableList.setListData(treeSet2.toArray());
        this.selectedList.setListData(treeSet.toArray());
        this.setAvailableListData(treeSet2);
        this.setSelectedListData(treeSet);
    }

    public void selectItems(String string) {
        TreeSet treeSet = this.selectedListData;
        TreeSet treeSet2 = this.availableListData;
        Object[] objectArray = this.availableList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if (treeSet.contains(objectArray[i])) continue;
            MWRelationshipHolder mWRelationshipHolder = (MWRelationshipHolder)objectArray[i];
            if (string.equals(ID_ONE_TO_ONE)) {
                mWRelationshipHolder.setOneToOne();
            } else {
                mWRelationshipHolder.setOneToMany();
            }
            treeSet.add(objectArray[i]);
            treeSet2.remove(objectArray[i]);
        }
        this.availableList.setListData(treeSet2.toArray());
        this.selectedList.setListData(treeSet.toArray());
        this.setAvailableListData(treeSet2);
        this.setSelectedListData(treeSet);
    }

    private void setAvailableListData(Collection collection) {
        this.availableListData = new TreeSet(collection);
    }

    public void setGenerateBidirectionalRelationships(boolean bl) {
        this.generateBidirectionalRelationships = bl;
    }

    private void setSelectedListData(Collection collection) {
        this.selectedListData = new TreeSet(collection);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object[] objectArray = this.availableList.getSelectedValues();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            MWRelationshipHolder mWRelationshipHolder = (MWRelationshipHolder)objectArray[i];
            if (mWRelationshipHolder.canMapOneToOne()) {
                ++n;
            }
            if (!mWRelationshipHolder.canMapOneToMany()) continue;
            ++n2;
        }
        this.oneToOneButton.setEnabled(n > 0);
        this.oneToManyButton.setEnabled(n2 > 0 && n2 == objectArray.length);
    }
}

