/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class AdvancedPolicyChooser
extends AbstractDialog {
    private final ListValueModel advancedPropertiesCollection;
    private final ObjectListSelectionModel selectedItems;
    private final CellRendererAdapter cellRenderer;

    AdvancedPolicyChooser(WorkbenchContext workbenchContext, ListValueModel listValueModel, ObjectListSelectionModel objectListSelectionModel, CellRendererAdapter cellRendererAdapter) {
        super(workbenchContext, workbenchContext.getApplicationContext().getResourceRepository().getString("ADVANCED_PROPERTY_CHOOSER_TITLE"));
        this.advancedPropertiesCollection = listValueModel;
        this.selectedItems = objectListSelectionModel;
        this.cellRenderer = cellRendererAdapter;
    }

    protected JComponent buildAdvancedPropertiesPanel() {
        CheckList checkList = new CheckList(this.advancedPropertiesCollection, (ListSelectionModel)this.selectedItems, this.cellRenderer);
        checkList.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        return checkList;
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString("ADVANCED_PROPERTY_CHOOSER_PLEASE_SELECT_ALL"));
        labelArea.setScrollable(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)labelArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)this.buildAdvancedPropertiesPanel(), gridBagConstraints);
        return jPanel;
    }

    protected String helpTopicId() {
        return "dialog.advancedProperties";
    }
}

