/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorAfterLoadingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class AfterLoadingPropertiesPage
extends ScrollablePropertiesPage {
    static final int EDITOR_WEIGHT = 12;
    private PropertyValueModel afterLoadingPolicyHolder;
    private PropertyValueModel postLoadMethodClassHolder;
    private PropertyValueModel postLoadMethodHolder;

    AfterLoadingPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.afterLoadingPolicyHolder = this.buildAfterLoadingPolicyHolder();
        this.postLoadMethodClassHolder = this.buildPostLoadMethodClassHolder();
        this.postLoadMethodHolder = this.buildPostLoadMethodHolder();
    }

    private PropertyValueModel buildAfterLoadingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "afterLoadingPolicy"){

            protected Object getValueFromSubject() {
                MWDescriptorPolicy mWDescriptorPolicy = ((MWMappingDescriptor)this.subject).getAfterLoadingPolicy();
                return mWDescriptorPolicy.isActive() ? mWDescriptorPolicy : null;
            }
        };
    }

    private PropertyValueModel buildPostLoadMethodClassHolder() {
        return new PropertyAspectAdapter(this.afterLoadingPolicyHolder, "postLoadMethodClass"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorAfterLoadingPolicy)this.subject).getPostLoadMethodClass();
            }

            protected void setValueOnSubject(Object object) {
                MWClass mWClass = (MWClass)object;
                ((MWDescriptorAfterLoadingPolicy)this.subject).setPostLoadMethodClass(mWClass);
                if (mWClass != null) {
                    try {
                        if (mWClass.isStub()) {
                            mWClass.refresh();
                        }
                    }
                    catch (ExternalClassNotFoundException externalClassNotFoundException) {
                        AfterLoadingPropertiesPage.this.showClassLoadingException();
                    }
                }
            }
        };
    }

    private PropertyValueModel buildPostLoadMethodHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.afterLoadingPolicyHolder, "postLoadMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorAfterLoadingPolicy)this.subject).getPostLoadMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorAfterLoadingPolicy)this.subject).setPostLoadMethod((MWMethod)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "signature");
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("AFTER_LOAD_POLICY_DESCRIPTOR");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("AFTER_LOAD_POLICY_CLASS");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ClassChooserPanel classChooserPanel = this.buildPostLoadMethodClassChooserPanel(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)classChooserPanel, gridBagConstraints);
        this.addPaneForAlignment(classChooserPanel);
        JLabel jLabel3 = this.buildLabel("AFTER_LOAD_POLICY_STATIC_METHOD");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ListChooser listChooser = this.buildPostLoadMethodListChooser();
        jLabel3.setLabelFor(listChooser);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        Spacer spacer = new Spacer();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)spacer, gridBagConstraints);
        this.addAlignRight(spacer);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.getHelpTopicId());
        return jPanel;
    }

    private ClassChooserPanel buildPostLoadMethodClassChooserPanel(JLabel jLabel) {
        return ClassChooserTools.buildPanel(this.postLoadMethodClassHolder, this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), jLabel, this.getWorkbenchContextHolder());
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return AfterLoadingPropertiesPage.this.descriptor().getRepository();
            }
        };
    }

    private ListChooser buildPostLoadMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildExtendedPostLoadMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildPostLoadMethodListDialogBuilder());
        defaultListChooser.setRenderer(DescriptorComponentFactory.buildMethodRenderer(this.resourceRepository()));
        this.updatePostLoadMethodChooser(defaultListChooser);
        this.postLoadMethodClassHolder.addPropertyChangeListener("value", this.buildPostLoadMethodClassListener(defaultListChooser));
        return defaultListChooser;
    }

    private CachingComboBoxModel buildExtendedPostLoadMethodComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildPostLoadMethodComboBoxModel());
    }

    private CachingComboBoxModel buildPostLoadMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.postLoadMethodHolder, this.postLoadMethodClassHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return AfterLoadingPropertiesPage.this.orderedPostLoadMethodChoices((MWClass)object);
            }
        };
    }

    ListIterator orderedPostLoadMethodChoices(MWClass mWClass) {
        return CollectionTools.sort((Iterator)mWClass.candidateDescriptorAfterLoadMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildPostLoadMethodListDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("POST_LOAD_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("POST_LOAD_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(DescriptorComponentFactory.buildMethodStringConverter());
        return builder;
    }

    private PropertyChangeListener buildPostLoadMethodClassListener(final ListChooser listChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AfterLoadingPropertiesPage.this.updatePostLoadMethodChooser(listChooser);
            }
        };
    }

    private String getHelpTopicId() {
        return "descriptor.afterloading";
    }

    void showClassLoadingException() {
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString("PROBLEM_LOADING_CLASS"));
        JOptionPane.showMessageDialog(this, labelArea, this.resourceRepository().getString("PROBLEM_LOADING_CLASS_TITLE"), 0);
        this.postLoadMethodClassHolder.setValue(null);
    }

    void updatePostLoadMethodChooser(ListChooser listChooser) {
        listChooser.setEnabled(this.postLoadMethodClassHolder.getValue() != null);
    }

    MWMappingDescriptor descriptor() {
        return (MWMappingDescriptor)this.selection();
    }
}

