/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassAttributeCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassAttributePanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class ClassAttributesPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;
    PropertyValueModel selectedAttributeHolder;

    ClassAttributesPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.mwClassHolder = this.buildMWClassHolder();
        this.selectedAttributeHolder = new SimplePropertyValueModel();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveListPanelAdapter(), this.buildAttributeModifierAdapter(), 2, this.resourceRepository().getString("ATTRIBUTES_LIST"), this.buildAttributeSelector());
        addRemoveListPanel.setCellRenderer(this.buildAttributesListCellRenderer());
        addRemoveListPanel.setBorder(this.buildStandardEmptyBorder());
        addRemoveListPanel.addListSelectionListener(this.buildListSelectionListener(addRemoveListPanel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)addRemoveListPanel, gridBagConstraints);
        ClassAttributePanel classAttributePanel = new ClassAttributePanel(this.selectedAttributeHolder, this.getSelectionHolder(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)classAttributePanel, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private NodeSelector buildAttributeSelector() {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                ProjectNode projectNode = (ProjectNode)ClassAttributesPropertiesPage.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectMappingNodeFor((MWClassAttribute)object, ClassAttributesPropertiesPage.this.navigatorSelectionModel());
            }
        };
    }

    private MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    private ListCellRenderer buildAttributesListCellRenderer() {
        return new AdaptableListCellRenderer(new ClassAttributeCellRendererAdapter(this.resourceRepository()));
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel addRemoveListPanel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (addRemoveListPanel.getSelectedValues().length > 1) {
                    ClassAttributesPropertiesPage.this.selectedAttributeHolder.setValue(null);
                } else {
                    ClassAttributesPropertiesPage.this.selectedAttributeHolder.setValue(addRemoveListPanel.getSelectedValue());
                }
            }
        };
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                ClassAttributesPropertiesPage.this.addNewAttribute(objectListSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                ClassAttributesPropertiesPage.this.removeSelectedAttributes(objectListSelectionModel);
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                ClassAttributesPropertiesPage.this.renameSelectedAttribute(objectListSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    void addNewAttribute(ObjectListSelectionModel objectListSelectionModel) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.getMWClass().attributeNames());
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTitle(this.resourceRepository().getString("addNewAttribute.title"));
        builder.setTextFieldDescription(this.resourceRepository().getString("enterTheNameOfTheNewAttribute.message"));
        builder.setHelpTopicId("dialog.newAttribute");
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(6);
            }
        });
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (!newNameDialog.wasConfirmed()) {
            return;
        }
        MWClassAttribute mWClassAttribute = this.getMWClass().addAttribute(newNameDialog.getNewName());
        objectListSelectionModel.setSelectedValue(mWClassAttribute);
    }

    private CollectionValueModel buildAttributesHolder() {
        return new CollectionAspectAdapter(this.mwClassHolder, "attributes"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).attributes();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).attributesSize();
            }
        };
    }

    private ItemPropertyListValueModelAdapter buildAttributeModifierAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedAttributesListValueModelAdapter(), "modifierAccessLevel", "declaration");
    }

    private SortedListValueModelAdapter buildSortedAttributesListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildAttributeNameAdapter());
    }

    private ItemPropertyListValueModelAdapter buildAttributeNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildAttributesHolder(), "name");
    }

    void removeSelectedAttributes(ObjectListSelectionModel objectListSelectionModel) {
        this.getMWClass().removeAttributes(CollectionTools.collection((Object[])objectListSelectionModel.getSelectedValues()));
    }

    void renameSelectedAttribute(ObjectListSelectionModel objectListSelectionModel) {
        MWClassAttribute mWClassAttribute = (MWClassAttribute)objectListSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(mWClassAttribute.getDeclaringType().attributeNames());
        builder.setOriginalName(mWClassAttribute.getName());
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("renameAttribute.message"));
        builder.setTitle(this.resourceRepository().getString("renameAttribute.title"));
        builder.setHelpTopicId("dialog.attributeRename");
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(6);
            }
        });
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        String string = newNameDialog.getNewName();
        this.navigatorSelectionModel().pushExpansionState();
        mWClassAttribute.setName(string);
        objectListSelectionModel.setSelectedValue(mWClassAttribute);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes";
    }
}

