/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ExtractionMethodListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class ClassExtractionMethodPanel
extends AbstractSubjectPanel
implements RootListener,
ExtractionMethodListener {
    private boolean isRoot;
    private boolean isExtractionMethod;
    private ListChooser classExtractionMethodListChooser;

    ClassExtractionMethodPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel) {
        super((ValueModel)propertyValueModel, applicationContext);
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.classExtractionMethodListChooser = this.buildClassExtractionMethodChooser();
        this.classExtractionMethodListChooser.putClientProperty("labeledBy", new JLabel(" "));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.classExtractionMethodListChooser, gridBagConstraints);
        new ComponentEnabler(this.buildUseClassExtractionMethodHolder(), Collections.singleton(this.classExtractionMethodListChooser));
    }

    private ValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)((MWClassIndicatorPolicy)this.subject).getParent()).getOwningDescriptor().getMWClass();
            }
        };
    }

    private ListChooser buildClassExtractionMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildExtendedClassExtractionMethodComboBoxModel(), this.getWorkbenchContextHolder(), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()), this.buildPostLoadMethodListDialogBuilder());
        defaultListChooser.setRenderer(DescriptorComponentFactory.buildMethodRenderer(this.resourceRepository()));
        return defaultListChooser;
    }

    private CachingComboBoxModel buildExtendedClassExtractionMethodComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildClassExtractionMethodComboBoxModel());
    }

    private CachingComboBoxModel buildClassExtractionMethodComboBoxModel() {
        return new IndirectComboBoxModel(this.buildClassExtractionMethodChooserPropertyAdapter(), this.buildMWClassHolder()){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassExtractionMethodPanel.this.orderedClassExtractionMethodChoices((MWClass)object);
            }
        };
    }

    ListIterator orderedClassExtractionMethodChoices(MWClass mWClass) {
        return CollectionTools.sort((Iterator)mWClass.candidateClassExtractionMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildPostLoadMethodListDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("CLASS_EXTRACTION_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("CLASS_EXTRACTION_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(DescriptorComponentFactory.buildMethodStringConverter());
        return builder;
    }

    private PropertyValueModel buildClassExtractionMethodChooserPropertyAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "classExtractionMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassIndicatorExtractionMethodPolicy)this.subject).getClassExtractionMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassIndicatorExtractionMethodPolicy)this.subject).setClassExtractionMethod((MWMethod)object);
            }
        };
    }

    private ValueModel buildUseClassExtractionMethodHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            protected Object buildValue() {
                return this.subject == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    public void updateRootStatus(boolean bl) {
        this.isRoot = bl;
        this.updateEnablementStatus();
    }

    public void updateExtractionMethodStatus(boolean bl) {
        this.isExtractionMethod = bl;
        this.updateEnablementStatus();
    }

    protected void updateEnablementStatus() {
        this.classExtractionMethodListChooser.setEnabled(this.isRoot() && this.isExtractionMethod());
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isExtractionMethod() {
        return this.isExtractionMethod;
    }
}

