/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorDictionaryListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorFieldListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ClassIndicatorDictionarySubPanel
extends AbstractPanel
implements RootListener,
IndicatorFieldListener,
IndicatorDictionaryListener {
    private JButton editButton;
    private ObjectListSelectionModel rowSelectionModel;
    private TableModel classIndicatorTableModel;
    private ValueModel classIndicatorFieldPolicyHolder;
    protected ListChooser indicatorTypeListChooser;
    protected JLabel typeLabel;
    protected JScrollPane tableScrollPane;
    private boolean isRoot;
    private boolean isIndicatorField;
    private boolean isIndicatorDictionary;

    protected ClassIndicatorDictionarySubPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        this.classIndicatorFieldPolicyHolder = this.buildClassIndicatorFieldPolicyHolder(propertyValueModel);
        this.rowSelectionModel = this.buildRowSelectionModel();
        this.editButton = this.buildEditButton();
    }

    protected PropertyValueModel buildClassIndicatorFieldPolicyHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWClassIndicatorFieldPolicy;
            }
        };
    }

    protected ValueModel buildUseClassIndicatorDictionaryBooleanHolder() {
        return new PropertyAspectAdapter(this.classIndicatorFieldPolicyHolder, "classNameIsIndicator"){

            protected Object getValueFromSubject() {
                return !((MWClassIndicatorFieldPolicy)this.subject).classNameIsIndicator();
            }
        };
    }

    private JButton buildEditButton() {
        JButton jButton = this.buildButton("EDIT");
        jButton.addActionListener(this.buildEditAction());
        jButton.setEnabled(false);
        return jButton;
    }

    protected ListChooser buildIndicatorTypeChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser((ComboBoxModel)new ComboBoxModelAdapter(this.buildIndicatorTypeChooserValueModel(), this.buildIndicatorTypeChooserPropertyAdapter()), this.getWorkbenchContextHolder());
        defaultListChooser.setRenderer(this.buildIndicatorTypeChooserRenderer());
        defaultListChooser.setLongListSize(30);
        return defaultListChooser;
    }

    private ListCellRenderer buildIndicatorTypeChooserRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private TableCellRenderer buildClassColumnRenderer() {
        return new AdaptableTableCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository()));
    }

    private CollectionValueModel buildIndicatorTypeChooserValueModel() {
        return new CollectionAspectAdapter(this.classIndicatorFieldPolicyHolder){

            protected Iterator getValueFromSubject() {
                MWAbstractClassIndicatorPolicy mWAbstractClassIndicatorPolicy = (MWAbstractClassIndicatorPolicy)this.subject;
                return mWAbstractClassIndicatorPolicy.buildBasicTypes().iterator();
            }
        };
    }

    private PropertyValueModel buildIndicatorTypeChooserPropertyAdapter() {
        return new PropertyAspectAdapter(this.classIndicatorFieldPolicyHolder, "indicatorType"){

            protected Object getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).getIndicatorType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassIndicatorFieldPolicy)this.subject).setIndicatorType((MWTypeDeclaration)object);
            }
        };
    }

    protected MWClassIndicatorFieldPolicy getClassIndicatorPolicy() {
        return (MWClassIndicatorFieldPolicy)this.classIndicatorFieldPolicyHolder.getValue();
    }

    protected String helpTopicId() {
        return "descriptor.inheritance.classIndicator.classIndicatorDictionary";
    }

    protected JTable buildClassIndicatorValuesTable() {
        this.classIndicatorTableModel = this.buildClassIndicatorValuesTableModel();
        JTable jTable = SwingComponentFactory.buildTable(this.classIndicatorTableModel, this.rowSelectionModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(400, 75));
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(25);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = new CheckBoxTableCellRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        TableCellRenderer tableCellRenderer = this.buildClassColumnRenderer();
        tableColumn.setCellRenderer(tableCellRenderer);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        return jTable;
    }

    private TableModel buildClassIndicatorValuesTableModel() {
        return new TableModelAdapter(this.buildClassIndicatorValueAdapter(), this.buildClassIndicatorValueTableColumnAdapter());
    }

    private ColumnAdapter buildClassIndicatorValueTableColumnAdapter() {
        return new ClassIndicatorValueColumnAdapter(this.resourceRepository(), this);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.buildClassIndicatorValuesHolder()));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener(objectListSelectionModel));
        objectListSelectionModel.setSelectionMode(0);
        return objectListSelectionModel;
    }

    private ListValueModel buildClassIndicatorValueAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildClassIndicatorValuesHolder(), "indicatorValue");
    }

    private CollectionValueModel buildClassIndicatorValuesHolder() {
        return new CollectionAspectAdapter(this.classIndicatorFieldPolicyHolder, "classIndicatorValues"){

            protected Iterator getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).classIndicatorValues();
            }
        };
    }

    private Action buildEditAction() {
        return new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassIndicatorDictionarySubPanel.this.editIndicator();
            }
        };
    }

    private void editIndicator() {
        Object object = null;
        MWMappingDescriptor mWMappingDescriptor = null;
        for (int i = this.classIndicatorTableModel.getRowCount() - 1; i >= 0; --i) {
            if (!this.rowSelectionModel.isSelectedIndex(i)) continue;
            object = this.classIndicatorTableModel.getValueAt(i, 2);
            mWMappingDescriptor = (MWMappingDescriptor)this.classIndicatorTableModel.getValueAt(i, 1);
        }
        MWClassIndicatorValueDialog mWClassIndicatorValueDialog = new MWClassIndicatorValueDialog(this.getWorkbenchContext(), this.classIndicatorFieldPolicyHolder, mWMappingDescriptor, object);
        mWClassIndicatorValueDialog.show();
    }

    private ListSelectionListener buildRowSelectionListener(final ListSelectionModel listSelectionModel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ClassIndicatorDictionarySubPanel.this.editButton.getModel().setEnabled(ClassIndicatorDictionarySubPanel.this.editButtonShouldBeEnabled() && (!listSelectionModel.isSelectionEmpty() || listSelectionModel.getMinSelectionIndex() != listSelectionModel.getMaxSelectionIndex()));
                }
            }
        };
    }

    private PropertyChangeListener buildIncludePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassIndicatorDictionarySubPanel.this.updateEditButton();
            }
        };
    }

    private void updateEditButton() {
        this.editButton.setEnabled(this.editButtonShouldBeEnabled());
    }

    private boolean editButtonShouldBeEnabled() {
        return this.getRowSelectionModel().getSelectedValue() != null && ((MWClassIndicatorValue)this.rowSelectionModel.getSelectedValue()).isInclude();
    }

    protected ObjectListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    protected JButton getEditButton() {
        return this.editButton;
    }

    public void updateRootStatus(boolean bl) {
        this.isRoot = bl;
        this.updateEnablementStatus();
    }

    public void updateIndicatorFieldStatus(boolean bl) {
        this.isIndicatorField = bl;
        this.updateEnablementStatus();
    }

    public void updateIndicatorDictionaryStatus(boolean bl) {
        this.isIndicatorDictionary = bl;
        this.updateEnablementStatus();
    }

    protected void updateEnablementStatus() {
        this.indicatorTypeListChooser.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
        this.typeLabel.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
        this.tableScrollPane.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isIndicatorField() {
        return this.isIndicatorField;
    }

    public boolean isIndicatorDictionary() {
        return this.isIndicatorDictionary;
    }

    private static class MWClassIndicatorValueDialog
    extends AbstractDialog {
        private Object originalIndicatorValue;
        private JTextField indicatorValueTextField;
        private MWClassIndicatorFieldPolicy policy;
        private MWMappingDescriptor descriptor;

        private MWClassIndicatorValueDialog(WorkbenchContext workbenchContext, ValueModel valueModel, MWMappingDescriptor mWMappingDescriptor, Object object) {
            super(workbenchContext);
            this.originalIndicatorValue = object;
            this.descriptor = mWMappingDescriptor;
            this.policy = (MWClassIndicatorFieldPolicy)valueModel.getValue();
        }

        private String getStringValue(Object object) {
            if (object == null) {
                return "";
            }
            return object.toString();
        }

        protected String helpTopicId() {
            return "descriptor.inheritance.indicator.editDialog";
        }

        protected Component buildMainPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.setTitle(this.resourceRepository().getString("ENTER_INDICATOR_VALUE"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(this.resourceRepository().getString("INDICATOR_TYPE"));
            jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("INDICATOR_TYPE"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jLabel, gridBagConstraints);
            JLabel jLabel2 = new JLabel(this.policy.getIndicatorType().displayStringWithPackage(), this.resourceRepository().getIcon("class.public"), 0);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setMinimumSize(new Dimension(0, 20));
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            jPanel2.add((Component)jLabel2, "West");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            JLabel jLabel3 = new JLabel(this.resourceRepository().getString("INDICATOR_VALUE"));
            jLabel3.setDisplayedMnemonic(this.resourceRepository().getMnemonic("INDICATOR_VALUE"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jLabel3, gridBagConstraints);
            this.indicatorValueTextField = new JTextField(this.getStringValue(this.originalIndicatorValue));
            this.helpManager().addTopicID(this.indicatorValueTextField, this.helpTopicId() + ".indicatorValue");
            this.indicatorValueTextField.setColumns(20);
            this.indicatorValueTextField.getDocument().addDocumentListener(new CVDocumentListener());
            jLabel3.setLabelFor(this.indicatorValueTextField);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.indicatorValueTextField, gridBagConstraints);
            this.updateOKButton();
            return jPanel;
        }

        public boolean preConfirm() {
            String string = this.indicatorValueTextField.getText();
            Object object = null;
            try {
                object = this.policy.buildIndicatorValueFromString(string);
            }
            catch (ConversionException conversionException) {
                this.showInvalidConversionDialog(conversionException);
                return false;
            }
            if (object.equals(this.originalIndicatorValue)) {
                return true;
            }
            if (this.policy.isRepeatedIndicatorValue(object)) {
                this.showRepeatedIndicatorValueDialog(string);
                return false;
            }
            this.policy.getClassIndicatorValueForDescriptor(this.descriptor).setIndicatorValue(object);
            return true;
        }

        protected String getInvalidInputMessage(Class clazz) {
            String string = clazz.getName();
            if (string.equals("java.lang.Boolean")) {
                return this.resourceRepository().getString("BE_EITHER_TRUE_OR_FALSE", string);
            }
            if (string.equals("java.lang.Byte")) {
                return this.resourceRepository().getString("BE_BETWEEN_0_AND_127", string);
            }
            if (string.equals("java.lang.Character")) {
                return this.resourceRepository().getString("BE_SINGLE_CHARACTER", string);
            }
            if (string.equals("java.lang.Double")) {
                return this.resourceRepository().getString("BE_BETWEEN_DOUBLE", new Object[]{string, NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
            }
            if (string.equals("java.lang.Float")) {
                return this.resourceRepository().getString("BE_BETWEEN_FLOAT", new Object[]{string, NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
            }
            if (string.equals("java.lang.Integer")) {
                return this.resourceRepository().getString("BE_BETWEEN_INT", new Object[]{string, NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
            }
            if (string.equals("java.lang.Long")) {
                return this.resourceRepository().getString("BE_BETWEEN_LONG", new Object[]{string, NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
            }
            if (string.equals("java.lang.Short")) {
                return this.resourceRepository().getString("BE_BETWEEN_SHORT", new Object[]{string, NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
            }
            if (string.equals("java.lang.String")) {
                return this.resourceRepository().getString("BE_A_STRING", string);
            }
            if (string.equals("java.math.BigDecimal")) {
                return this.resourceRepository().getString("CONTAINS_ONLY_DIGITS", string);
            }
            if (string.equals("java.math.BigInteger")) {
                return this.resourceRepository().getString("CONTAINS_ONLY_DIGITS_AND", string);
            }
            if (string.equals("java.sql.Date")) {
                return this.resourceRepository().getString("BE_IN_FORMAT1", string);
            }
            if (string.equals("java.sql.Time")) {
                return this.resourceRepository().getString("BE_IN_FORMAT2", string);
            }
            if (string.equals("java.sql.Timestamp")) {
                return this.resourceRepository().getString("BE_IN_FORMAT3", string);
            }
            if (string.equals("java.util.Date")) {
                return this.resourceRepository().getString("BE_IN_FORMAT4", string);
            }
            if (string.equals("java.util.Calendar")) {
                return this.resourceRepository().getString("BE_IN_FORMAT5", string);
            }
            if (clazz == byte[].class || clazz == Byte[].class) {
                return this.resourceRepository().getString("BE_IN_FORMAT_BYTE_ARRAY", string);
            }
            if (clazz == char[].class || clazz == Character[].class) {
                return this.resourceRepository().getString("BE_A_STRING", string);
            }
            return this.resourceRepository().getString("ILLEGAL_FORMAT");
        }

        private void showInvalidConversionDialog(ConversionException conversionException) {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.getInvalidInputMessage(conversionException.getClassToConvertTo()), this.resourceRepository().getString("ILLEGAL_FORMAT"), 2);
        }

        private void showRepeatedIndicatorValueDialog(String string) {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("INDICATOR_VALUE_ALLREADY_EXISTS", string), this.resourceRepository().getString("REPEATED_INDICATOR_VALUE"), 2);
        }

        private void updateOKButton() {
            boolean bl = this.indicatorValueTextField.getText() != null && !this.indicatorValueTextField.getText().equals("");
            this.getOKAction().setEnabled(bl);
        }

        private class CVDocumentListener
        implements DocumentListener {
            private CVDocumentListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }
        }
    }

    private static class ClassIndicatorValueColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        private ClassIndicatorDictionarySubPanel parentPanel;
        public static final int COLUMN_COUNT = 3;
        public static final int INCLUDE_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int VALUE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"INCLUDE_COLUMN_HEADER", "CLASS_COLUMN_HEADER", "VALUE_COLUMN_HEADER"};

        protected ClassIndicatorValueColumnAdapter(ResourceRepository resourceRepository, ClassIndicatorDictionarySubPanel classIndicatorDictionarySubPanel) {
            this.parentPanel = classIndicatorDictionarySubPanel;
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n == 0;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[3];
            PropertyValueModel propertyValueModel = this.buildIncludeAdapter(mWClassIndicatorValue);
            propertyValueModel.addPropertyChangeListener(this.parentPanel.buildIncludePropertyChangeListener());
            propertyValueModelArray[0] = propertyValueModel;
            propertyValueModelArray[1] = this.buildClassAdapter(mWClassIndicatorValue);
            propertyValueModelArray[2] = this.buildValueAdapter(mWClassIndicatorValue);
            return propertyValueModelArray;
        }

        private PropertyValueModel buildIncludeAdapter(MWClassIndicatorValue mWClassIndicatorValue) {
            return new PropertyAspectAdapter("include", (Model)mWClassIndicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).isInclude();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWClassIndicatorValue)this.subject).setInclude(((Boolean)object).booleanValue());
                }
            };
        }

        private PropertyValueModel buildClassAdapter(MWClassIndicatorValue mWClassIndicatorValue) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("descriptorValue", (Model)mWClassIndicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).getDescriptorValue();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildValueAdapter(MWClassIndicatorValue mWClassIndicatorValue) {
            return new PropertyAspectAdapter("indicatorValue", (Model)mWClassIndicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).getIndicatorValueAsString();
                }
            };
        }
    }
}

