/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackagePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RenamePackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapAllDescriptorsInPackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmappablePackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class DescriptorPackageNode
extends MappingsApplicationNode
implements ProjectNode.Child,
UnmappablePackageNode,
AutomappableNode,
RemovableNode {
    private String name;
    private DescriptorNodeBuilder descriptorNodeBuilder;
    private SimpleCollectionValueModel descriptorNodesHolder;
    private ListValueModel childrenModel;
    private boolean descriptorNodeHasBeenRemoved;
    private PropertyChangeListener projectNodeDirtyFlagListener;

    protected DescriptorPackageNode(String string, ProjectNode projectNode, DescriptorNodeBuilder descriptorNodeBuilder) {
        super((MWModel)null, (TreeNodeValueModel)projectNode, projectNode.getPlugin(), projectNode.getApplicationContext());
        this.name = string;
        this.descriptorNodeBuilder = descriptorNodeBuilder;
    }

    protected void initialize() {
        super.initialize();
        this.descriptorNodesHolder = new SimpleCollectionValueModel();
        this.childrenModel = this.buildChildrenModel();
        this.descriptorNodeHasBeenRemoved = false;
        this.projectNodeDirtyFlagListener = this.buildProjectNodeDirtyFlagListener();
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDescriptorsDisplayStringAdapter());
    }

    protected ListValueModel buildDescriptorsDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter((CollectionValueModel)this.descriptorNodesHolder, "displayString");
    }

    protected PropertyChangeListener buildProjectNodeDirtyFlagListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DescriptorPackageNode.this.projectNodeDirtyFlagChanged(propertyChangeEvent);
            }

            public String toString() {
                return "project node dirty flag listener";
            }
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        DescriptorPackageNode descriptorPackageNode = (DescriptorPackageNode)object;
        return this.getParent().equals(descriptorPackageNode.getParent()) && this.name.equals(descriptorPackageNode.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }

    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    public String helpTopicID() {
        return "package";
    }

    protected String buildDisplayString() {
        return this.name == null ? "" : (this.name.length() == 0 ? this.resourceRepository().getString("DEFAULT_PACKAGE") : this.name);
    }

    protected String buildIconKey() {
        return "package";
    }

    protected boolean buildDirtyFlag() {
        Iterator iterator = this.descriptors();
        while (iterator.hasNext()) {
            if (!((MWDescriptor)iterator.next()).isDirtyBranch()) continue;
            return true;
        }
        return this.descriptorNodeHasBeenRemoved;
    }

    protected boolean valueHasBranchProblems() {
        Iterator iterator = this.descriptors();
        while (iterator.hasNext()) {
            if (!((MWDescriptor)iterator.next()).hasBranchProblems()) continue;
            return true;
        }
        return false;
    }

    protected void addExclusiveApplicationProblemsTo(List list) {
    }

    public boolean containsBranchApplicationProblemFor(Problem problem) {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            if (!((DescriptorNode)iterator.next()).containsBranchApplicationProblemFor(problem)) continue;
            return true;
        }
        return false;
    }

    protected void engageValueDisplayString() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodeDisplayString((DescriptorNode)iterator.next());
        }
        this.rebuildDisplayString();
    }

    protected void engageDescriptorNodeDisplayString(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("displayString", this.getValueDisplayStringListener());
    }

    protected void engageValueIcon() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodeIcon((DescriptorNode)iterator.next());
        }
        this.rebuildIconBuilder();
        this.rebuildIcon();
    }

    protected void engageDescriptorNodeIcon(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("icon", this.getValueIconListener());
    }

    protected void engageValueDirty() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodeDirty((DescriptorNode)iterator.next());
        }
        this.getProjectNode().addPropertyChangeListener("dirty", this.projectNodeDirtyFlagListener);
        this.rebuildDirtyFlag();
    }

    protected void engageDescriptorNodeDirty(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("dirty", this.getValueDirtyListener());
    }

    protected void engageValuePropertiesPageTitleIcon() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodePropertiesPageTitleIcon((DescriptorNode)iterator.next());
        }
        this.rebuildPropertiesPageTitleIconBuilder();
        this.rebuildPropertiesPageTitleIcon();
    }

    protected void engageDescriptorNodePropertiesPageTitleIcon(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("propertiesPageTitleIcon", this.getValuePropertiesPageTitleIconListener());
    }

    protected void engageValuePropertiesPageTitleText() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodePropertiesPageTitleText((DescriptorNode)iterator.next());
        }
        this.rebuildPropertiesPageTitleText();
    }

    protected void engageDescriptorNodePropertiesPageTitleText(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("propertiesPageTitleText", this.getValuePropertiesPageTitleTextListener());
    }

    protected void engageValueBranchProblems() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.engageDescriptorNodeBranchProblems((DescriptorNode)iterator.next());
        }
        this.rebuildApplicationProblems();
        this.rebuildBranchApplicationProblems();
    }

    protected void engageDescriptorNodeBranchProblems(DescriptorNode descriptorNode) {
        descriptorNode.addListChangeListener("branchApplicationProblems", this.getValueBranchProblemsListener());
    }

    protected void disengageValueDisplayString() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodeDisplayString((DescriptorNode)iterator.next());
        }
    }

    protected void disengageDescriptorNodeDisplayString(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("displayString", this.getValueDisplayStringListener());
    }

    protected void disengageValueIcon() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodeIcon((DescriptorNode)iterator.next());
        }
    }

    protected void disengageDescriptorNodeIcon(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("icon", this.getValueIconListener());
    }

    protected void disengageValueDirty() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodeDirty((DescriptorNode)iterator.next());
        }
        this.getProjectNode().removePropertyChangeListener("dirty", this.projectNodeDirtyFlagListener);
    }

    protected void disengageDescriptorNodeDirty(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("dirty", this.getValueDirtyListener());
    }

    protected void disengageValuePropertiesPageTitleIcon() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodePropertiesPageTitleIcon((DescriptorNode)iterator.next());
        }
    }

    protected void disengageDescriptorNodePropertiesPageTitleIcon(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("propertiesPageTitleIcon", this.getValuePropertiesPageTitleIconListener());
    }

    protected void disengageValuePropertiesPageTitleText() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodePropertiesPageTitleText((DescriptorNode)iterator.next());
        }
    }

    protected void disengageDescriptorNodePropertiesPageTitleText(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("propertiesPageTitleText", this.getValuePropertiesPageTitleTextListener());
    }

    protected void disengageValueBranchProblems() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            this.disengageDescriptorNodeBranchProblems((DescriptorNode)iterator.next());
        }
    }

    protected void disengageDescriptorNodeBranchProblems(DescriptorNode descriptorNode) {
        descriptorNode.removeListChangeListener("branchApplicationProblems", this.getValueBranchProblemsListener());
    }

    public void addValuePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    public void removeValuePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
    }

    public String accessibleName() {
        if (this.name == null || this.name.length() == 0) {
            return this.resourceRepository().getString("DEFAULT_PACKAGE");
        }
        return this.resourceRepository().getString("ACCESSIBLE_PACKAGE_NODE", this.displayString());
    }

    protected Class propertiesPageClass() {
        return DescriptorPackagePropertiesPage.class;
    }

    public String candidatePackageName() {
        return this.name;
    }

    public boolean isAutoMappable() {
        return true;
    }

    public void addDescriptorsTo(Collection collection) {
        CollectionTools.addAll((Collection)collection, (Iterator)this.descriptors());
    }

    public Iterator descriptors() {
        return new TransformationIterator(this.descriptorNodes()){

            protected Object transform(Object object) {
                return ((DescriptorNode)object).getDescriptor();
            }
        };
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        this.addToMenuDescription(rootMenuDescription, this.buildLocalWorkbenchContext(workbenchContext));
        return rootMenuDescription;
    }

    protected abstract void addToMenuDescription(GroupContainerDescription var1, WorkbenchContext var2);

    protected MenuGroupDescription buildClassActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getMappingsPlugin().getRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.getMappingsPlugin().getAddOrRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.getMappingsPlugin().getCreateNewClassAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildRemoveActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getMappingsPlugin().getRemoveAction(workbenchContext));
        menuGroupDescription.add(this.getRenamePackageAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildUnmapActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getUnmapAllDescriptorsInPackageAction(workbenchContext));
        return menuGroupDescription;
    }

    protected MenuGroupDescription buildExportJavaSourceActionGroup(WorkbenchContext workbenchContext) {
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getMappingsPlugin().getExportSpecificDescriptorModelJavaSourceAction(workbenchContext));
        return menuGroupDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    private FrameworkAction getUnmapAllDescriptorsInPackageAction(WorkbenchContext workbenchContext) {
        return new UnmapAllDescriptorsInPackageAction(workbenchContext);
    }

    private FrameworkAction getRenamePackageAction(WorkbenchContext workbenchContext) {
        return new RenamePackageAction(workbenchContext);
    }

    public int getProjectNodeChildPriority() {
        return 0;
    }

    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_PACKAGE_SUCCESSFUL";
    }

    public void unmapEntirePackage() {
        this.unmap();
    }

    public void unmap() {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            ((DescriptorNode)iterator.next()).unmap();
        }
    }

    public void remove() {
        Iterator iterator = CollectionTools.collection((Iterator)this.descriptorNodes()).iterator();
        while (iterator.hasNext()) {
            ((DescriptorNode)iterator.next()).remove();
        }
    }

    public String getName() {
        return this.name;
    }

    public Iterator descriptorNodes() {
        return (Iterator)this.descriptorNodesHolder.getValue();
    }

    public int descriptorNodesSize() {
        return this.descriptorNodesHolder.size();
    }

    private void addDescriptorNode(DescriptorNode descriptorNode) {
        this.descriptorNodesHolder.addItem(descriptorNode);
    }

    private void removeDescriptorNode(DescriptorNode descriptorNode) {
        this.descriptorNodesHolder.removeItem(descriptorNode);
    }

    public DescriptorNode descriptorNodeFor(MWDescriptor mWDescriptor) {
        Iterator iterator = this.descriptorNodes();
        while (iterator.hasNext()) {
            DescriptorNode descriptorNode = (DescriptorNode)iterator.next();
            if (descriptorNode.getDescriptor() != mWDescriptor) continue;
            return descriptorNode;
        }
        return null;
    }

    public void addDescriptorNodeFor(MWDescriptor mWDescriptor) {
        DescriptorNode descriptorNode = this.descriptorNodeBuilder.buildDescriptorNode(mWDescriptor, this);
        this.addDescriptorNode(descriptorNode);
        boolean bl = this.hasAnyStateChangeListeners();
        if (bl || this.hasAnyPropertyChangeListeners("displayString")) {
            this.engageDescriptorNodeDisplayString(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("icon")) {
            this.engageDescriptorNodeIcon(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("dirty")) {
            this.engageDescriptorNodeDirty(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.engageDescriptorNodePropertiesPageTitleIcon(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("propertiesPageTitleText")) {
            this.engageDescriptorNodePropertiesPageTitleText(descriptorNode);
        }
        if (bl || this.hasAnyListChangeListeners("branchApplicationProblems")) {
            this.engageDescriptorNodeBranchProblems(descriptorNode);
        }
        this.iconChanged();
        this.dirtyChanged();
        this.propertiesPageTitleIconChanged();
        this.propertiesPageTitleTextChanged();
        this.branchProblemsChanged();
    }

    public void removeDescriptorNodeFor(MWDescriptor mWDescriptor) {
        DescriptorNode descriptorNode = this.descriptorNodeFor(mWDescriptor);
        boolean bl = this.hasAnyStateChangeListeners();
        if (bl || this.hasAnyPropertyChangeListeners("displayString")) {
            this.disengageDescriptorNodeDisplayString(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("icon")) {
            this.disengageDescriptorNodeIcon(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("dirty")) {
            this.disengageDescriptorNodeDirty(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.disengageDescriptorNodePropertiesPageTitleIcon(descriptorNode);
        }
        if (bl || this.hasAnyPropertyChangeListeners("propertiesPageTitleText")) {
            this.disengageDescriptorNodePropertiesPageTitleText(descriptorNode);
        }
        if (bl || this.hasAnyListChangeListeners("branchApplicationProblems")) {
            this.disengageDescriptorNodeBranchProblems(descriptorNode);
        }
        this.removeDescriptorNode(descriptorNode);
        this.descriptorNodeHasBeenRemoved = true;
        this.iconChanged();
        this.dirtyChanged();
        this.propertiesPageTitleIconChanged();
        this.propertiesPageTitleTextChanged();
        this.branchProblemsChanged();
    }

    void projectNodeDirtyFlagChanged(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = (Boolean)propertyChangeEvent.getOldValue();
        boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
        if (bl && !bl2) {
            this.descriptorNodeHasBeenRemoved = false;
            this.dirtyChanged();
        }
    }

    public static interface DescriptorNodeBuilder {
        public DescriptorNode buildDescriptorNode(MWDescriptor var1, DescriptorPackageNode var2);
    }
}

