/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;

final class HierarchyClassSelector
extends AbstractDialog {
    private MWClass leafClass;
    private MWClass selectedClass;
    private JTree hierarchyTree;

    HierarchyClassSelector(MWClass mWClass, WorkbenchContext workbenchContext) throws ClassNotFoundException {
        super(workbenchContext);
        this.leafClass = mWClass;
    }

    MWClass getSelectedClass() {
        return this.selectedClass;
    }

    protected String helpTopicId() {
        return "descriptor.hierarchyClassSelector";
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        this.setTitle(this.resourceRepository().getString("HIERARCHY_CLASS_SELECTOR_DIALOG.title"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("HIERARCHY_CLASS_SELECTOR_DIALOG_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("HIERARCHY_CLASS_SELECTOR_DIALOG_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.initializeHierarchyTree();
        JScrollPane jScrollPane = new JScrollPane(this.hierarchyTree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jLabel.setLabelFor(this.hierarchyTree);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private void initializeHierarchyTree() {
        MWClass mWClass;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setAllowsChildren(true);
        this.hierarchyTree = SwingComponentFactory.buildTree(new DefaultTreeModel(defaultMutableTreeNode));
        this.hierarchyTree.setCellRenderer(this.buildMWClassCellRenderer());
        this.hierarchyTree.setRootVisible(false);
        this.hierarchyTree.setShowsRootHandles(true);
        this.hierarchyTree.setRowHeight(20);
        this.hierarchyTree.setDoubleBuffered(true);
        this.hierarchyTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = ((JTree)mouseEvent.getSource()).getLeadSelectionPath();
                if (treePath != null) {
                    HierarchyClassSelector.this.hierarchyTree.setSelectionPaths(new TreePath[]{treePath});
                    MWClass mWClass = (MWClass)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    HierarchyClassSelector.this.setSelectedClass(mWClass);
                } else {
                    HierarchyClassSelector.this.setSelectedClass(null);
                }
            }
        });
        Stack<MWClass> stack = new Stack<MWClass>();
        MWClassRepository mWClassRepository = mWClass.getRepository();
        for (mWClass = this.leafClass; mWClass != mWClassRepository.typeFor(Object.class); mWClass = mWClass.getSuperclass()) {
            stack.push(mWClass);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (!stack.empty()) {
            MWClass mWClass2 = (MWClass)stack.pop();
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(mWClass2);
            if (defaultMutableTreeNode.getChildCount() == 0) {
                defaultMutableTreeNode.add(defaultMutableTreeNode3);
            } else {
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        ((DefaultTreeModel)this.hierarchyTree.getModel()).reload();
        this.hierarchyTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    protected Component initialFocusComponent() {
        return this.hierarchyTree;
    }

    private TreeCellRenderer buildMWClassCellRenderer() {
        return new SimpleTreeCellRenderer(){

            protected String buildText(Object object) {
                MWClass mWClass = (MWClass)((DefaultMutableTreeNode)object).getUserObject();
                return mWClass == null ? "" : mWClass.getName();
            }

            protected Icon buildIcon(Object object) {
                return null;
            }
        };
    }

    protected void setSelectedClass(MWClass mWClass) {
        this.selectedClass = mWClass;
        this.getOKAction().setEnabled(mWClass != null);
    }
}

