/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassIndicatorPolicySubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public abstract class InheritancePolicyPropertiesPage
extends ScrollablePropertiesPage {
    protected static final int EDITOR_WEIGHT = 6;
    private PropertyValueModel inheritancePolicyHolder;
    private PropertyValueModel isRootHolder;
    protected ClassIndicatorPolicySubPanel classIndicatorPolicyPanel;

    public InheritancePolicyPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.inheritancePolicyHolder = this.buildInheritancePolicyHolder();
        this.isRootHolder = this.buildIsRootHolder();
    }

    protected MWMappingDescriptor getDescriptor() {
        return (MWMappingDescriptor)this.getSelectionHolder().getValue();
    }

    protected MWDescriptorInheritancePolicy getInheritancePolicy() {
        return (MWDescriptorInheritancePolicy)this.inheritancePolicyHolder.getValue();
    }

    protected abstract String helpTopicIdPrefix();

    protected String helpTopicId() {
        return this.helpTopicIdPrefix() + ".inheritance";
    }

    protected void addRootListener(final RootListener rootListener) {
        this.getIsRootHolder().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                rootListener.updateRootStatus(bl);
            }
        });
    }

    protected void addAllRootListeners(Collection collection) {
        for (RootListener rootListener : collection) {
            this.addRootListener(rootListener);
        }
    }

    private void setEverythingEnabled(Container container, boolean bl) {
        container.setEnabled(bl);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            this.setEverythingEnabled((Container)component, bl);
        }
    }

    protected PropertyChangeListener buildIsChildListener(final Container container) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.FALSE.equals(propertyChangeEvent.getNewValue());
                InheritancePolicyPropertiesPage.this.setEverythingEnabled(container, bl);
            }
        };
    }

    protected RadioButtonModelAdapter buildIsRootParentDescriptorRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.TRUE);
    }

    protected RadioButtonModelAdapter buildIsChildDescriptorRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.FALSE);
    }

    protected PropertyValueModel buildIsRootHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "isRoot"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).isRoot();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorInheritancePolicy)this.subject).setIsRoot(((Boolean)object).booleanValue());
            }
        };
    }

    private PropertyValueModel buildProjectHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getProject();
            }
        };
    }

    public static DefaultListChooserDialog.Builder buildParentDescriptorChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("PARENT_DESCRIPTOR_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("PARENT_DESCRIPTOR_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(InheritancePolicyPropertiesPage.buildDescriptorStringConverter());
        return builder;
    }

    private static StringConverter buildDescriptorStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWDescriptor)object).shortName();
            }
        };
    }

    private ListChooser buildParentDescriptorChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildParentDescriptorComboBoxModel(), this.getWorkbenchContextHolder(), MappingComponentFactory.buildDescriptorNodeSelector(this.getWorkbenchContextHolder()), InheritancePolicyPropertiesPage.buildParentDescriptorChooserDialogBuilder());
        defaultListChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository())));
        return defaultListChooser;
    }

    private CachingComboBoxModel buildParentDescriptorComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildParentDescriptorHolder(), this.inheritancePolicyHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return InheritancePolicyPropertiesPage.this.sortedCandidateParentDescriptors((MWDescriptorInheritancePolicy)object);
            }
        });
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "parentDescriptor"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).getParentDescriptor();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorInheritancePolicy)this.subject).setParentDescriptor((MWDescriptor)((MWMappingDescriptor)object));
            }
        };
    }

    private ListIterator sortedCandidateParentDescriptors(MWDescriptorInheritancePolicy mWDescriptorInheritancePolicy) {
        return CollectionTools.sort((Iterator)mWDescriptorInheritancePolicy.candidateParentDescriptors()).listIterator();
    }

    protected ButtonModel buildIsRootDescriptorCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.isRootHolder);
    }

    private PropertyValueModel buildInheritancePolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "inheritancePolicy"){

            protected Object getValueFromSubject() {
                MWInheritancePolicy mWInheritancePolicy = ((MWMappingDescriptor)this.subject).getInheritancePolicy();
                return mWInheritancePolicy.isActive() ? mWInheritancePolicy : null;
            }
        };
    }

    protected JPanel buildIsChildPanel(boolean bl) {
        JPanel jPanel = new JPanel(new BorderLayout());
        ListChooser listChooser = this.buildParentDescriptorChooser();
        listChooser.setEnabled(bl);
        JLabel jLabel = this.buildLabel("PARENT_DESC");
        jLabel.setEnabled(bl);
        jLabel.setLabelFor(listChooser);
        jPanel.add((Component)jLabel, "Before");
        jPanel.add((Component)listChooser, "Center");
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".parentDesc");
        return jPanel;
    }

    protected PropertyValueModel getInheritancePolicyHolder() {
        return this.inheritancePolicyHolder;
    }

    protected PropertyValueModel getIsRootHolder() {
        return this.isRootHolder;
    }

    public ClassIndicatorPolicySubPanel getClassIndicatorPolicyPanel() {
        return this.classIndicatorPolicyPanel;
    }
}

