/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.PackageNameDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class MoveDescriptorAction
extends AbstractFrameworkAction {
    MoveDescriptorAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.setIcon(EMPTY_ICON);
        this.initializeTextAndMnemonic("MOVE_DESCRIPTOR_ACTION");
        this.initializeToolTipText("MOVE_DESCRIPTOR_ACTION.tooltip");
    }

    protected void execute() {
        String string = this.promptForPackageName(this.selectedNodes()[0]);
        if (string != null) {
            ApplicationNode[] applicationNodeArray = this.selectedNodes();
            int n = applicationNodeArray.length;
            TreePath[] treePathArray = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                treePathArray[i] = this.renameDescriptor((DescriptorNode)applicationNodeArray[i], string);
            }
            this.navigatorSelectionModel().setSelectionPaths(treePathArray);
        }
    }

    private TreePath renameDescriptor(DescriptorNode descriptorNode, String string) {
        MWDescriptor mWDescriptor = (MWDescriptor)descriptorNode.getValue();
        MWClass mWClass = mWDescriptor.getMWClass();
        mWClass.setName(string + "." + mWClass.shortName());
        mWDescriptor.setName(string + "." + mWClass.shortName());
        return new TreePath(descriptorNode.getProjectRoot().descendantNodeForValue((Node)mWDescriptor).path());
    }

    private String promptForPackageName(ApplicationNode applicationNode) {
        PackageNameDialog packageNameDialog = new PackageNameDialog(this.getWorkbenchContext(), this.buildPackageNamesCollectionHolder(applicationNode));
        packageNameDialog.show();
        if (packageNameDialog.wasConfirmed()) {
            return packageNameDialog.getPackageName();
        }
        return null;
    }

    private CollectionValueModel buildPackageNamesCollectionHolder(ApplicationNode applicationNode) {
        return new SimpleCollectionValueModel(CollectionTools.collection((Iterator)((MWProject)applicationNode.getProjectRoot().getValue()).packageNames()));
    }
}

