/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.UiDescriptorRelationalBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.UiQueryBundle;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public class InterfaceDescriptorPropertiesPage
extends TitledPropertiesPage {
    private static final Class[] REQUIRED_RESOURCE_BUNDLES = new Class[]{UiCommonBundle.class, UiQueryBundle.class, UiDescriptorBundle.class, UiDescriptorRelationalBundle.class};

    public InterfaceDescriptorPropertiesPage(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        LabelArea labelArea = new LabelArea();
        labelArea.setText(this.resourceRepository().getString("CHOOSE_DESCRIPTORS_THAT_IMPLEMENT_LABEL"));
        labelArea.setFont(labelArea.getFont().deriveFont(1));
        labelArea.setScrollable(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)labelArea, gridBagConstraints);
        JLabel jLabel = this.buildLabel("IMPLEMENTORS_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveAdapter(), this.buildImplementorsListValueModel());
        addRemoveListPanel.setCellRenderer(this.buildImplementorsListCellRenderer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.addHelpTopicId(addRemoveListPanel, this.helpTopicId() + ".implementors");
        jPanel.add((Component)addRemoveListPanel, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("COMMON_QUERY_KEYS_LABEL");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JList jList = SwingComponentFactory.buildList(this.buildQueryKeyListModel());
        jList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(jList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.addHelpTopicId(jScrollPane, this.helpTopicId() + ".commonQueryKeys");
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JComponent jComponent = SwingComponentFactory.buildCommentPanel(this.getSelectionHolder(), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, "descriptor.general.comment");
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private AddRemovePanel.Adapter buildAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                ClassDescriptionRepository classDescriptionRepository = this.buildClassDescriptionRepository();
                ClassDescriptionAdapter classDescriptionAdapter = this.buildClassDescriptionAdapter();
                MultipleClassChooserDialog multipleClassChooserDialog = this.buildMultipleClassChooserDialog(classDescriptionRepository, classDescriptionAdapter);
                multipleClassChooserDialog.setTitle(InterfaceDescriptorPropertiesPage.this.resourceRepository().getString("IMPLEMENTOR_DESCRIPTOR_LIST_BROWSER_DIALOG.title"));
                multipleClassChooserDialog.show();
                if (multipleClassChooserDialog.wasConfirmed()) {
                    MWInterfaceDescriptor mWInterfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                    Iterator iterator = multipleClassChooserDialog.selectedClassDescriptions();
                    while (iterator.hasNext()) {
                        MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)iterator.next();
                        mWInterfaceDescriptor.addImplementor((MWDescriptor)mWTableDescriptor);
                    }
                }
                multipleClassChooserDialog = null;
                MultipleClassChooserDialog.gc();
            }

            private MultipleClassChooserDialog buildMultipleClassChooserDialog(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter) {
                MultipleClassChooserDialog multipleClassChooserDialog = new MultipleClassChooserDialog(InterfaceDescriptorPropertiesPage.this.getWorkbenchContext(), classDescriptionRepository, classDescriptionAdapter){

                    protected Iterator buildCustomActions() {
                        return NullIterator.instance();
                    }

                    protected String helpTopicId() {
                        return "dialog.chooseImplementorDescriptor";
                    }
                };
                return multipleClassChooserDialog;
            }

            private ClassDescriptionAdapter buildClassDescriptionAdapter() {
                ClassDescriptionAdapter classDescriptionAdapter = new ClassDescriptionAdapter(){

                    public String additionalInfo(Object object) {
                        return null;
                    }

                    public String className(Object object) {
                        return ((MWDescriptor)object).getMWClass().getName();
                    }

                    public String packageName(Object object) {
                        return ((MWDescriptor)object).packageName();
                    }

                    public String shortClassName(Object object) {
                        return ((MWDescriptor)object).shortName();
                    }
                };
                return classDescriptionAdapter;
            }

            private ClassDescriptionRepository buildClassDescriptionRepository() {
                ClassDescriptionRepository classDescriptionRepository = new ClassDescriptionRepository(){

                    public Iterator classDescriptions() {
                        ArrayList<MWDescriptor> arrayList = new ArrayList<MWDescriptor>();
                        MWInterfaceDescriptor mWInterfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                        Iterator iterator = ((MWRelationalProject)mWInterfaceDescriptor.getProject()).descriptorsThatImplement((MWRelationalDescriptor)mWInterfaceDescriptor);
                        while (iterator.hasNext()) {
                            MWDescriptor mWDescriptor = (MWDescriptor)iterator.next();
                            if (mWDescriptor.getMWClass().isInterface() || CollectionTools.contains((Iterator)mWInterfaceDescriptor.implementors(), (Object)mWDescriptor)) continue;
                            arrayList.add(mWDescriptor);
                        }
                        return arrayList.iterator();
                    }

                    public void refreshClassDescriptions() {
                    }
                };
                return classDescriptionRepository;
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                MWInterfaceDescriptor mWInterfaceDescriptor = (MWInterfaceDescriptor)InterfaceDescriptorPropertiesPage.this.selection();
                Iterator iterator = CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues());
                while (iterator.hasNext()) {
                    mWInterfaceDescriptor.removeImplementor((MWDescriptor)iterator.next());
                }
            }
        };
    }

    private ListValueModel buildImplementorsListValueModel() {
        return new CollectionListValueModelAdapter(this.buildImplementorsCollectionModel());
    }

    private CollectionValueModel buildImplementorsCollectionModel() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "implementors"){

            protected Iterator getValueFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).implementors();
            }

            protected int sizeFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).implementorsSize();
            }
        };
    }

    private ListCellRenderer buildImplementorsListCellRenderer() {
        return new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository()));
    }

    private ListModel buildQueryKeyListModel() {
        return new ListModelAdapter(this.buildQueryNamesCollectionModel());
    }

    private CollectionValueModel buildQueryNamesCollectionModel() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "implementors"){

            protected CollectionChangeListener buildCollectionChangeListener() {
                return new CollectionChangeListener(){

                    public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                        this.fireCollectionChanged("value");
                    }

                    public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                        this.fireCollectionChanged("value");
                    }

                    public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                        this.fireCollectionChanged("value");
                    }
                };
            }

            protected Iterator getValueFromSubject() {
                return ((MWInterfaceDescriptor)this.subject).allQueryKeyNames();
            }
        };
    }

    public String helpTopicId() {
        return "descriptor.interface";
    }
}

