/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.TransactionalDescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class RelationalDescriptorComponentFactory
extends TransactionalDescriptorComponentFactory {
    RelationalDescriptorComponentFactory() {
    }

    static DefaultListChooserDialog buildReturningPolicyFieldDialog(MWRelationalClassDescriptor mWRelationalClassDescriptor, Collection collection, WorkbenchContext workbenchContext, String string) {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATABASE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(RelationalDescriptorComponentFactory.buildColumnStringConverter());
        builder.setListCellRenderer(RelationalDescriptorComponentFactory.buildColumnRenderer(workbenchContext.getApplicationContext().getResourceRepository()));
        builder.setHelpTopicId(string);
        Collection collection2 = RelationalDescriptorComponentFactory.buildEligibleColumns(mWRelationalClassDescriptor, collection);
        builder.setCompleteList(CollectionTools.array(collection2.iterator(), (Object[])new MWColumn[collection2.size()]));
        return new DefaultListChooserDialog(workbenchContext, builder);
    }

    private static StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWColumn)object).qualifiedName();
            }
        };
    }

    private static ListCellRenderer buildColumnRenderer(ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(resourceRepository));
    }

    private static Collection buildEligibleColumns(MWRelationalClassDescriptor mWRelationalClassDescriptor, Collection collection) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = mWRelationalClassDescriptor.associatedTables();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            CollectionTools.addAll(treeSet, (Iterator)RelationalDescriptorComponentFactory.findEligibleColumns(mWTable.columns(), collection));
        }
        return treeSet;
    }

    private static Iterator findEligibleColumns(Iterator iterator, final Collection collection) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return !collection.contains(object);
            }
        };
    }
}

