/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class RelationalLockingColumnsPanel
extends AbstractSubjectPanel {
    RelationalLockingColumnsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
        this.initializeLayout();
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.add((Component)this.buildColumnLockingColumnsList(), gridBagConstraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildColumnLockingColumnsList() {
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildSortedColumnLockingColumnsHolder(), 3, this.resourceRepository().getString("LOCKING_POLICY_SELECTED_FIELDS_LOCKING"), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()));
        addRemoveListPanel.setBorder(this.buildStandardEmptyBorder());
        addRemoveListPanel.setCellRenderer(this.buildColumnLockingColumnsListCellRenderer());
        return addRemoveListPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                objectListSelectionModel.setSelectedValues(RelationalLockingColumnsPanel.this.addColumnLockingColumns());
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                RelationalLockingColumnsPanel.this.removeColumnLockingColumns(objectListSelectionModel.getSelectedValues());
            }
        };
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    Object[] addColumnLockingColumns() {
        Object[] objectArray = new LockingColumnDialog(this.getWorkbenchContext()).promptForPrimaryKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            ((MWTableDescriptorLockingPolicy)this.relationalDescriptor().getLockingPolicy()).addColumnLockColumn((MWColumn)objectArray[i]);
        }
        return objectArray;
    }

    void removeColumnLockingColumns(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            ((MWTableDescriptorLockingPolicy)this.relationalDescriptor().getLockingPolicy()).removeColumnLockColumn((MWColumn)objectArray[i]);
        }
    }

    private ListValueModel buildSortedColumnLockingColumnsHolder() {
        return new SortedListValueModelAdapter(this.buildNamedColumnLockingColumnsHolder());
    }

    private ListValueModel buildNamedColumnLockingColumnsHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnLockingColumnsHolder(), "qualifiedName", "databaseType");
    }

    private CollectionValueModel buildColumnLockingColumnsHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "columnLockColumns"){

            protected Iterator getValueFromSubject() {
                return ((MWTableDescriptorLockingPolicy)this.subject).columnLockColumns();
            }
        };
    }

    private ListCellRenderer buildColumnLockingColumnsListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private MWTableDescriptor relationalDescriptor() {
        return ((MWTableDescriptorLockingPolicy)this.getSubjectHolder().getValue()).getOwningTableDescriptor();
    }

    protected ValueModel getSubjectHolder() {
        return super.getSubjectHolder();
    }

    public String helpTopicId() {
        return "descriptor.locking.selectedfields";
    }

    private class LockingColumnDialog
    extends AbstractDialog {
        private ListModel lockingColumnsModel;
        private ObjectListSelectionModel lockingColumnsSelectionModel;

        LockingColumnDialog(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            super.initialize();
            this.lockingColumnsModel = this.buildPrimaryKeyListAdapter();
            this.lockingColumnsSelectionModel = this.buildLockingColumnsSelectionModel();
            this.setTitle(this.resourceRepository().getString("LOCKING_ADD_REMOVE_DIALOG_TITLE"));
            this.getOKAction().setEnabled(false);
        }

        private ListModel buildPrimaryKeyListAdapter() {
            return new ListModelAdapter(this.buildSortedColumnsHolder());
        }

        private ListValueModel buildSortedColumnsHolder() {
            return new SortedListValueModelAdapter(this.buildAllColumnsCollectionHolder());
        }

        private CollectionValueModel buildAllColumnsCollectionHolder() {
            return new CompositeCollectionValueModel(this.buildSortedTablesHolder()){

                protected CollectionValueModel transform(Object object) {
                    return new ListCollectionValueModelAdapter(LockingColumnDialog.this.buildSortedColumnsHolder((MWTable)object));
                }
            };
        }

        private ListValueModel buildSortedTablesHolder() {
            return new SortedListValueModelAdapter(this.buildTableNameAdapter());
        }

        private ListValueModel buildTableNameAdapter() {
            return new ItemPropertyListValueModelAdapter(this.buildTablesHolder(), "qualifiedName");
        }

        private CollectionValueModel buildTablesHolder() {
            return new CollectionAspectAdapter(RelationalLockingColumnsPanel.this.getSubjectHolder()){

                protected Iterator getValueFromSubject() {
                    return ((MWTableDescriptorLockingPolicy)this.subject).getOwningTableDescriptor().associatedTables();
                }
            };
        }

        ListValueModel buildSortedColumnsHolder(MWTable mWTable) {
            return new SortedListValueModelAdapter(this.buildColumnNameAdapter(mWTable));
        }

        private ListValueModel buildColumnNameAdapter(MWTable mWTable) {
            return new ItemPropertyListValueModelAdapter((CollectionValueModel)this.buildColumnsHolder(mWTable), "name");
        }

        private CollectionAspectAdapter buildColumnsHolder(MWTable mWTable) {
            return new CollectionAspectAdapter("columns", (Model)mWTable){

                protected Iterator getValueFromSubject() {
                    return ((MWTable)this.subject).columns();
                }

                protected int sizeFromSubject() {
                    return ((MWTable)this.subject).columnsSize();
                }
            };
        }

        private ObjectListSelectionModel buildLockingColumnsSelectionModel() {
            ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(this.lockingColumnsModel);
            objectListSelectionModel.addListSelectionListener(this.buildSelectionListener());
            return objectListSelectionModel;
        }

        private ListSelectionListener buildSelectionListener() {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        LockingColumnDialog.this.selectionChanged();
                    }
                }
            };
        }

        void selectionChanged() {
            this.getOKAction().setEnabled(!this.lockingColumnsSelectionModel.isSelectionEmpty());
        }

        protected Component buildMainPanel() {
            JList jList = SwingComponentFactory.buildList(this.lockingColumnsModel);
            jList.setSelectionModel(this.lockingColumnsSelectionModel);
            jList.setSelectionMode(2);
            jList.setCellRenderer(this.buildListCellRenderer());
            jList.addMouseListener(this.buildListMouseListener());
            return new JScrollPane(jList);
        }

        private ListCellRenderer buildListCellRenderer() {
            return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
        }

        protected MouseListener buildListMouseListener() {
            return new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        LockingColumnDialog.this.clickOK();
                    }
                }
            };
        }

        protected void clickOK() {
            super.clickOK();
        }

        protected String helpTopicId() {
            return RelationalLockingColumnsPanel.this.helpTopicId();
        }

        Object[] promptForPrimaryKeys() {
            this.show();
            if (this.wasConfirmed()) {
                return this.lockingColumnsSelectionModel.getSelectedValues();
            }
            return new Object[0];
        }
    }
}

