/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToFieldMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.utility.string.SimpleStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class TableGenerator {
    private WorkbenchContext workbenchContext;
    private Collection classDescriptors;
    private HashMap descriptorLookup;
    private HashMap tableLookup;
    private MWRelationalProject project;
    private Vector log;
    private HashMap relationshipTableLookup;
    private int tableCreatedCount;
    protected static HashMap primitiveToJavaTypeMap;
    protected final int ATTR_TYPE = 0;
    protected final int ITEM_TYPE = 1;

    TableGenerator(WorkbenchContext workbenchContext) {
        this.initialize(workbenchContext);
    }

    protected void initialize(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.descriptorLookup = new HashMap();
        this.tableLookup = new HashMap();
        this.relationshipTableLookup = new HashMap();
        this.log = new Vector();
    }

    public StatusDialog.Status generateTablesFromDescriptors(Collection collection) {
        MWDescriptor mWDescriptor = (MWDescriptor)collection.iterator().next();
        this.setProject((MWRelationalProject)mWDescriptor.getProject());
        this.setClassDescriptors(this.sortTableDescriptors(collection));
        this.runGenerateTables();
        this.generationCompleted();
        if (collection.size() == 1) {
            return StatusDialog.createStatus((Object)mWDescriptor, this.log);
        }
        return StatusDialog.createStatus((Object)this.project, this.log);
    }

    private void generationCompleted() {
        if (this.log.isEmpty()) {
            this.log.add(new MWError("TABLE_GENERATOR_SUCCESSFUL"));
        }
    }

    protected void runGenerateTables() {
        MWMapping mWMapping;
        MWClassAttribute mWClassAttribute;
        Iterator iterator;
        int n = 0;
        for (MWTableDescriptor mWTableDescriptor : this.getClassDescriptors()) {
            ++n;
            this.createTableIfAbsent(mWTableDescriptor);
            mWTableDescriptor.setActive(true);
        }
        n = 0;
        for (MWTableDescriptor mWTableDescriptor : this.getClassDescriptors()) {
            iterator = mWTableDescriptor.getMWClass().attributes();
            while (iterator.hasNext()) {
                mWClassAttribute = (MWClassAttribute)iterator.next();
                mWMapping = mWTableDescriptor.mappingForAttribute(mWClassAttribute);
                if (mWMapping != null) continue;
                mWTableDescriptor.addDirectMapping(mWClassAttribute);
            }
            iterator = mWTableDescriptor.mappings();
            while (iterator.hasNext()) {
                mWClassAttribute = (MWMapping)iterator.next();
                mWMapping = mWClassAttribute.getParentDescriptor().getMWClass();
                this.generateForNonCollectionMapping((MWMapping)mWClassAttribute, (MWClass)mWMapping);
            }
            ++n;
        }
        n = 0;
        for (MWTableDescriptor mWTableDescriptor : this.getClassDescriptors()) {
            iterator = mWTableDescriptor.mappings();
            while (iterator.hasNext()) {
                mWClassAttribute = (MWMapping)iterator.next();
                mWMapping = mWClassAttribute.getParentDescriptor().getMWClass();
                this.generateForCollectionMapping((MWMapping)mWClassAttribute, (MWClass)mWMapping);
            }
            ++n;
        }
    }

    protected MWOneToOneMapping backpointerFor(MWMapping mWMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWMapping mWMapping2;
        MWClassAttribute mWClassAttribute;
        MWClass mWClass2 = mWClassArray[this.ITEM_TYPE];
        MWTableDescriptor mWTableDescriptor = this.locateDescriptorFor(mWClass2);
        Iterator iterator = mWClass2.attributes();
        while (iterator.hasNext()) {
            mWClassAttribute = (MWClassAttribute)iterator.next();
            if (mWClassAttribute.getType() != mWClass && (!mWClassAttribute.isValueHolder() || mWClassAttribute.getValueType() != mWClass) || (mWMapping2 = mWTableDescriptor.mappingNamed(mWClassAttribute.getName())) == null || mWClassAttribute.getType().isAssignableToCollection()) continue;
            if (mWMapping2 instanceof MWOneToOneMapping) {
                return (MWOneToOneMapping)mWMapping2;
            }
            return mWMapping2.asMWOneToOneMapping();
        }
        iterator = mWTableDescriptor.mappings();
        while (iterator.hasNext()) {
            mWClassAttribute = (MWMapping)iterator.next();
            if (!(mWClassAttribute instanceof MWOneToOneMapping) || (mWMapping2 = (MWOneToOneMapping)mWClassAttribute).getReferenceDescriptor().getMWClass() != mWClass) continue;
            return mWMapping2;
        }
        return null;
    }

    protected Collection copyInheritedPrimaryKeys(MWTableDescriptor mWTableDescriptor, MWTableDescriptor mWTableDescriptor2) {
        MWColumn mWColumn;
        Object object;
        MWTableDescriptor mWTableDescriptor3 = mWTableDescriptor;
        boolean bl = false;
        while (!bl) {
            object = this.locateDescriptorFor(mWTableDescriptor3.getMWClass().getSuperclass());
            if (object == null) {
                bl = true;
                continue;
            }
            mWTableDescriptor3 = object;
        }
        if (!mWTableDescriptor3.getInheritancePolicy().isActive()) {
            mWTableDescriptor3.addInheritancePolicy();
        }
        ((MWDescriptorInheritancePolicy)mWTableDescriptor3.getInheritancePolicy()).setIsRoot(true);
        if (mWTableDescriptor3.primaryKeysSize() == 0) {
            this.logError(this.resourceRepository().getString("unableToFindKeyFieldsForInSuperclasses", new Object[]{mWTableDescriptor2.getMWClass().shortName()}));
            object = new ArrayList();
            ((ArrayList)object).add(this.fabricateKeyFor(mWTableDescriptor2.getMWClass(), this.getTableFor(mWTableDescriptor2.getMWClass())));
            return object;
        }
        object = mWTableDescriptor2.getPrimaryTable();
        Iterator iterator = mWTableDescriptor3.primaryKeys();
        while (iterator.hasNext()) {
            mWColumn = (MWColumn)iterator.next();
            if (object.containsColumnNamed(mWColumn.getName())) continue;
            ((MWRelationalTransactionalPolicy)mWTableDescriptor2.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(object.addColumnLike(mWColumn));
        }
        if (!mWTableDescriptor2.getInheritancePolicy().isActive()) {
            mWTableDescriptor2.addInheritancePolicy();
        }
        iterator = (MWDescriptorInheritancePolicy)mWTableDescriptor2.getInheritancePolicy();
        mWColumn = iterator.getClassIndicatorPolicy();
        iterator.setIsRoot(false);
        iterator.setParentDescriptor((MWDescriptor)mWTableDescriptor);
        return null;
    }

    protected HashMap copyPrimaryKeyColumns(MWTable mWTable, MWTable mWTable2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = mWTable.primaryKeyColumns();
        while (iterator.hasNext()) {
            MWColumn mWColumn = (MWColumn)iterator.next();
            MWColumn mWColumn2 = mWTable2.addColumnLike(mWColumn);
            mWColumn2.setName(this.newColumnName(mWTable2, mWTable.getName() + "_" + mWColumn.getName()));
            hashMap.put(mWColumn.getName(), mWColumn2.getName());
            mWColumn2.setPrimaryKey(false);
        }
        return hashMap;
    }

    protected MWColumn createColumn(String string, MWTable mWTable, MWColumn mWColumn) {
        String string2 = this.newColumnName(mWTable, string);
        MWColumn mWColumn2 = mWTable.addColumn(string2);
        mWColumn2.setDatabaseType(mWColumn.getDatabaseType());
        return mWColumn2;
    }

    protected MWColumn createColumn(String string, String string2, int n, MWTable mWTable) {
        String string3 = this.newColumnName(mWTable, string);
        DatabaseType databaseType = null;
        try {
            databaseType = this.getDatabase().getDatabasePlatform().databaseTypeForJavaTypeDeclaration(string2, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            databaseType = this.getDatabase().getDatabasePlatform().defaultDatabaseType();
        }
        MWColumn mWColumn = mWTable.addColumn(string3);
        mWColumn.setDatabaseType(databaseType);
        return mWColumn;
    }

    protected MWColumn createPrimaryKeyColumn(String string, String string2, int n, MWTable mWTable) {
        MWColumn mWColumn = this.createColumn(string, string2, n, mWTable);
        mWColumn.setPrimaryKey(true);
        return mWColumn;
    }

    protected void createPrimaryKeyFields(MWClass mWClass, MWTable mWTable) {
        Object object;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        MWTableDescriptor mWTableDescriptor = this.locateDescriptorFor(mWClass.getSuperclass());
        if (mWTableDescriptor != null && (object = this.copyInheritedPrimaryKeys(mWTableDescriptor, this.getDescriptorFor(mWClass))) == null) {
            return;
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(this.defaultKeysFor(mWClass, mWTable));
        }
        if (arrayList.isEmpty()) {
            arrayList.add(this.fabricateKeyFor(mWClass, mWTable));
        }
        for (Object[] objectArray : arrayList) {
            MWClassAttribute mWClassAttribute = (MWClassAttribute)objectArray[0];
            MWColumn mWColumn = (MWColumn)objectArray[1];
            MWTableDescriptor mWTableDescriptor2 = this.getDescriptorFor(mWClass);
            MWMapping mWMapping = mWTableDescriptor2.mappingForAttribute(mWClassAttribute);
            if (mWMapping != null) {
                mWTableDescriptor2.removeMapping(mWMapping);
            }
            MWDirectToFieldMapping mWDirectToFieldMapping = (MWDirectToFieldMapping)mWTableDescriptor2.addDirectMapping(mWClassAttribute);
            mWDirectToFieldMapping.setColumn(mWColumn);
            mWDirectToFieldMapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
            ((MWRelationalTransactionalPolicy)mWTableDescriptor2.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(mWColumn);
        }
    }

    protected MWReference createReferenceIfAbsent(MWTable mWTable, MWTable mWTable2, HashMap hashMap) {
        String string = mWTable.getName() + "_" + mWTable2.getName();
        MWReference mWReference = mWTable.referenceNamed(string);
        if (mWReference != null) {
            return mWReference;
        }
        mWReference = mWTable.addReference(string, mWTable2);
        Iterator iterator = mWTable2.primaryKeyColumns();
        while (iterator.hasNext()) {
            MWColumn mWColumn = (MWColumn)iterator.next();
            String string2 = mWColumn.getName();
            if (hashMap != null && hashMap.get(mWColumn.getName()) != null) {
                string2 = (String)hashMap.get(mWColumn.getName());
            }
            MWColumn mWColumn2 = mWTable.columnNamed(string2);
            mWReference.addColumnPair(mWColumn2, mWColumn);
        }
        return mWReference;
    }

    protected MWTable createTableIfAbsent(MWTableDescriptor mWTableDescriptor) {
        MWClass mWClass = mWTableDescriptor.getMWClass();
        if (mWClass.attributesSize() == 0 && mWTableDescriptor.mappingsSize() == 0) {
            MWTableDescriptor mWTableDescriptor2;
            if (mWClass.getSuperclass() != null && (mWTableDescriptor2 = this.getDescriptorFor(mWClass.getSuperclass())) != null) {
                mWTableDescriptor.setPrimaryTable(mWTableDescriptor2.getPrimaryTable());
            }
            return null;
        }
        MWTable mWTable = mWTableDescriptor.getPrimaryTable();
        if (mWTable == null) {
            String string = mWClass.defaultTableNameWithLength(this.getTableNameLength());
            mWTable = this.getDatabase().addTable(this.newTableName(string));
            ++this.tableCreatedCount;
            mWTableDescriptor.setPrimaryTable(mWTable);
        }
        this.tableLookup.put(mWClass, mWTable);
        if (!mWTable.primaryKeyColumns().hasNext()) {
            this.createPrimaryKeyFields(mWClass, mWTable);
        }
        return mWTable;
    }

    public static String defaultAbstractClassIndicatorFieldName() {
        return "SUBCLASS";
    }

    protected Collection defaultKeysFor(MWClass mWClass, MWTable mWTable) {
        MWColumn mWColumn;
        MWClassAttribute mWClassAttribute;
        String string = this.getProject().getTableGenerationPolicy().getPrimaryKeySearchPattern();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = mWClass.attributes();
        while (iterator.hasNext()) {
            mWClassAttribute = (MWClassAttribute)iterator.next();
            if (!new SimpleStringMatcher(string, true).matches(mWClassAttribute.getName()) || (mWColumn = this.createPrimaryKeyColumn(mWClassAttribute.getName(), mWClassAttribute.typeName(), mWClassAttribute.getDimensionality(), mWTable)) == null) continue;
            arrayList.add(new Object[]{mWClassAttribute, mWColumn});
        }
        if (arrayList.isEmpty()) {
            iterator = mWClass.allAttributes();
            while (iterator.hasNext()) {
                mWClassAttribute = (MWClassAttribute)iterator.next();
                if (!new SimpleStringMatcher(string, true).matches(mWClassAttribute.getName())) continue;
                this.getDescriptorFor(mWClass).addInheritedAttribute(mWClassAttribute);
                mWColumn = this.createPrimaryKeyColumn(mWClassAttribute.getName(), mWClassAttribute.typeName(), mWClassAttribute.getDimensionality(), mWTable);
                if (mWColumn == null) continue;
                arrayList.add(new Object[]{mWClassAttribute, mWColumn});
            }
        }
        return arrayList;
    }

    protected MWClass[] determineAttrAndItemType(MWMapping mWMapping, boolean bl) {
        MWClassAttribute mWClassAttribute = mWMapping.getInstanceVariable();
        if (mWClassAttribute == null) {
            return new MWClass[]{null, null};
        }
        MWClass mWClass = null;
        MWClass mWClass2 = null;
        if (mWClassAttribute.isValueHolder()) {
            if (!mWClassAttribute.getValueType().isObject()) {
                mWClass = mWClassAttribute.getValueType();
                if (mWClass.isAssignableToCollection()) {
                    mWClass2 = mWClassAttribute.getItemType();
                }
            } else {
                if (bl) {
                    this.logUrgent(this.resourceRepository().getString("VALUE_HOLDER_TYPE_SELECT", new Object[]{mWClassAttribute.getName(), mWClassAttribute.getDeclaringType().getName()}));
                }
                mWClass = mWClassAttribute.getType();
            }
        } else {
            mWClass = mWClassAttribute.getType();
            mWClass2 = mWClassAttribute.getItemType();
        }
        if ((mWClass == null || mWClass2 == null) && mWMapping != null) {
            if (mWMapping.isCollectionMapping()) {
                MWCollectionMapping mWCollectionMapping = (MWCollectionMapping)mWMapping;
                if (mWClass == null) {
                    mWClass = mWCollectionMapping.getContainerPolicy().getDefaultingContainerClass().getContainerClass();
                }
                if (mWClass2 == null && mWCollectionMapping.getReferenceDescriptor() != null) {
                    mWClass2 = mWCollectionMapping.getReferenceDescriptor().getMWClass();
                }
            } else if (mWMapping instanceof MWReferenceMapping) {
                MWReferenceMapping mWReferenceMapping = (MWReferenceMapping)mWMapping;
                if (mWClass == null && mWReferenceMapping.getReferenceDescriptor() != null) {
                    mWClass = mWReferenceMapping.getReferenceDescriptor().getMWClass();
                }
            }
        }
        return new MWClass[]{mWClass, mWClass2};
    }

    protected static boolean directCollectionContentsAreSorted() {
        return true;
    }

    protected static boolean directCollectionContentsAreUnsorted() {
        return !TableGenerator.directCollectionContentsAreSorted();
    }

    protected static boolean directCollectionsHaveUniqueEntries() {
        return true;
    }

    protected Object[] fabricateKeyFor(MWClass mWClass, MWTable mWTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.resourceRepository().getString("noKeyFieldFound", new Object[]{mWClass.shortName()}));
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.resourceRepository().getString("pleaseEditJavaSourceFileAppropriately"));
        this.logUrgent(stringBuffer.toString());
        String string = this.getProject().getTableGenerationPolicy().getDefaultPrimaryKeyName().toLowerCase();
        MWClass mWClass2 = this.getProject().typeFor(Integer.TYPE);
        MWClassAttribute mWClassAttribute = mWClass.addAttribute(string, mWClass2);
        MWColumn mWColumn = this.createPrimaryKeyColumn(mWClassAttribute.getName(), mWClassAttribute.typeName(), mWClassAttribute.getDimensionality(), mWTable);
        return new Object[]{mWClassAttribute, mWColumn};
    }

    protected MWMapping generateForMWAggregateMapping(MWMapping mWMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWAggregateMapping mWAggregateMapping = mWMapping instanceof MWAggregateMapping ? (MWAggregateMapping)mWMapping : mWMapping.asMWAggregateMapping();
        boolean bl = false;
        this.mapAggregateMapping(mWAggregateMapping, mWClassArray, mWClass, bl);
        return mWMapping;
    }

    protected MWCollectionMapping generateForMWCollectionMapping(MWMapping mWMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWCollectionMapping mWCollectionMapping;
        MWClass mWClass2 = mWClassArray[this.ITEM_TYPE];
        if (mWClass2.isInterface() || mWClass2.getName().equals(Object.class.getName())) {
            return null;
        }
        if (mWMapping != null && mWMapping.isCollectionMapping()) {
            mWCollectionMapping = (MWCollectionMapping)mWMapping;
        } else {
            MWOneToOneMapping mWOneToOneMapping = this.backpointerFor(mWMapping, mWClassArray, mWClass);
            if (mWOneToOneMapping == null) {
                this.logNotify(this.resourceRepository().getString("refersToWhichHasNoBackpointer", new Object[]{mWClass.shortName(), mWMapping.getName(), mWClass2.shortName()}));
                mWCollectionMapping = mWMapping.asMWManyToManyMapping();
            } else {
                this.logAssumption(this.resourceRepository().getString("isBackpointerFor", new Object[]{mWClass2.shortName(), mWOneToOneMapping.getName(), mWClass.shortName(), mWMapping.getName()}));
                mWCollectionMapping = mWMapping.asMWOneToManyMapping();
            }
        }
        if (mWCollectionMapping instanceof MWManyToManyMapping) {
            this.mapManyToManyMapping((MWManyToManyMapping)mWCollectionMapping, mWClassArray, mWClass);
        } else {
            this.mapOneToManyMapping((MWOneToManyMapping)mWCollectionMapping, mWClassArray, mWClass);
        }
        mWCollectionMapping.getContainerPolicy().getDefaultingContainerClass().setContainerClass(mWClassArray[this.ATTR_TYPE]);
        mWCollectionMapping.setReferenceDescriptor((MWDescriptor)this.locateDescriptorFor(mWClass2));
        return mWCollectionMapping;
    }

    protected MWMapping generateForMWDirectCollectionMapping(MWMapping mWMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWRelationalDirectCollectionMapping mWRelationalDirectCollectionMapping = mWMapping instanceof MWRelationalDirectCollectionMapping ? (MWRelationalDirectCollectionMapping)mWMapping : (MWRelationalDirectCollectionMapping)mWMapping.asMWDirectCollectionMapping();
        this.mapDirectCollectionMapping(mWRelationalDirectCollectionMapping, mWClassArray, mWClass);
        return mWRelationalDirectCollectionMapping;
    }

    protected MWMapping generateForMWDirectToFieldMapping(MWMapping mWMapping, MWClass mWClass) {
        MWDirectToFieldMapping mWDirectToFieldMapping = mWMapping instanceof MWDirectToFieldMapping ? (MWDirectToFieldMapping)mWMapping : (MWDirectToFieldMapping)mWMapping.asMWDirectMapping();
        this.mapDirectToFieldMapping(mWDirectToFieldMapping, mWClass);
        return mWDirectToFieldMapping;
    }

    protected MWMapping generateForMWOneToOneMapping(MWMapping mWMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWOneToOneMapping mWOneToOneMapping = mWMapping instanceof MWOneToOneMapping ? (MWOneToOneMapping)mWMapping : mWMapping.asMWOneToOneMapping();
        this.mapOneToOneMapping(mWOneToOneMapping, mWClassArray, mWClass);
        return mWOneToOneMapping;
    }

    protected MWMapping generateForCollectionMapping(MWMapping mWMapping, MWClass mWClass) {
        ArrayList arrayList = new ArrayList();
        mWMapping.addWrittenFieldsTo(arrayList);
        if (!((MWRelationalDescriptor)mWMapping.getParentDescriptor()).isAggregateDescriptor() && arrayList.size() > 0) {
            return mWMapping;
        }
        MWClass[] mWClassArray = this.determineAttrAndItemType(mWMapping, false);
        MWClass mWClass2 = mWClassArray[this.ATTR_TYPE];
        MWClass mWClass3 = mWClassArray[this.ITEM_TYPE];
        if (mWMapping instanceof MWDirectCollectionMapping) {
            if (mWClass2 == null) {
                mWClass2 = mWClassArray[this.ATTR_TYPE] = this.getProject().typeFor(Vector.class);
            }
            if (mWClass3 == null) {
                mWClass3 = mWClassArray[this.ITEM_TYPE] = this.getProject().typeFor(String.class);
            }
        }
        if (mWClass2 == null) {
            return null;
        }
        if (mWMapping instanceof MWAggregateMapping) {
            boolean bl = true;
            this.mapAggregateMapping((MWAggregateMapping)mWMapping, mWClassArray, mWClass, bl);
            return mWMapping;
        }
        if (mWClass3 == null || mWClass3.isInterface()) {
            return null;
        }
        if (mWClass2.isAssignableToCollection()) {
            if (this.isDatabaseType(mWClass3)) {
                return this.generateForMWDirectCollectionMapping(mWMapping, mWClassArray, mWClass);
            }
            return this.generateForMWCollectionMapping(mWMapping, mWClassArray, mWClass);
        }
        return null;
    }

    protected MWMapping generateForNonCollectionMapping(MWMapping mWMapping, MWClass mWClass) {
        ArrayList arrayList = new ArrayList();
        mWMapping.addWrittenFieldsTo(arrayList);
        if (!((MWRelationalDescriptor)mWMapping.getParentDescriptor()).isAggregateDescriptor() && arrayList.size() > 0) {
            return mWMapping;
        }
        MWClass[] mWClassArray = this.determineAttrAndItemType(mWMapping, true);
        MWClass mWClass2 = mWClassArray[this.ATTR_TYPE];
        if (mWClass2 == null) {
            return null;
        }
        if (mWClass2.isAssignableToCollection() || mWClass2.isInterface()) {
            return null;
        }
        if (this.isDatabaseType(mWClass2)) {
            return this.generateForMWDirectToFieldMapping(mWMapping, mWClass);
        }
        MWMappingDescriptor mWMappingDescriptor = (MWMappingDescriptor)this.getProject().descriptorForType(mWClass2);
        if (mWMappingDescriptor == null) {
            return null;
        }
        boolean bl = ((MWRelationalDescriptor)mWMappingDescriptor).isAggregateDescriptor();
        if (mWMapping instanceof MWAggregateMapping || bl) {
            return this.generateForMWAggregateMapping(mWMapping, mWClassArray, mWClass);
        }
        return this.generateForMWOneToOneMapping(mWMapping, mWClassArray, mWClass);
    }

    protected static boolean generateIndexColumnsForDirectCollections() {
        return TableGenerator.directCollectionContentsAreUnsorted();
    }

    protected Collection getClassDescriptors() {
        return this.classDescriptors;
    }

    protected int getColumnNameLength() {
        return 30;
    }

    protected MWDatabase getDatabase() {
        return this.getProject().getDatabase();
    }

    protected MWTableDescriptor getDescriptorFor(MWClass mWClass) {
        return (MWTableDescriptor)this.descriptorLookup.get(mWClass);
    }

    protected static HashMap getPrimitiveToJavaTypeMap() {
        if (primitiveToJavaTypeMap == null) {
            TableGenerator.initializePrimitiveToJavaTypeMap();
        }
        return primitiveToJavaTypeMap;
    }

    protected MWRelationalProject getProject() {
        return this.project;
    }

    protected MWTable getRelationshipTableFor(MWClass mWClass, MWClass mWClass2) {
        MWTable mWTable = null;
        for (Collection collection : this.relationshipTableLookup.keySet()) {
            if (!collection.contains(mWClass) || !collection.contains(mWClass2)) continue;
            mWTable = (MWTable)this.relationshipTableLookup.get(collection);
            return mWTable;
        }
        return null;
    }

    protected MWTable getTableFor(MWClass mWClass) {
        return (MWTable)this.tableLookup.get(mWClass);
    }

    protected int getTableNameLength() {
        return 30;
    }

    protected static void initializePrimitiveToJavaTypeMap() {
        primitiveToJavaTypeMap = new HashMap();
        primitiveToJavaTypeMap.put("byte", "java.lang.Byte");
        primitiveToJavaTypeMap.put("short", "java.lang.Short");
        primitiveToJavaTypeMap.put("int", "java.lang.Integer");
        primitiveToJavaTypeMap.put("char", "java.lang.Character");
        primitiveToJavaTypeMap.put("long", "java.lang.Long");
        primitiveToJavaTypeMap.put("double", "java.lang.Double");
        primitiveToJavaTypeMap.put("float", "java.lang.Float");
        primitiveToJavaTypeMap.put("boolean", "java.lang.Boolean");
    }

    protected boolean isByteArray(MWClassAttribute mWClassAttribute) {
        return mWClassAttribute.getType().isBytePrimitive() && mWClassAttribute.getDimensionality() == 1;
    }

    protected boolean isDatabaseType(MWClass mWClass) {
        if (mWClass == null) {
            return false;
        }
        return this.getDatabase().getDatabasePlatform().javaTypeDeclarationCanBeMappedToDatabaseType(mWClass.getName(), 0);
    }

    protected MWTableDescriptor locateDescriptorFor(MWClass mWClass) {
        if (mWClass == null) {
            return null;
        }
        MWTableDescriptor mWTableDescriptor = this.getDescriptorFor(mWClass);
        if (mWTableDescriptor != null) {
            return mWTableDescriptor;
        }
        return (MWTableDescriptor)this.getProject().descriptorForType(mWClass);
    }

    protected void logAssumption(String string) {
        this.log.add(new MWError("TABLE_GENERATOR_ASSUMPTION", (Object)string));
    }

    protected void logError(String string) {
        this.log.add(new MWError("TABLE_GENERATOR_ERROR", (Object)string));
    }

    protected void logNotify(String string) {
        this.log.add(new MWError("TABLE_GENERATOR_WARNING", (Object)string));
    }

    protected void logUrgent(String string) {
        this.log.add(new MWError("TABLE_GENERATOR_URGENT", (Object)string));
    }

    protected void mapAggregateMapping(MWAggregateMapping mWAggregateMapping, MWClass[] mWClassArray, MWClass mWClass, boolean bl) {
        MWMappingDescriptor mWMappingDescriptor = (MWMappingDescriptor)mWAggregateMapping.getReferenceDescriptor();
        if (mWMappingDescriptor == null) {
            mWMappingDescriptor = (MWMappingDescriptor)this.getProject().descriptorForType(mWClassArray[this.ATTR_TYPE]);
        }
        Iterator iterator = mWMappingDescriptor.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (bl) {
                this.generateForCollectionMapping(mWMapping, mWClass);
                continue;
            }
            this.generateForNonCollectionMapping(mWMapping, mWClass);
        }
    }

    protected void mapDirectCollectionMapping(MWRelationalDirectCollectionMapping mWRelationalDirectCollectionMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWClassAttribute mWClassAttribute = mWRelationalDirectCollectionMapping.getInstanceVariable();
        MWClass mWClass2 = mWClassArray[this.ITEM_TYPE];
        MWClass mWClass3 = mWClassArray[this.ATTR_TYPE];
        String string = new String();
        int n = this.getTableNameLength() / 2 - 1;
        String string2 = mWClass.defaultTableNameWithLength(n) + "_TO_" + mWClass2.defaultTableNameWithLength(n);
        MWTable mWTable = this.getDatabase().addTable(this.newTableName(string2));
        HashMap hashMap = this.copyPrimaryKeyColumns(this.getTableFor(mWClass), mWTable);
        MWColumn mWColumn = this.createColumn(mWClassAttribute.getName(), mWClass2.getName(), 0, mWTable);
        if (TableGenerator.directCollectionsHaveUniqueEntries()) {
            string = this.resourceRepository().getString("isUnique", new Object[]{string});
        }
        this.logAssumption(this.resourceRepository().getString("directCollectionHasEntries", new Object[]{mWClass.shortName(), mWClassAttribute.getName(), string}));
        mWRelationalDirectCollectionMapping.setDirectValueColumn(mWColumn);
        mWRelationalDirectCollectionMapping.getContainerPolicy().getDefaultingContainerClass().setContainerClass(mWClass3);
        mWRelationalDirectCollectionMapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
        MWReference mWReference = this.createReferenceIfAbsent(mWTable, this.getTableFor(mWClass), hashMap);
        mWRelationalDirectCollectionMapping.setReference(mWReference);
    }

    protected void mapDirectToFieldMapping(MWDirectToFieldMapping mWDirectToFieldMapping, MWClass mWClass) {
        MWClassAttribute mWClassAttribute = mWDirectToFieldMapping.getInstanceVariable();
        MWTable mWTable = this.getTableFor(mWClass);
        MWColumn mWColumn = this.createColumn(mWClassAttribute.getName(), mWClassAttribute.typeName(), 0, mWTable);
        if (!((MWRelationalDescriptor)mWDirectToFieldMapping.getParentDescriptor()).isAggregateDescriptor()) {
            mWDirectToFieldMapping.setColumn(mWColumn);
        }
    }

    protected void mapManyToManyMapping(MWManyToManyMapping mWManyToManyMapping, MWClass[] mWClassArray, MWClass mWClass) {
        String string;
        MWTable mWTable = this.getTableFor(mWClass);
        if (mWTable == null) {
            return;
        }
        MWClass mWClass2 = mWClassArray[this.ITEM_TYPE];
        MWTableDescriptor mWTableDescriptor = this.locateDescriptorFor(mWClass2);
        if (mWTableDescriptor == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mWManyToManyMapping.getName(), mWClass.shortName(), mWClass2.getName()}));
            return;
        }
        MWTable mWTable2 = mWTableDescriptor.getPrimaryTable();
        if (mWTable2 == null) {
            this.logError(this.resourceRepository().getString("descriptorDoesNotHaveAPrimaryTable", new Object[]{mWTableDescriptor.getMWClass().shortName()}));
            return;
        }
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        MWTable mWTable3 = this.getRelationshipTableFor(mWClass, mWClass2);
        if (mWTable3 == null) {
            int n = this.getTableNameLength() / 2 - 1;
            string = mWClass.defaultTableNameWithLength(n) + "_TO_" + mWClass2.defaultTableNameWithLength(n);
            mWTable3 = this.getDatabase().addTable(this.newTableName(string));
            hashMap = this.copyPrimaryKeyColumns(mWTable, mWTable3);
            hashMap2 = this.copyPrimaryKeyColumns(mWTable2, mWTable3);
            this.registerRelationshipTable(mWTable3, mWClass, mWClass2);
        }
        mWManyToManyMapping.setRelationTable(mWTable3);
        String string2 = mWTable3.getName() + "_" + mWTable.getName();
        string = this.createReferenceIfAbsent(mWTable3, mWTable, hashMap);
        mWManyToManyMapping.setSourceReference((MWReference)string);
        string2 = mWTable3.getName() + "_" + mWTable2.getName();
        MWReference mWReference = this.createReferenceIfAbsent(mWTable3, mWTable2, hashMap2);
        mWManyToManyMapping.setTargetReference(mWReference);
        mWManyToManyMapping.setReferenceDescriptor((MWDescriptor)mWTableDescriptor);
    }

    protected void mapOneToManyMapping(MWOneToManyMapping mWOneToManyMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWClass mWClass2 = mWClassArray[this.ITEM_TYPE];
        if (mWClass2.isInterface()) {
            return;
        }
        MWTableDescriptor mWTableDescriptor = this.locateDescriptorFor(mWClass2);
        if (mWTableDescriptor.getPrimaryTable() == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mWOneToManyMapping.getName(), mWClass.shortName(), mWClass2.getName()}));
            return;
        }
        MWOneToOneMapping mWOneToOneMapping = this.backpointerFor((MWMapping)mWOneToManyMapping, mWClassArray, mWClass);
        if (mWOneToOneMapping == null) {
            this.logUrgent(this.resourceRepository().getString("thereIsNoOneToOneBackpointer", new Object[]{mWOneToManyMapping.getName(), mWClass.shortName()}));
            return;
        }
        MWReference mWReference = mWOneToOneMapping.getReference();
        if (mWReference == null || mWReference.columnPairsSize() == 0) {
            this.logUrgent(this.resourceRepository().getString("errorMapOneToManyMapping"));
            return;
        }
        mWOneToManyMapping.setReference(mWOneToOneMapping.getReference());
        mWOneToManyMapping.setReferenceDescriptor((MWDescriptor)mWTableDescriptor);
    }

    protected void mapOneToOneMapping(MWOneToOneMapping mWOneToOneMapping, MWClass[] mWClassArray, MWClass mWClass) {
        MWTableDescriptor mWTableDescriptor = this.getDescriptorFor(mWClass);
        MWTable mWTable = this.getTableFor(mWClass);
        MWClass mWClass2 = mWClassArray[this.ATTR_TYPE];
        MWTableDescriptor mWTableDescriptor2 = (MWTableDescriptor)this.getProject().descriptorForType(mWClass2);
        if (mWTableDescriptor2 == null) {
            this.logError(this.resourceRepository().getString("couldNotFindMapping", new Object[]{mWOneToOneMapping.getName(), mWTableDescriptor.getName(), mWClass2.getName()}));
            return;
        }
        mWOneToOneMapping.setUsesMethodAccessing(this.getProject().getDefaultsPolicy().isMethodAccessing());
        MWTable mWTable2 = mWTableDescriptor2.getPrimaryTable();
        if (mWTable2 != null && mWTable2.columnsSize() > 0) {
            String string = mWTable.getName() + "_" + mWTable2.getName();
            MWReference mWReference = mWTable.referenceNamed(string);
            if (mWReference == null) {
                mWReference = mWTable.addReference(string, mWTable2);
            }
            Iterator iterator = mWTable2.primaryKeyColumns();
            while (iterator.hasNext()) {
                MWColumn mWColumn = (MWColumn)iterator.next();
                MWColumn mWColumn2 = this.createColumn(mWOneToOneMapping.getName(), mWTable, mWColumn);
                mWReference.addColumnPair(mWColumn2, mWColumn);
            }
            mWOneToOneMapping.setReference(mWReference);
        }
        mWOneToOneMapping.setReferenceDescriptor((MWDescriptor)mWTableDescriptor2);
    }

    protected String mungeName(String string) {
        int n;
        if (string == null || string == "") {
            return "1";
        }
        if (!Character.isDigit(string.charAt(string.length() - 1))) {
            return string + "1";
        }
        for (n = string.length() - 1; n >= 0; --n) {
            if (Character.isDigit(string.charAt(n))) continue;
            ++n;
            break;
        }
        String string2 = string.substring(n);
        int n2 = Integer.parseInt(string2);
        String string3 = String.valueOf(n2 + 1);
        return string.substring(0, n) + string3;
    }

    protected String newColumnName(MWTable mWTable, String string) {
        String string2 = string.replace('$', '_');
        String string3 = StringTools.convertCamelBackToAllCaps((String)string2, (int)this.getColumnNameLength());
        while (mWTable.columnNamed(string3) != null) {
            string3 = this.mungeName(string3);
        }
        return string3;
    }

    protected String newTableName(String string) {
        String string2 = string.replace('$', '_');
        while (this.getDatabase().containsTableNamed(string2)) {
            string2 = this.mungeName(string2);
        }
        return string2;
    }

    protected void registerRelationshipTable(MWTable mWTable, MWClass mWClass, MWClass mWClass2) {
        ArrayList<MWClass> arrayList = new ArrayList<MWClass>();
        arrayList.add(mWClass);
        arrayList.add(mWClass2);
        this.relationshipTableLookup.put(arrayList, mWTable);
    }

    protected void setClassDescriptors(Collection collection) {
        this.classDescriptors = collection;
    }

    protected void setProject(MWRelationalProject mWRelationalProject) {
        this.project = mWRelationalProject;
    }

    protected Collection sortTableDescriptors(Collection collection) {
        Object object;
        ArrayList arrayList;
        Object object22;
        Object object3;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        for (Object e : collection) {
            if (e instanceof MWTableDescriptor) continue;
            arrayList3.add(e);
        }
        collection.removeAll(arrayList3);
        HashMap hashMap = new HashMap();
        int n = 0;
        MWClass mWClass = collection.iterator();
        while (mWClass.hasNext()) {
            ++n;
            object3 = (MWTableDescriptor)mWClass.next();
            object22 = object3.getMWClass();
            this.descriptorLookup.put(object22, object3);
            arrayList = null;
            for (MWTableDescriptor mWTableDescriptor : collection) {
                if (mWTableDescriptor.getMWClass() != object22.getSuperclass()) continue;
                arrayList = mWTableDescriptor;
                break;
            }
            object = new ArrayList(1);
            if (arrayList != null) {
                ((ArrayList)object).add(object22.getSuperclass());
            }
            hashMap.put(object22, object);
        }
        while (!hashMap.isEmpty()) {
            mWClass = null;
            for (Object object22 : hashMap.keySet()) {
                arrayList = (ArrayList)hashMap.get(object22);
                if (!arrayList.isEmpty()) continue;
                mWClass = object22;
            }
            if (mWClass == null) {
                throw new RuntimeException(this.resourceRepository().getString("errorCyclicDependency"));
            }
            object3 = this.getDescriptorFor(mWClass);
            arrayList2.add(object3);
            hashMap.remove(mWClass);
            object22 = hashMap.keySet().iterator();
            while (object22.hasNext()) {
                arrayList = (MWClass)object22.next();
                object = (ArrayList)hashMap.get(arrayList);
                ((ArrayList)object).remove(mWClass);
            }
        }
        return arrayList2;
    }

    private ResourceRepository resourceRepository() {
        return this.workbenchContext.getApplicationContext().getResourceRepository();
    }
}

